/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.JSprogram;

import carmetal.eric.GUI.themes;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class JSButton
extends JButton
implements MouseListener {
    int iconsize = 24;
    boolean isEntered = false;
    boolean isDisabled;
    private String Name;

    @Override
    public void paintComponent(Graphics g) {
        Dimension d2 = this.getSize();
        int w = d2.width;
        int h = d2.height;
        if (g == null) {
            return;
        }
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (this.isDisabled) {
            GrayFilter filter = new GrayFilter(true, 60);
            Image disImage = this.createImage(new FilteredImageSource(themes.getPaletteImage(this.Name).getSource(), filter));
            ImageIcon myicn = new ImageIcon(disImage);
            g2.drawImage(myicn.getImage(), 0, 0, w, h, this);
            return;
        }
        g2.drawImage(themes.getPaletteImage(this.Name), 0, 0, w, h, this);
        if (this.isEntered) {
            AlphaComposite ac = AlphaComposite.getInstance(3, 0.1f);
            g2.setComposite(ac);
            g2.setColor(new Color(0, 0, 80));
            BasicStroke stroke = new BasicStroke(3.0f);
            g2.setStroke(stroke);
            g2.drawRect(1, 1, w - 2, h - 2);
        }
    }

    public JSButton(String name, int size, boolean enabled) {
        this.isDisabled = !enabled;
        this.iconsize = size;
        this.Name = name;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.fixsize(this.iconsize);
        this.addMouseListener(this);
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        this.setFocusable(false);
    }

    private void fixsize(int sze) {
        Dimension d2 = new Dimension(sze, sze);
        this.setMaximumSize(d2);
        this.setMinimumSize(d2);
        this.setPreferredSize(d2);
        this.setSize(d2);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        this.isEntered = true;
        this.repaint();
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.isEntered = false;
        this.repaint();
    }
}

