/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric;

import carmetal.eric.JSelectPopupDialog;
import carmetal.objects.ConstructionObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.MyVector;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.MouseInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JSelectPopup
extends JPopupMenu
implements MouseListener,
PopupMenuListener {
    private static final long serialVersionUID = 1L;
    ZirkelCanvas ZC;
    JSelectPopupDialog D;
    Vector V = new Vector();
    String CallerObject = "RightClick";
    int sx = 0;
    int sy = 0;
    int sw = 0;
    int sh = 0;

    public JSelectPopup(ZirkelCanvas zc, JSelectPopupDialog d2, MyVector v) {
        this.init(zc, v);
        this.D = d2;
        this.addPopupMenuListener(this);
        this.show(this.D.Content, 0, 0);
        this.sx = this.getLocationOnScreen().x;
        this.sy = this.getLocationOnScreen().y;
        this.sw = this.getSize().width;
        this.sh = this.getSize().height;
    }

    public void init(ZirkelCanvas zc, MyVector v) {
        StackTraceElement[] trace;
        this.ZC = zc;
        for (StackTraceElement element : trace = new Throwable().getStackTrace()) {
            if (!element.getClassName().startsWith("carmetal.rene.zirkel.tools")) continue;
            String s = element.getClassName();
            this.CallerObject = s.split("\\.")[3];
            break;
        }
        String aa = "";
        try {
            aa = Global.Loc("selectpopup." + this.CallerObject);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JMenuItem m = new JMenuItem(aa + Global.Loc("selectpopup.whatobject"));
        m.setBackground(Color.WHITE);
        m.setForeground(Color.DARK_GRAY);
        m.setFont(new Font("Dialog", 3, 12));
        m.setActionCommand("-1,false");
        m.setEnabled(false);
        m.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e2) {
                if (JSelectPopup.this.D != null) {
                    JSelectPopup.this.D.setVisible(false);
                }
            }
        });
        m.addMouseListener(this);
        this.add(m);
        for (int i = 0; i < v.size(); ++i) {
            ConstructionObject o = (ConstructionObject)v.elementAt(i);
            this.V.add(o);
            String tp = o.getName() + " : " + o.getText().split(" ")[0];
            m = new JMenuItem(tp);
            m.setForeground(o.getColor());
            m.setBackground(new Color(240, 240, 240));
            m.setFont(new Font("Dialog", 1, 12));
            m.setActionCommand(String.valueOf(i) + "," + o.selected());
            m.setRolloverEnabled(true);
            m.addMouseListener(this);
            m.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    JMenuItem jm = (JMenuItem)event.getSource();
                    JSelectPopup.this.doaction(jm.getActionCommand(), event.getModifiers());
                }
            });
            this.add(m);
        }
    }

    public int row(String str) {
        return Integer.parseInt(str.split(",")[0]);
    }

    public boolean sel(String str) {
        String bl = str.split(",")[1].toLowerCase();
        return bl.equals("true");
    }

    public void doaction(String str, int modifier) {
        ConstructionObject o = (ConstructionObject)this.V.elementAt(this.row(str));
        o.setSelected(this.sel(str));
        this.D.setConstructionObject(o);
        this.D.setVisible(false);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        JMenuItem jm = (JMenuItem)e2.getSource();
        int i = this.row(jm.getActionCommand());
        if (i > -1 && !this.sel(jm.getActionCommand())) {
            ConstructionObject o = (ConstructionObject)this.V.elementAt(i);
            o.setSelected(true);
            this.ZC.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        JMenuItem jm = (JMenuItem)e2.getSource();
        int i = this.row(jm.getActionCommand());
        if (i > -1 && !this.sel(jm.getActionCommand())) {
            ConstructionObject o = (ConstructionObject)this.V.elementAt(i);
            o.setSelected(false);
            this.ZC.repaint();
        }
        int x = MouseInfo.getPointerInfo().getLocation().x;
        int y = MouseInfo.getPointerInfo().getLocation().y;
        if (x < this.sx || x > this.sx + this.sw || y < this.sy || y > this.sy + this.sh) {
            this.D.setVisible(false);
        }
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
        this.D.setVisible(false);
    }
}

