/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric;

import carmetal.eric.FileTools;
import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.window.LeftPanel;
import carmetal.eric.GUI.window.Open_left_panel_btn;
import carmetal.eric.GUI.window.Open_middle_panel_btn;
import carmetal.eric.GUI.window.Open_right_panel_btn;
import carmetal.eric.GUI.window.RightPanel;
import carmetal.eric.JAboutDialog;
import carmetal.eric.JBrowserLauncher;
import carmetal.eric.JLicence;
import carmetal.eric.JSprogram.JSRun;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.OS;
import carmetal.eric.bar.JPropertiesBar;
import carmetal.eric.macros.CreateMacroDialog;
import carmetal.rene.dialogs.Question;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.ZirkelFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public class JGeneralMenuBar
extends JPanel {
    private static final int MenuTextSize = 12;
    private static JGeneralMenuBar me;
    myJMenuBar menubar = new myJMenuBar();
    private myJMenu MacrosMenu;
    private myJMenu ObjectsMenu;
    private myJMenu JSMenu;
    JButton historybutton;
    myJMenuItem hiddenitem;
    myJMenuItem griditem;
    myJMenuItem restrictpaletteitem;
    myJMenuItem editpaletteitem;
    myJMenuItem macrositem;
    myJMenuItem historyitem;
    myJMenuItem helpitem;
    myJMenuItem propertiesitem;
    myJMenuItem smallitem;
    myJMenuItem mediumitem;
    myJMenuItem largeitem;
    myJMenuItem definejobitem;
    myJMenuItem commentitem;
    myJMenuItem leftpanelitem;
    myJMenuItem paletteitem;

    @Override
    public void paintComponent(Graphics g) {
        Dimension d2 = this.getSize();
        g.drawImage(themes.getImage("menubar.gif"), 0, 0, d2.width, d2.height, this);
    }

    public JGeneralMenuBar() {
        me = this;
        this.setLayout(new BoxLayout(this, 0));
        this.MacrosMenu = new myJMenu(this.Loc("macros"));
        this.ObjectsMenu = new myJMenu(Global.Loc("palette.construction"));
        this.JSMenu = new myJMenu(this.Loc("js"));
        this.init();
        this.InitObjectsMenu();
    }

    public void paintImmediately() {
        this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }

    private String Loc(String s) {
        String loc = Global.Loc("menu." + s);
        if (loc == null) {
            loc = Global.Loc(s);
        }
        if (loc == null) {
            loc = s;
        }
        return loc;
    }

    public void InitMacrosMenu() {
        if (this.MacrosMenu != null) {
            this.MacrosMenu.removeAll();
            this.MacrosMenu.addI("palette.info.newmacro", "newmacro", 0, 0, new myJMenuItem(){

                @Override
                public void action() {
                    new CreateMacroDialog(JZirkelCanvas.getNewMacroPanel());
                    JZirkelCanvas.ActualiseMacroPanel();
                }
            });
            this.MacrosMenu.addSep();
        }
    }

    public static void s_InitMacrosMenu() {
        if (me != null) {
            me.InitMacrosMenu();
        }
    }

    public static void addMacrosMenu(JMenuItem item) {
        if (me != null && JGeneralMenuBar.me.MacrosMenu != null) {
            JGeneralMenuBar.me.MacrosMenu.add(item);
        }
    }

    public static void s_InitJSMenu() {
        if (me != null) {
            me.InitJSMenu();
        }
    }

    public void InitJSMenu() {
        this.JSMenu.removeAll();
        this.JSMenu.addI("js.newscriptinconstruction", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                JSRun.newScriptInConstruction();
            }
        });
        this.JSMenu.addSep();
        this.JSMenu.addI("js.command", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                JSRun.openEditor();
            }
        });
        this.JSMenu.addI("js.script", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                JSRun.openScriptFile("", true);
            }
        });
        this.JSMenu.addSep();
        this.JSMenu.addI("js.define", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                JSRun.getScriptsFolder();
                JGeneralMenuBar.this.InitJSMenu();
            }
        });
        String path = Global.getParameter("scriptfolder", "");
        if (!path.equals("")) {
            this.JSMenu.addI("js.dumb", "", 0, 0, Global.getParameter("jsdumb", true), new myJMenuItem(){

                @Override
                void action() {
                    this.setSelected(!this.isSelected());
                    Global.setParameter("jsdumb", this.isSelected());
                }
            });
            this.JSMenu.addSep();
            try {
                File myfile = new File(path);
                String[] children = myfile.list();
                for (int i = 0; i < children.length; ++i) {
                    this.visitAllFiles(this.JSMenu, new File(myfile, children[i]));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void visitAllFiles(myJMenu parentmenu, final File myfile) {
        if (myfile.isDirectory()) {
            myJMenu menu = new myJMenu(myfile.getName(), true);
            String[] children = myfile.list();
            for (int i = 0; i < children.length; ++i) {
                this.visitAllFiles(menu, new File(myfile, children[i]));
            }
            parentmenu.add(menu);
        } else if (myfile.getName().endsWith(".js")) {
            parentmenu.addI(myfile.getName(), "", 0, 0, new myJMenuItem(){

                @Override
                void action() {
                    JSRun.openScriptFile(myfile.getAbsolutePath(), false);
                }
            });
        }
    }

    public static void initToggleItems() {
        if (me != null) {
            JGeneralMenuBar.me.commentitem.setSelected(Global.getParameter("comment", false));
            JGeneralMenuBar.me.leftpanelitem.setSelected(LeftPanel.isPanelVisible());
            JGeneralMenuBar.me.paletteitem.setSelected(RightPanel.isPanelVisible());
        }
    }

    public void InitObjectsMenu() {
        this.ObjectsMenu.removeAll();
        myJMenu m1 = new myJMenu(this.Loc("objects.points"), 0);
        m1.addI("point", new myJMenuItem());
        m1.addI("intersection", new myJMenuItem());
        m1.addI("midpoint", new myJMenuItem());
        m1.addI("bi_syma", new myJMenuItem());
        m1.addI("bi_symc", new myJMenuItem());
        m1.addI("bi_trans", new myJMenuItem());
        this.ObjectsMenu.add(m1);
        myJMenu m2 = new myJMenu(this.Loc("objects.lines"), 0);
        m2.addI("line", new myJMenuItem());
        m2.addI("ray", new myJMenuItem());
        m2.addI("parallel", new myJMenuItem());
        m2.addI("plumb", new myJMenuItem());
        m2.addI("bi_med", new myJMenuItem());
        m2.addI("bi_biss", new myJMenuItem());
        this.ObjectsMenu.add(m2);
        myJMenu m3 = new myJMenu(this.Loc("objects.segments"), 0);
        m3.addI("segment", new myJMenuItem());
        m3.addI("fixedsegment", new myJMenuItem());
        m3.addI("vector", new myJMenuItem());
        m3.addI("area", new myJMenuItem());
        this.ObjectsMenu.add(m3);
        myJMenu m4 = new myJMenu(this.Loc("objects.angles"), 0);
        m4.addI("angle", new myJMenuItem());
        m4.addI("fixedangle", new myJMenuItem());
        this.ObjectsMenu.add(m4);
        myJMenu m5 = new myJMenu(this.Loc("objects.circles"), 0);
        m5.addI("circle", new myJMenuItem());
        m5.addI("fixedcircle", new myJMenuItem());
        m5.addI("circle3", new myJMenuItem());
        m5.addI("bi_circ", new myJMenuItem());
        m5.addI("bi_arc", new myJMenuItem());
        m5.addI("quadric", new myJMenuItem());
        this.ObjectsMenu.add(m5);
        myJMenu m7 = new myJMenu(this.Loc("objects.functions"), 0);
        m7.addI("text", new myJMenuItem());
        m7.addI("expression", new myJMenuItem());
        m7.addI("bi_function_u", new myJMenuItem());
        m7.addI("function", new myJMenuItem());
        m7.addI("equationxy", new myJMenuItem());
        this.ObjectsMenu.add(m7);
        myJMenu m6 = new myJMenu(this.Loc("objects.tracks"), 0);
        m6.addI("objecttracker", new myJMenuItem());
        m6.addI("tracker", new myJMenuItem());
        m6.addI("locus", new myJMenuItem());
        this.ObjectsMenu.add(m6);
    }

    private void fixsize(JComponent cp, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        cp.setMaximumSize(d2);
        cp.setMinimumSize(d2);
        cp.setPreferredSize(d2);
        cp.setSize(d2);
    }

    private JPanel margintop(int h) {
        JPanel mypan = new JPanel();
        this.fixsize(mypan, 1, h);
        mypan.setOpaque(false);
        mypan.setFocusable(false);
        return mypan;
    }

    private void showrestrictedmessage() {
        if (Global.getParameter("showrestrictmessage", true)) {
            JPanel mypan = new JPanel();
            mypan.setLayout(new BoxLayout(mypan, 1));
            JLabel mylabel = new JLabel(Global.Loc("menu.display.restrictmessage"));
            mylabel.setFont(new Font("System", 0, 12));
            JCheckBox myjcb = new JCheckBox(Global.Loc("menu.display.restrictmessage.dontdisplay"));
            mypan.add(mylabel);
            mypan.add(this.margintop(10));
            mypan.add(myjcb);
            JOptionPane.showMessageDialog(null, mypan, "", -1, null);
            Global.setParameter("showrestrictmessage", !myjcb.isSelected());
        }
    }

    public void init() {
        this.menubar.removeAll();
        this.removeAll();
        int ctrlkey = OS.isMac() ? 256 : 128;
        this.menubar.setOpaque(false);
        this.menubar.setBorder(BorderFactory.createEmptyBorder());
        this.menubar.setAlignmentY(0.5f);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        myJMenu menu = new myJMenu(this.Loc("file"));
        menu.addI("file.new", "new", 78, ctrlkey, new myJMenuItem());
        menu.addI("file.new3D", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                FileTools.New3DWindow();
            }
        });
        menu.addSep();
        menu.addI("file.load", "load", 79, ctrlkey, new myJMenuItem());
        menu.addI("file.save", "save", 83, ctrlkey, new myJMenuItem());
        menu.addI("tab.popup.savefileonly", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                FileTools.saveFileAs();
            }
        });
        menu.addI("workbook.saveas", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                FileTools.saveWorkBookAs();
            }
        });
        menu.addSep();
        menu.addI("export.workbook", "", 69, ctrlkey, new myJMenuItem(){

            @Override
            void action() {
                FileTools.HTMLWorkBookExport();
                FileTools.SaveJarAndLaunchBrowser();
            }
        });
        menu.addSep();
        menu.addI("file.exportpng", "exportpng", 0, 0, new myJMenuItem());
        menu.addI("file.exporteps", "exporteps", 0, 0, new myJMenuItem());
        menu.addI("file.exportsvg", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                FileTools.saveSVG();
            }
        });
        menu.addSep();
        menu.addI("file.close", "", 87, ctrlkey, new myJMenuItem(){

            @Override
            void action() {
                pipe_tools.closeCurrent();
            }
        });
        menu.addSep();
        menu.addI("file.quit", "", 81, ctrlkey, new myJMenuItem(){

            @Override
            void action() {
                pipe_tools.quitAll();
                JZirkelCanvas.getCurrentZF().getFrame().dispose();
            }
        });
        this.menubar.add(menu);
        menu = new myJMenu(this.Loc("edit"));
        menu.addI("edit.copy", "copy", 67, ctrlkey, new myJMenuItem());
        menu.addSep();
        menu.addI("edit.move", "move", 0, 0, new myJMenuItem());
        menu.addI("edit.rename", "rename", 0, 0, new myJMenuItem(){

            @Override
            public void action() {
                ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
                if (ZF != null) {
                    ZF.settool("rename");
                }
            }
        });
        menu.addI("edit.edit", "edit", 0, 0, new myJMenuItem());
        menu.addI("edit.zoom", "zoom", 0, 0, new myJMenuItem(){

            @Override
            public void action() {
                ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
                if (ZF != null) {
                    ZF.settool("zoom");
                }
            }
        });
        menu.addI("edit.hide", "hide", 0, 0, new myJMenuItem());
        menu.addI("edit.delete", "delete", 0, 0, new myJMenuItem());
        menu.addSep();
        menu.addI("edit.deactivatealltracks", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                ZirkelCanvas ZC = JZirkelCanvas.getCurrentZC();
                ZC.UniversalTrack.clearTrackImage();
                ZC.UniversalTrack.clearTrackObjects();
                ZC.repaint();
            }
        });
        menu.addI("edit.deletealltracks", "", 84, ctrlkey, new myJMenuItem(){

            @Override
            void action() {
                ZirkelCanvas ZC = JZirkelCanvas.getCurrentZC();
                ZC.UniversalTrack.clearTrackImage();
                ZC.repaint();
            }
        });
        menu.addSep();
        menu.addI("edit.deleteall", "", 127, 0, new myJMenuItem(){

            @Override
            void action() {
                ZirkelFrame ZF = JZirkelCanvas.getCurrentZF();
                if (ZF.ZC.changed()) {
                    Question q = new Question(pipe_tools.getFrame(), Global.Loc("savequestion.qsave"), Global.Loc("savequestion.title"), true);
                    q.center(null);
                    q.setVisible(true);
                    if (q.isAborted()) {
                        return;
                    }
                    if (q.yes()) {
                        FileTools.saveFile();
                    }
                }
                ZF.clear(false);
                ZF.Filename = "";
            }
        });
        this.menubar.add(menu);
        this.menubar.add(this.ObjectsMenu);
        menu = new myJMenu(this.Loc("display"));
        menu.addI("display.restrictedenvironment", "", 82, ctrlkey, new myJMenuItem(){

            @Override
            void action() {
                ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
                if (zc != null) {
                    zc.getNewRestrictedDialog();
                }
            }
        });
        menu.addSep();
        this.hiddenitem = new myJMenuItem();
        menu.addI("display.hidden", "hidden", 0, 0, false, this.hiddenitem);
        this.griditem = new myJMenuItem();
        menu.addI("display.grid", "grid", 0, 0, false, this.griditem);
        menu.addSep();
        menu.addI("display.smartboard", "", 0, 0, Global.getParameter("smartboard", false), new myJMenuItem(){

            @Override
            void action() {
                this.setSelected(!this.isSelected());
                Global.setParameter("smartboard", this.isSelected());
            }
        });
        menu.addSep();
        this.leftpanelitem = new myJMenuItem(){

            @Override
            void action() {
                Open_left_panel_btn.toggle();
            }
        };
        menu.addI("display.leftpanel", "", 0, 0, LeftPanel.isPanelVisible(), this.leftpanelitem);
        this.commentitem = new myJMenuItem(){

            @Override
            void action() {
                Open_middle_panel_btn.toggle();
            }
        };
        menu.addI("display.comment", "", 0, 0, Global.getParameter("comment", false), this.commentitem);
        this.paletteitem = new myJMenuItem(){

            @Override
            void action() {
                Open_right_panel_btn.toggle();
            }
        };
        menu.addI("display.palette", "", 0, 0, RightPanel.isPanelVisible(), this.paletteitem);
        menu.addSep();
        menu.addI("display.properties_panel", "properties_panel", 80, ctrlkey, false, new myJMenuItem(){

            @Override
            void action() {
                JPropertiesBar.ShowHideBar();
            }
        });
        menu.addSep();
        this.largeitem = new myJMenuItem(){

            @Override
            void action() {
                if (!this.isSelected()) {
                    themes.setPaletteIconWidth(32);
                    this.setSelected(true);
                    JGeneralMenuBar.this.mediumitem.setSelected(false);
                    JGeneralMenuBar.this.smallitem.setSelected(false);
                    pipe_tools.getContent().rebuiltRightPanel();
                }
            }
        };
        menu.addI("display.large", "", 0, 0, false, this.largeitem);
        this.mediumitem = new myJMenuItem(){

            @Override
            void action() {
                if (!this.isSelected()) {
                    themes.setPaletteIconWidth(28);
                    this.setSelected(true);
                    JGeneralMenuBar.this.largeitem.setSelected(false);
                    JGeneralMenuBar.this.smallitem.setSelected(false);
                    pipe_tools.getContent().rebuiltRightPanel();
                }
            }
        };
        menu.addI("display.medium", "", 0, 0, false, this.mediumitem);
        this.smallitem = new myJMenuItem(){

            @Override
            void action() {
                if (!this.isSelected()) {
                    themes.setPaletteIconWidth(24);
                    this.setSelected(true);
                    JGeneralMenuBar.this.mediumitem.setSelected(false);
                    JGeneralMenuBar.this.largeitem.setSelected(false);
                    pipe_tools.getContent().rebuiltRightPanel();
                }
            }
        };
        menu.addI("display.small", "", 0, 0, false, this.smallitem);
        switch (Global.getParameter("options.iconsize", 1)) {
            case 0: {
                this.largeitem.setSelected(true);
                break;
            }
            case 1: {
                this.mediumitem.setSelected(true);
                break;
            }
            case 2: {
                this.smallitem.setSelected(true);
            }
        }
        menu.addSep();
        myJMenu submenu = new myJMenu(this.Loc("language"), true);
        submenu.addI("zh", "TW", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("zh", "TW");
            }
        });
        submenu.addI("ar", "TN", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("ar", "TN");
            }
        });
        submenu.addI("pt", "BR", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("pt", "BR");
            }
        });
        submenu.addI("de", "", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("de", "");
            }
        });
        submenu.addI("en", "", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("en", "");
            }
        });
        submenu.addI("es", "", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("es", "");
            }
        });
        submenu.addI("fr", "", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("fr", "");
            }
        });
        submenu.addI("gl", "", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("gl", "");
            }
        });
        submenu.addI("it", "", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("it", "");
            }
        });
        submenu.addI("nl", "", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("nl", "");
            }
        });
        submenu.addI("no", "", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("no", "");
            }
        });
        submenu.addI("pl", "", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("pl", "");
            }
        });
        submenu.addI("pt", "", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("pt", "");
            }
        });
        submenu.addI("sl", "", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("sl", "");
            }
        });
        submenu.addI("sv", "", new myJMenuItem(){

            @Override
            void action() {
                Global.setLanguage("sv", "");
            }
        });
        menu.add(submenu);
        this.menubar.add(menu);
        this.menubar.add(this.MacrosMenu);
        this.InitJSMenu();
        this.menubar.add(this.JSMenu);
        menu = new myJMenu(this.Loc("assigment"));
        this.definejobitem = new myJMenuItem(){

            @Override
            void action() {
                ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
                if (zc != null) {
                    zc.job_showDialog();
                }
            }
        };
        menu.addI("special.definejob", "", 74, ctrlkey, false, this.definejobitem);
        this.menubar.add(menu);
        menu = new myJMenu(this.Loc("help"));
        menu.addI("help.about", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                new JAboutDialog(JZirkelCanvas.getCurrentJZF());
            }
        });
        menu.addI("help.licence", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                new JLicence(JZirkelCanvas.getCurrentJZF());
            }
        });
        menu.addI("help.info", "help_panel", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                Open_left_panel_btn.open();
                LeftPanel.selectHelp();
            }
        });
        menu.addSep();
        menu.addI("help.url0", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                JBrowserLauncher.openURL("http://db-maths.nuxit.net/CaRMetal/");
            }
        });
        menu.addI("help.url1", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                JBrowserLauncher.openURL("http://db-maths.nuxit.net/CARzine/");
            }
        });
        menu.addI("help.url2", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                JBrowserLauncher.openURL("http://zirkel.sourceforge.net/doc_en/index.html");
            }
        });
        menu.addSep();
        menu.addI("help.url3", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                JBrowserLauncher.openURL("http://db-maths.nuxit.net/CaRMetal/index_translate.html");
            }
        });
        menu.addSep();
        menu.addI("help.opendefaultfolder", "", 0, 0, new myJMenuItem(){

            @Override
            void action() {
                Global.openHomeDirectoryInDesktop();
            }
        });
        this.menubar.add(menu);
        this.add(this.menubar);
        this.validate();
        this.repaint();
    }

    class myImageIcon
    extends ImageIcon {
        int IcnHeight;
        int IcnWidth;
        int IcnMargin;
        myJMenuItem JM;

        @Override
        public void paintIcon(Component c2, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            if (this.JM != null && this.JM.isSelected()) {
                ImageIcon mysel = new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/palette/selmark.png"));
                g2.drawImage(mysel.getImage(), 3, 0, 8, this.IcnWidth, null);
            }
            g2.drawImage(this.getImage(), this.IcnMargin, 0, this.IcnWidth, this.IcnWidth, null);
        }

        public void setIcnMargin(int i) {
            this.IcnMargin = i;
        }

        public void setIconHeight(int i) {
            this.IcnHeight = i;
        }

        public void setIconWidth(int i) {
            this.IcnWidth = i;
        }

        @Override
        public int getIconHeight() {
            return this.IcnHeight;
        }

        @Override
        public int getIconWidth() {
            return this.IcnWidth;
        }

        myImageIcon(URL myurl, myJMenuItem jm) {
            super(myurl);
            this.IcnHeight = 22;
            this.IcnWidth = 24;
            this.IcnMargin = 12;
            this.JM = jm;
        }
    }

    public class myJMenuItem
    extends JMenuItem {
        String ICname;
        boolean selected = false;
        myImageIcon myimage = null;

        myJMenuItem() {
            this.setOpaque(true);
            this.setFont(new Font(Global.GlobalFont, 0, 12));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    myJMenuItem.this.action();
                }
            });
            this.setIcon(themes.getIcon("null.png"));
        }

        myJMenuItem(String itemname, String iconname) {
            this();
            this.setNames(itemname, iconname);
        }

        @Override
        public void setSelected(boolean sel) {
            this.selected = sel;
            int fontstyle = this.selected ? 1 : 0;
            this.setFont(new Font(Global.GlobalFont, fontstyle, 12));
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        void setNames(String itemname, String iconname) {
            this.ICname = iconname;
            this.setText(itemname);
            this.setIcn(iconname);
        }

        void setIcn(String iconname) {
            URL myurl;
            if (iconname.equals("")) {
                iconname = "null";
            }
            if ((myurl = this.getClass().getResource("/carmetal/eric/GUI/icons/palette/" + iconname + ".png")) == null) {
                myurl = this.getClass().getResource("/carmetal/eric/GUI/icons/palette/" + iconname + ".gif");
            }
            this.myimage = new myImageIcon(myurl, this);
            this.setIcon(this.myimage);
        }

        void action() {
            PaletteManager.ClicOn(this.ICname);
        }
    }

    class mySimpleJMenuItem
    extends JMenuItem {
        int ID;

        mySimpleJMenuItem(String name, int i) {
            super(name);
            this.ID = 0;
            this.ID = i;
            this.setOpaque(true);
            this.setFont(new Font(Global.GlobalFont, 0, 12));
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    mySimpleJMenuItem.this.action();
                }
            });
        }

        void action() {
        }
    }

    class myJMenu
    extends JMenu {
        @Override
        public void paintComponents(Graphics g) {
        }

        myJMenu(String menuname) {
            this.setText(menuname);
            this.setFont(new Font(Global.GlobalFont, 0, 12));
            this.setForeground(new Color(40, 40, 40));
            this.setOpaque(false);
        }

        myJMenu(String menuname, boolean isSubmenu) {
            this(menuname);
            if (isSubmenu) {
                this.setOpaque(true);
                this.setIcon(this$0.new myImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/palette/null.png"), null));
            }
        }

        myJMenu(String menuname, int icnw) {
            this(menuname);
            this.setOpaque(true);
            myImageIcon myicn = this$0.new myImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/palette/null.png"), null);
            myicn.setIcnMargin(0);
            myicn.setIconWidth(icnw);
            this.setIcon(myicn);
        }

        void addSep() {
            this.add(new mySeparator());
        }

        void addI(String mnu, String icn, int a1, int a2, final myJMenuItem item) {
            item.setNames(JGeneralMenuBar.this.Loc(mnu), icn);
            if (a1 != 0) {
                item.setAccelerator(KeyStroke.getKeyStroke(a1, a2));
                pipe_tools.getWindow().getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(a1, a2), mnu);
                pipe_tools.getWindow().getRootPane().getActionMap().put(mnu, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        item.action();
                    }
                });
            }
            this.add(item);
        }

        void addI(String mnu, String icn, int a1, int a2, boolean sel, final myJMenuItem item) {
            item.setNames(JGeneralMenuBar.this.Loc(mnu), icn);
            item.setSelected(sel);
            if (a1 != 0) {
                item.setAccelerator(KeyStroke.getKeyStroke(a1, a2));
                pipe_tools.getWindow().getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(a1, a2), mnu);
                pipe_tools.getWindow().getRootPane().getActionMap().put(mnu, new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        item.action();
                    }
                });
            }
            this.add(item);
        }

        void addI(String icn, myJMenuItem item) {
            String mnuName = PaletteManager.ToolTip(icn);
            item.setNames(mnuName, icn);
            item.setText("<html>" + item.getText().replaceAll("\\+", "<br>") + "</html>");
            if (item.myimage != null) {
                item.myimage.setIconWidth(28);
                item.myimage.setIconHeight(28);
            }
            this.add(item);
        }

        void addI(String lang, String country, myJMenuItem item) {
            String suffix = country.equals("") ? lang : lang + "_" + country;
            String icn = "lg_" + suffix;
            boolean good = Global.isLanguage(lang, country);
            if (good && !icn.equals("")) {
                this.setIcon(new ImageIcon(this.getClass().getResource("/carmetal/eric/GUI/icons/palette/" + icn + ".png")));
            }
            this.addI("language." + suffix, icn, 0, 0, item);
            item.setEnabled(!good);
        }

        class mySeparator
        extends JPanel {
            @Override
            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                Dimension d2 = this.getSize();
                g.drawImage(themes.getImage("sep.png"), 2, 0, d2.width - 4, 12, this);
            }

            mySeparator() {
                this.setOpaque(false);
            }
        }
    }

    class myJMenuBar
    extends JMenuBar {
        @Override
        public void paintComponents(Graphics g) {
        }

        myJMenuBar() {
            this.setUI(null);
        }

        void addMenu(JMenu mymen) {
            if (mymen.getItemCount() > 0) {
                this.add(mymen);
            }
        }
    }
}

