/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric;

import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.JContent;
import carmetal.eric.JPointName;
import carmetal.eric.JTabBtn;
import carmetal.eric.JZirkelCanvas;
import carmetal.rene.gui.Global;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;

class JCharacterPalette
extends JDialog
implements MouseListener {
    static int GENERICCODE = 10;
    JPanel Content;
    JPanel TabZone;
    JPanel ButtonZone;
    JButton LBL;
    JZirkelCanvas JZF;
    int Linemax = 10;
    int Btnsize = 18;
    int Tabbtnsize = 30;

    public JCharacterPalette(JZirkelCanvas jzf, JButton lbl) {
        this.JZF = jzf;
        this.LBL = lbl;
        JTabBtn.Btns.clear();
        this.setDefaultCloseOperation(0);
        this.setTitle("Caracter Palette");
        this.setUndecorated(true);
        this.Content = new JContent(this.Tabbtnsize);
        this.setContentPane(this.Content);
        this.setAlwaysOnTop(true);
        this.toFront();
        this.ButtonZone = JCharacterPalette.getnewcol();
        this.TabZone = JCharacterPalette.getnewcol();
        this.TabZone.setOpaque(false);
        this.initJTab();
        this.initJButtons();
        this.Content.add(this.TabZone);
        this.Content.add(this.ButtonZone);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JCharacterPalette.this.JZF.getPointLabel().setEnabledJLabel(true);
                JCharacterPalette.this.setVisible(false);
                JCharacterPalette.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent evt) {
                JCharacterPalette.this.JZF.getPointLabel().setEnabledJLabel(true);
                JCharacterPalette.this.setVisible(false);
                JCharacterPalette.this.dispose();
            }
        });
        this.pack();
        int x = this.LBL.getLocationOnScreen().x + this.LBL.getSize().width - this.getSize().width;
        int y = this.LBL.getLocationOnScreen().y + this.LBL.getSize().height;
        this.setLocation(x, y);
        this.JZF.getPointLabel().setEnabledJLabel(false);
        this.setVisible(true);
    }

    private JPanel initJTab() {
        JPanel col = null;
        JTabBtn mybtn = null;
        col = new JPanel();
        col.setLayout(new BoxLayout(col, 1));
        col.setAlignmentY(0.0f);
        mybtn = new JTabBtn(this, 0, "D");
        JPointName.fixsize(mybtn, this.Tabbtnsize, this.Tabbtnsize);
        col.add(mybtn);
        mybtn = new JTabBtn(this, 1, "d");
        JPointName.fixsize(mybtn, this.Tabbtnsize, this.Tabbtnsize);
        col.add(mybtn);
        mybtn = new JTabBtn(this, 2, "\u0394");
        JPointName.fixsize(mybtn, this.Tabbtnsize, this.Tabbtnsize);
        col.add(mybtn);
        mybtn = new JTabBtn(this, 3, "\u03b4");
        JPointName.fixsize(mybtn, this.Tabbtnsize, this.Tabbtnsize);
        col.add(mybtn);
        mybtn = new JTabBtn(this, GENERICCODE, "P1");
        JPointName.fixsize(mybtn, this.Tabbtnsize, this.Tabbtnsize);
        col.add(mybtn);
        col.setOpaque(false);
        JTabBtn.setSelectedJTitle(this.JZF.getPointLabel().getCurrentLetterSetCode());
        this.TabZone.add(col);
        return col;
    }

    private JButton getJButton(String s) {
        JButton mybtn = new JButton(s);
        mybtn.setBorder(BorderFactory.createEmptyBorder());
        mybtn.setBorderPainted(false);
        mybtn.setFocusPainted(false);
        mybtn.setFocusable(false);
        mybtn.setBackground(new Color(228, 222, 255));
        mybtn.setOpaque(false);
        mybtn.setContentAreaFilled(false);
        if (this.JZF.getPointLabel().isLetterAccepted(mybtn.getText())) {
            mybtn.addMouseListener(this);
        } else {
            mybtn.setEnabled(false);
            mybtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    JCharacterPalette.this.JZF.getPointLabel().setEnabledJLabel(true);
                    JCharacterPalette.this.setVisible(false);
                    JCharacterPalette.this.dispose();
                }
            });
        }
        mybtn.setFont(new Font(Global.GlobalFont, 1, 11));
        mybtn.setForeground(new Color(20, 20, 20));
        JPointName.fixsize(mybtn, 18, 18);
        return mybtn;
    }

    private static JPanel getnewline() {
        JPanel line = new JPanel();
        line.setLayout(new BoxLayout(line, 0));
        line.setAlignmentX(0.0f);
        line.setOpaque(false);
        return line;
    }

    private static JPanel getnewcol() {
        JPanel col = new JPanel();
        col.setLayout(new BoxLayout(col, 1));
        col.setAlignmentY(0.0f);
        col.setOpaque(true);
        col.setBackground(new Color(250, 250, 250));
        return col;
    }

    void initJButtons() {
        int i;
        JPanel line = null;
        String letters = this.JZF.getPointLabel().getCurrentLetterSet();
        this.ButtonZone.removeAll();
        for (i = 0; i < letters.length(); ++i) {
            if (i % this.Linemax == 0) {
                line = JCharacterPalette.getnewline();
                this.ButtonZone.add(line);
            }
            line.add(this.getJButton(letters.substring(i, i + 1)));
        }
        this.ButtonZone.add(new JSeparator());
        for (i = 0; i < letters.length(); ++i) {
            if (i % this.Linemax == 0) {
                line = JCharacterPalette.getnewline();
                this.ButtonZone.add(line);
            }
            line.add(this.getJButton(letters.substring(i, i + 1) + "'"));
        }
        this.ButtonZone.add(new JSeparator());
        for (i = 0; i < letters.length(); ++i) {
            if (i % this.Linemax == 0) {
                line = JCharacterPalette.getnewline();
                this.ButtonZone.add(line);
            }
            line.add(this.getJButton(letters.substring(i, i + 1) + "''"));
        }
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (e2.getSource() != null) {
            if (!Global.getParameter("options.point.shownames", false)) {
                Global.setParameter("options.point.shownames", true);
                String iconname = PaletteManager.geomSelectedIcon();
                if (iconname.equals("point")) {
                    PaletteManager.setSelected_with_clic("showname", true);
                }
            }
            JButton btn = (JButton)e2.getSource();
            String s = btn.getText();
            if (this.JZF.getPointLabel().isLetterAllowed(s)) {
                this.JZF.getPointLabel().setSuffixChar("");
                this.JZF.getPointLabel().setStartLetter(s);
            } else if (s.endsWith("''")) {
                this.JZF.getPointLabel().setSuffixChar("''");
                this.JZF.getPointLabel().setStartLetter(s.substring(0, 1));
            } else if (s.endsWith("'")) {
                this.JZF.getPointLabel().setSuffixChar("'");
                this.JZF.getPointLabel().setStartLetter(s.substring(0, 1));
            }
            this.JZF.getPointLabel().setEnabledJLabel(true);
            this.setVisible(false);
            this.dispose();
        }
    }

    @Override
    public void mousePressed(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        if (e2.getSource() != null) {
            JButton btn = (JButton)e2.getSource();
            btn.setBackground(new Color(236, 236, 249));
            btn.setOpaque(true);
            btn.setContentAreaFilled(true);
        }
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        if (e2.getSource() != null) {
            JButton btn = (JButton)e2.getSource();
            btn.setOpaque(false);
            btn.setContentAreaFilled(false);
        }
    }
}

