/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.GUI.window;

import carmetal.eric.FileTools;
import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.window.ContentPane;
import carmetal.eric.GUI.window.LeftPanel;
import carmetal.eric.GUI.window.Open_left_panel_btn;
import carmetal.eric.GUI.window.Open_middle_panel_btn;
import carmetal.eric.GUI.window.Open_right_panel_btn;
import carmetal.eric.GUI.window.RightPanel;
import carmetal.eric.GUI.window.myJMenuItem;
import carmetal.eric.GUI.window.nav_left;
import carmetal.eric.GUI.window.nav_right;
import carmetal.eric.GUI.window.tab_btn;
import carmetal.eric.GUI.window.tab_canvas_panel;
import carmetal.eric.GUI.windowComponent;
import carmetal.eric.JZirkelCanvas;
import carmetal.rene.gui.Global;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class tab_main_panel
extends windowComponent
implements MouseWheelListener {
    private Color foreColor = new Color(0, 0, 0);
    private static myJMenuItem paletteitem;
    private static myJMenuItem leftpanelitem;
    private static myJMenuItem commentitem;
    private static int Rect_width;
    private static int offset;
    private static int leftmargin;
    private static tab_main_panel me;
    private static ArrayList<tab_btn> BTNS;
    private static JPopupMenu tab_popup;
    private static JPopupMenu ctrl_popup;

    @Override
    public void paintComponent(Graphics g) {
        Dimension d2 = this.getSize();
        g.drawImage(themes.getImage("tabbar.gif"), 0, 0, d2.width, d2.height, this);
    }

    public void init() {
        int wdth = pipe_tools.getWindowSize().width - themes.getTotalRightPanelWidth() - themes.getTabControlPanelWidth();
        this.setBounds(0, pipe_tools.getWindowSize().height - themes.getMainTabPanelHeight(), wdth, themes.getMainTabPanelHeight());
        tab_main_panel.initBTNS(null);
        tab_main_panel.showActiveBtn();
    }

    public tab_main_panel() {
        me = this;
        this.setOpaque(true);
        this.setLayout(null);
        this.addMouseWheelListener(this);
        tab_main_panel.createTabAndCanvas("Figure 1");
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e2) {
        if (BTNS.size() == 0) {
            return;
        }
        int notches = e2.getWheelRotation();
        int askedOffset = offset - notches * 30;
        if (notches < 0 && askedOffset > 0) {
            askedOffset = 0;
        } else if (notches > 0 && Rect_width * BTNS.size() + askedOffset <= this.getSize().width) {
            askedOffset = this.getSize().width - Rect_width * BTNS.size();
        }
        offset = askedOffset;
        tab_main_panel.deOverAll();
        tab_main_panel.initBTNS(null);
    }

    public static tab_main_panel getme() {
        return me;
    }

    public static void removeAllBtns(ContentPane content) {
        if (content != null) {
            for (int i = 0; i < BTNS.size(); ++i) {
                content.remove(BTNS.get(i));
            }
        }
        BTNS.clear();
    }

    public static void removeBtnAndSelect(tab_btn btn) {
        if (BTNS.size() > 1) {
            int i = tab_main_panel.getActiveBtnPos();
            tab_main_panel.removeBtn(btn);
            if (i < BTNS.size()) {
                tab_main_panel.setActiveBtn(BTNS.get(i));
            } else {
                tab_main_panel.setActiveBtn(BTNS.get(i - 1));
            }
            tab_main_panel.showActiveBtn();
            me.revalidate();
            me.repaint();
        }
    }

    public static void removeBtn(tab_btn btn) {
        if (BTNS.size() > 1) {
            me.remove(btn);
            BTNS.remove(btn);
            tab_main_panel.initBTNS(null);
        }
    }

    public static void addBtnAndSelect(String label) {
        tab_btn btn = new tab_btn(label);
        int i = tab_main_panel.getActiveBtnPos() + 1;
        if (i == BTNS.size()) {
            me.add(btn);
            BTNS.add(btn);
        } else {
            me.add((Component)btn, i);
            BTNS.add(i, btn);
        }
        tab_main_panel.initBTNS(null);
        tab_main_panel.setActiveBtn(btn);
        tab_main_panel.showActiveBtn();
        btn.editName();
    }

    public static tab_btn addBtn(String name) {
        tab_btn btn = new tab_btn(name, name);
        me.add(btn);
        BTNS.add(btn);
        return btn;
    }

    public static void createTabAndCanvas(String label, String tooltip) {
        tab_btn btn = new tab_btn(label, tooltip);
        me.add(btn);
        BTNS.add(btn);
        tab_main_panel.setActiveBtn(btn);
        tab_main_panel.showActiveBtn();
    }

    public static void createTabAndCanvas(String label) {
        tab_main_panel.createTabAndCanvas(label, label);
    }

    public static void setNextActiveBtn(int j) {
        int i = tab_main_panel.getActiveBtnPos();
        try {
            tab_main_panel.setActiveBtn(BTNS.get(i + j));
            tab_main_panel.showActiveBtn();
        }
        catch (Exception exception) {
            // empty catch block
        }
        tab_main_panel.initNAVbtns();
    }

    public static void setCurrentTabName(String name, String tooltip) {
        tab_main_panel.getActiveBtn().setTabName(name, tooltip);
    }

    public static void setActiveBtn(int k) {
        tab_main_panel.setActiveBtn(BTNS.get(k));
    }

    public static void setActiveBtn(final tab_btn btn) {
        btn.setActive(true);
        for (int i = 0; i < BTNS.size(); ++i) {
            if (!BTNS.get(i).equals(btn)) {
                BTNS.get(i).setActive(false);
            }
            BTNS.get(i).repaint();
        }
        tab_main_panel.initNAVbtns();
        pipe_tools.onTabActivate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                btn.getPanel().setComments();
            }
        });
    }

    public static tab_btn getLastBtn() {
        if (BTNS.size() > 0) {
            return BTNS.get(BTNS.size() - 1);
        }
        return null;
    }

    public static void currentTabHaveChanged(boolean b2) {
        tab_main_panel.getActiveBtn().setChanged(b2);
    }

    public static void allTabsHaveChanged(boolean b2) {
        for (int i = 0; i < BTNS.size(); ++i) {
            BTNS.get(i).setChanged(b2);
        }
    }

    public static tab_btn getActiveBtn() {
        for (int i = 0; i < BTNS.size(); ++i) {
            if (!BTNS.get(i).getActive()) continue;
            return BTNS.get(i);
        }
        return null;
    }

    public static tab_canvas_panel getPanel(int i) {
        return BTNS.get(i).getPanel();
    }

    public static tab_canvas_panel getActivePanel() {
        for (int i = 0; i < BTNS.size(); ++i) {
            if (!BTNS.get(i).getActive()) continue;
            return BTNS.get(i).getPanel();
        }
        return null;
    }

    public static int getActiveBtnPos() {
        for (int i = 0; i < BTNS.size(); ++i) {
            if (!BTNS.get(i).getActive()) continue;
            return i;
        }
        return -1;
    }

    public static int getBTNSsize() {
        return BTNS.size();
    }

    public static tab_btn getBTN(int i) {
        return BTNS.get(i);
    }

    public static void showActiveBtn() {
        boolean b1;
        tab_btn btn = tab_main_panel.getActiveBtn();
        boolean bl = b1 = btn.getBounds().x + btn.getSize().width > tab_main_panel.me.getSize().width;
        if (btn.getBounds().x + btn.getSize().width > tab_main_panel.me.getSize().width) {
            offset -= btn.getBounds().x + btn.getSize().width - tab_main_panel.me.getSize().width;
        } else if (btn.getBounds().x < 0) {
            offset += -btn.getBounds().x;
        }
        tab_main_panel.initBTNS(null);
    }

    public static void setOverBtn(tab_btn btn) {
        btn.setOver(true);
        for (int i = 0; i < BTNS.size(); ++i) {
            if (!BTNS.get(i).equals(btn)) {
                BTNS.get(i).setOver(false);
            }
            BTNS.get(i).repaint();
        }
    }

    public static void reorderBTNS(tab_btn exceptBtn) {
        Collections.sort(BTNS);
        tab_main_panel.initBTNS(exceptBtn);
        tab_main_panel.initNAVbtns();
    }

    public static void deOverAll() {
        for (int i = 0; i < BTNS.size(); ++i) {
            BTNS.get(i).setOver(false);
        }
    }

    public static void deactiveAll() {
        for (int i = 0; i < BTNS.size(); ++i) {
            BTNS.get(i).setActive(false);
        }
    }

    public static void initNAVbtns() {
        int i = tab_main_panel.getActiveBtnPos();
        nav_left.setDisabled(i == 0);
        nav_right.setDisabled(i == BTNS.size() - 1);
    }

    public static void initBTNS(tab_btn except) {
        for (int i = 0; i < BTNS.size(); ++i) {
            tab_btn btn = BTNS.get(i);
            if (btn.equals(except)) continue;
            int x = themes.getLeftPanelWidth() + themes.getVerticalPanelBorderWidth() + leftmargin + offset + i * Rect_width;
            int y = 0;
            btn.setBounds(x, y, Rect_width - 1, themes.getTabBtnHeight());
            btn.init();
        }
    }

    public static boolean rightcut(tab_btn btn) {
        boolean b1 = btn.getBounds().x + btn.getSize().width > tab_main_panel.me.getSize().width;
        boolean b2 = btn.getBounds().x < tab_main_panel.me.getSize().width;
        return b1 && b2;
    }

    public static int visibleWidth(tab_btn btn) {
        if (tab_main_panel.rightcut(btn)) {
            return tab_main_panel.me.getSize().width - btn.getBounds().x;
        }
        return Rect_width;
    }

    public static JPopupMenu getTabPopup() {
        tab_main_panel.initTabPopupMenu();
        return tab_popup;
    }

    public static void initTabPopupMenu() {
        tab_popup = new JPopupMenu();
        for (int i = 0; i < BTNS.size(); ++i) {
            final int j = i;
            myJMenuItem item = new myJMenuItem(BTNS.get(i).getTabName()){

                @Override
                public void action() {
                    tab_main_panel.setActiveBtn((tab_btn)BTNS.get(j));
                    tab_main_panel.showActiveBtn();
                }
            };
            if (BTNS.get(i).getActive()) {
                item.setFont(themes.TabSelectedMenusFont);
            }
            tab_popup.add(item);
        }
    }

    public static JPopupMenu getCtrlPopup() {
        tab_main_panel.initCtrlPopupMenu();
        return ctrl_popup;
    }

    public static void initCtrlPopupMenu() {
        ctrl_popup = new JPopupMenu();
        myJMenuItem item = new myJMenuItem(Global.Loc("tab.popup.rename")){

            @Override
            public void action() {
                tab_main_panel.getActiveBtn().editName();
            }
        };
        if (!JZirkelCanvas.isWorkBook()) {
            item.setEnabled(false);
        }
        ctrl_popup.add(item);
        item = new myJMenuItem(Global.Loc("tab.popup.newfigure")){

            @Override
            public void action() {
                tab_main_panel.newTabBtn();
            }
        };
        ctrl_popup.add(item);
        item = new myJMenuItem(Global.Loc("tab.popup.duplicate")){

            @Override
            public void action() {
                pipe_tools.duplicateTab();
            }
        };
        ctrl_popup.add(item);
        JSeparator sep = new JSeparator();
        item = new myJMenuItem(Global.Loc("tab.popup.savefileonly")){

            @Override
            public void action() {
                pipe_tools.saveFigure();
            }
        };
        ctrl_popup.add(item);
        ctrl_popup.add(sep);
        item = new myJMenuItem(Global.Loc("tab.popup.openworkbook")){

            @Override
            public void action() {
                FileTools.openWorkBook();
            }
        };
        ctrl_popup.add(item);
        item = new myJMenuItem(Global.Loc("tab.popup.saveworkbookas")){

            @Override
            public void action() {
                FileTools.saveWorkBookAs();
            }
        };
        ctrl_popup.add(item);
        item = new myJMenuItem(Global.Loc("tab.popup.saveworkbook")){

            @Override
            public void action() {
                FileTools.saveWorkBook(JZirkelCanvas.getWorkBookFileName());
            }
        };
        ctrl_popup.add(item);
        sep = new JSeparator();
        ctrl_popup.add(sep);
        leftpanelitem = new myJMenuItem(Global.Loc("menu.display.leftpanel")){

            @Override
            public void action() {
                Open_left_panel_btn.toggle();
            }
        };
        ctrl_popup.add(leftpanelitem);
        commentitem = new myJMenuItem(Global.Loc("menu.display.comment")){

            @Override
            public void action() {
                Open_middle_panel_btn.toggle();
            }
        };
        ctrl_popup.add(commentitem);
        paletteitem = new myJMenuItem(Global.Loc("menu.display.palette")){

            @Override
            public void action() {
                Open_right_panel_btn.toggle();
            }
        };
        ctrl_popup.add(paletteitem);
        tab_main_panel.initToggleItems();
    }

    public static void hidePopups() {
        if (tab_popup != null) {
            tab_popup.setVisible(false);
        }
        if (ctrl_popup != null) {
            ctrl_popup.setVisible(false);
        }
    }

    private static boolean nameExists(String name) {
        for (int i = 0; i < BTNS.size(); ++i) {
            if (!name.equals(BTNS.get(i).getTabName())) continue;
            return true;
        }
        return false;
    }

    public static String uniqueName(String name) {
        if (tab_main_panel.nameExists(name)) {
            return tab_main_panel.uniqueNumberedName(name);
        }
        return name;
    }

    public static String uniqueNumberedName(String base) {
        int count = 1;
        base = base.replaceAll("[\\s0-9]+$", "");
        while (tab_main_panel.nameExists(base + " " + count)) {
            ++count;
        }
        return base + " " + count;
    }

    public static void newTabBtn() {
        tab_main_panel.addBtnAndSelect(tab_main_panel.uniqueNumberedName(Global.Loc("tab.newfigurebasename")));
    }

    public static void initToggleItems() {
        if (commentitem != null) {
            commentitem.setSelected(Global.getParameter("comment", false));
            leftpanelitem.setSelected(LeftPanel.isPanelVisible());
            paletteitem.setSelected(RightPanel.isPanelVisible());
        }
    }

    static {
        Rect_width = 150;
        offset = 0;
        leftmargin = 20;
        me = null;
        BTNS = new ArrayList();
        tab_popup = null;
        ctrl_popup = null;
    }
}

