/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.GUI.window;

import carmetal.eric.FileTools;
import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.window.ContentPane;
import carmetal.eric.GUI.window.MainContainer;
import carmetal.eric.GUI.window.tab_main_panel;
import carmetal.eric.Media;
import java.awt.Image;
import java.awt.Point;
import java.net.URL;
import javax.swing.JApplet;
import javax.swing.SwingUtilities;

public class MainApplet
extends JApplet
implements MainContainer {
    private ContentPane CONTENT;

    @Override
    public void init() {
        try {
            pipe_tools.init(this);
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    MainApplet.this.createGUI();
                    MainApplet.this.openFILES();
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void start() {
    }

    public void createGUI() {
        tab_main_panel.removeAllBtns(this.CONTENT);
        Media.clearMedias();
        this.setLayout(null);
        themes.init();
        this.CONTENT = new ContentPane();
        this.setContentPane(this.CONTENT);
    }

    public void openFILES() {
        try {
            String filename = this.getParameter("file");
            URL url = new URL(this.getCodeBase(), filename);
            if (url.getFile().toLowerCase().endsWith(".zirs")) {
                FileTools.openWorkBook(new URL(this.getCodeBase(), filename));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setComponents() {
        this.CONTENT.setComponents();
    }

    @Override
    public ContentPane getContent() {
        return this.CONTENT;
    }

    @Override
    public Point getMouseLoc() {
        return this.CONTENT.getMousePosition();
    }

    @Override
    public Image getImage(String s) {
        Image myimage = this.getImage(themes.class.getResource(themes.getCommonThemePath() + s));
        if (myimage == null) {
            myimage = this.getImage(themes.class.getResource(themes.getCurrentThemePath() + s));
        }
        if (myimage == null) {
            myimage = this.getImage(themes.class.getResource(themes.getCommonThemePath() + "null.gif"));
        }
        return myimage;
    }

    @Override
    public Image getPaletteImage(String s) {
        Image myimage;
        try {
            myimage = this.getImage(themes.class.getResource(themes.getPalettePath() + s + ".png"));
        }
        catch (Exception e2) {
            try {
                myimage = this.getImage(themes.class.getResource(themes.getPalettePath() + s + ".gif"));
            }
            catch (Exception ex) {
                try {
                    myimage = this.getImage(themes.class.getResource(themes.getBarPath() + s + ".png"));
                }
                catch (Exception ex2) {
                    try {
                        myimage = this.getImage(themes.class.getResource(themes.getBarPath() + s + ".gif"));
                    }
                    catch (Exception ex3) {
                        myimage = this.getImage(themes.class.getResource(themes.getCommonThemePath() + "null.gif"));
                    }
                }
            }
        }
        return myimage;
    }

    @Override
    public boolean isApplet() {
        return true;
    }

    @Override
    public void setLocation(int x, int y) {
    }

    @Override
    public Point getLocation() {
        return new Point(0, 0);
    }

    @Override
    public void setSize(int w, int h) {
    }
}

