/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.GUI.palette;

import carmetal.eric.GUI.palette.JColorPanel;
import carmetal.eric.GUI.palette.JCursor;
import carmetal.eric.GUI.palette.JIcon;
import carmetal.eric.GUI.palette.JIconMouseAdapter;
import carmetal.eric.GUI.palette.PaletteZone;
import carmetal.eric.GUI.palette.PaletteZone_Aspect;
import carmetal.eric.GUI.window.LeftPanel;
import carmetal.eric.GUI.window.MenuBar;
import carmetal.eric.GUI.window.RightPanel;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.restrict.RestrictItems;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JComponent;

public class PaletteManager {
    private static String GEOM_GROUP = "geom";
    static String POINT_GROUP = "point";
    static String ASPECT1_GROUP = "aspect1";
    static String ASPECT2_GROUP = "aspect2";
    static String GRID1_GROUP = "grid1";
    static String GRID2_GROUP = "grid2";
    static String PHOTO_GROUP = "photo";
    private static RightPanel MainPanel;
    private static JIcon ctrlJSlider;
    private static JIcon ctrlJPopup;
    private static JIcon ctrlJCheckBox;
    private static JIcon ctrlJTextField;
    private static JIcon ctrlJButton;
    private static ArrayList<JIcon> allIcons;
    private static PaletteZone JPDisk;
    private static PaletteZone JPEdit;
    private static PaletteZone JP3D;
    private static PaletteZone JPGeom;
    private static PaletteZone JPfunc;
    private static PaletteZone JPTest;
    private static PaletteZone JPControls;
    private static PaletteZone JPHist;
    private static PaletteZone JPSizes;
    private static PaletteZone JPColors;
    private static PaletteZone JPPrec;
    private static PaletteZone JPGrid;
    private static ArrayList<PaletteZone> PaletteWithIconOnly;
    private static PaletteZone_Aspect JPAspect;
    private static JColorPanel colorpanel;

    public static void fixsize(JComponent jc, int w, int h) {
        Dimension d2 = new Dimension(w, h);
        jc.setSize(d2);
        jc.setMaximumSize(d2);
        jc.setMinimumSize(d2);
        jc.setPreferredSize(d2);
    }

    public static void construct(RightPanel mainpanel) {
        MainPanel = mainpanel;
        MainPanel.removeAll();
        allIcons.clear();
        PaletteManager.constructJPDisk();
        PaletteManager.constructJPEdit();
        PaletteManager.constructJP3D();
        PaletteManager.constructJPGeom();
        PaletteManager.constructJPAspect();
        PaletteManager.constructJPfunc();
        PaletteManager.constructJPTest();
        PaletteManager.constructJPControls();
        PaletteManager.constructJPGrid();
        PaletteManager.constructJPHist();
        PaletteManager.constructJPColors();
        PaletteManager.constructJPSizes();
        PaletteManager.constructJPPrec();
        PaletteManager.setDefault();
        PaletteWithIconOnly = new ArrayList();
        PaletteWithIconOnly.add(JPDisk);
        PaletteWithIconOnly.add(JPEdit);
        PaletteWithIconOnly.add(JPGeom);
        PaletteWithIconOnly.add(JPfunc);
        PaletteWithIconOnly.add(JPTest);
        PaletteWithIconOnly.add(JPControls);
    }

    public static void init() {
        if (RightPanel.isPanelVisible()) {
            PaletteManager.fixRestrictedEnvironment();
            JPDisk.init();
            JPEdit.init();
            JP3D.init();
            JPGeom.init();
            JPAspect.init();
            JPfunc.init();
            JPTest.init();
            JPControls.init();
            JPGrid.init();
            JPHist.init();
            JPColors.init();
            JPSizes.init();
            JPPrec.init();
            PaletteManager.FixPaletteHeight(null);
        }
    }

    private static void setDefault() {
        PaletteManager.setSelected_with_clic("type" + Global.getParameter("options.type", 0), true);
        PaletteManager.setSelected_with_clic("obtuse", Global.getParameter("options.obtuse", true));
    }

    public static boolean isPaletteWithIconOnly(PaletteZone pz) {
        for (int i = 0; i < PaletteWithIconOnly.size(); ++i) {
            if (!pz.equals(PaletteWithIconOnly.get(i))) continue;
            return true;
        }
        return false;
    }

    private static void constructJPDisk() {
        String[] icns = new String[]{"new", "load", "save", "copy", "exportpng", "exporteps"};
        JPDisk = new PaletteZone(Global.Loc("palette.file"));
        JPDisk.createIcons(icns, null);
        MainPanel.add(JPDisk);
        RestrictItems.init_disk_icns(icns);
    }

    private static void constructJPEdit() {
        String[] icns = new String[]{"move", "edit", "animate"};
        JPEdit = new PaletteZone(Global.Loc("palette.edit"));
        JPEdit.createIcons(icns, GEOM_GROUP);
        JPEdit.createIcon("back", null);
        JPEdit.createIcon("delete", GEOM_GROUP);
        JPEdit.createIcon("undo", null);
        JPEdit.createIcon("hide", GEOM_GROUP);
        JPEdit.createToggleIcon("hidden");
        JPEdit.createToggleIcon("grid");
        MainPanel.add(JPEdit);
        String[] icns2 = new String[]{"move", "edit", "animate", "back", "delete", "undo", "hide", "hidden", "grid"};
        RestrictItems.init_edit_icns(icns2);
    }

    private static void constructJP3D() {
        String[] icns = new String[]{"bi_3Dcoords", "boundedpoint", "bi_3Darete", "bi_3Dtetra", "bi_3Dcube", "bi_3Ddode"};
        JP3D = new PaletteZone(Global.Loc("palette.3D"));
        JP3D.createIcons(icns, GEOM_GROUP);
    }

    private static void constructJPAspect() {
        JPAspect = new PaletteZone_Aspect();
        MainPanel.add(JPAspect);
    }

    private static void constructJPfunc() {
        String[] icns = new String[]{"tracker", "objecttracker", "locus"};
        JPfunc = new PaletteZone(Global.Loc("palette.function"));
        JPfunc.createIcon("bi_function_u", GEOM_GROUP);
        JPfunc.createIcon("function", null);
        JPfunc.createIcon("equationxy", null);
        JPfunc.createIcons(icns, GEOM_GROUP);
        MainPanel.add(JPfunc);
        String[] icns2 = new String[]{"tracker", "objecttracker", "locus", "bi_function_u", "function", "equationxy"};
        RestrictItems.init_func_icns(icns2);
    }

    private static void constructJPGeom() {
        String[] icns = new String[]{"point", "intersection", "midpoint", "bi_syma", "bi_symc", "bi_trans", "line", "ray", "parallel", "plumb", "bi_med", "bi_biss", "segment", "fixedsegment", "vector", "area", "angle", "fixedangle", "circle", "fixedcircle", "circle3", "bi_circ", "bi_arc", "quadric", "text", "expression", "image3"};
        JPGeom = new PaletteZone(Global.Loc("palette.construction"));
        JPGeom.createIcons(icns, GEOM_GROUP);
        MainPanel.add(JPGeom);
        RestrictItems.init_geom_icns(icns);
    }

    private static void constructJPTest() {
        String[] icns = new String[]{"bi_t_align", "bi_t_para", "bi_t_perp", "bi_t_equi", "bi_t_app", "bi_t_conf"};
        JPTest = new PaletteZone(Global.Loc("palette.test"));
        JPTest.createIcons(icns, GEOM_GROUP);
        MainPanel.add(JPTest);
        RestrictItems.init_test_icns(icns);
    }

    private static void constructJPControls() {
        JPControls = new PaletteZone(Global.Loc("palette.controls"));
        JPControls.createIcon("ctrl_edit", GEOM_GROUP);
        ctrlJSlider = JPControls.createIcon("ctrl_slider", GEOM_GROUP);
        ctrlJPopup = JPControls.createIcon("ctrl_popup", GEOM_GROUP);
        ctrlJCheckBox = JPControls.createIcon("ctrl_chkbox", GEOM_GROUP);
        ctrlJTextField = JPControls.createIcon("ctrl_txtfield", GEOM_GROUP);
        ctrlJButton = JPControls.createIcon("ctrl_button", GEOM_GROUP);
        MainPanel.add(JPControls);
        String[] icns = new String[]{"ctrl_edit", "ctrl_slider", "ctrl_popup", "ctrl_chkbox", "ctrl_txtfield", "ctrl_button"};
        RestrictItems.init_control_icns(icns);
    }

    private static void constructJPGrid() {
        String[] icns = new String[]{"acolor0", "acolor1", "acolor2", "acolor3", "acolor4", "acolor5"};
        JPGrid = new PaletteZone(Global.Loc("palette.grid"));
        JPGrid.createIcons(icns, GRID1_GROUP);
        JPGrid.createToggleIcon("dottedgrid");
        JPGrid.createToggleIcon("numgrid");
        JPGrid.createSimpleIcon("blank");
        String[] icns2 = new String[]{"athickness0", "athickness1", "athickness2"};
        JPGrid.createIcons(icns2, GRID2_GROUP);
        MainPanel.add(JPGrid);
    }

    private static void constructJPHist() {
        String[] icns = new String[]{"allback", "fastback", "oneback", "oneforward", "fastforward", "allforward", "setbreak", "nextbreak"};
        JPHist = new PaletteZone(Global.Loc("palette.history"));
        JPHist.createIcons(icns, null);
        MainPanel.add(JPHist);
    }

    private static void constructJPColors() {
        JPColors = new PaletteZone(Global.Loc("palette.colors"));
        colorpanel = new JColorPanel();
        JPColors.addComponent(colorpanel);
        JPColors.createToggleIcon("background");
        JPColors.createSimpleIcon("blank");
        JPColors.createSimpleIcon("blank");
        String[] icns = new String[]{"imstretch", "imcenter", "imtile"};
        JPColors.createIcons(icns, PHOTO_GROUP);
        MainPanel.add(JPColors);
    }

    private static void constructJPSizes() {
        JPSizes = new PaletteZone(Global.Loc("palette.sizes"));
        JPSizes.addComponent(new JCursor("minpointsize", Global.Loc("palette.sizes.point"), 1, 9, 3));
        JPSizes.addComponent(new JCursor("minlinesize", Global.Loc("palette.sizes.line"), 1, 9, 1));
        JPSizes.addComponent(new JCursor("arrowsize", Global.Loc("palette.sizes.arrow"), 3, 50, 15));
        JPSizes.addComponent(new JCursor("minfontsize", Global.Loc("palette.sizes.font"), 1, 64, 12));
        MainPanel.add(JPSizes);
    }

    private static void constructJPPrec() {
        JPPrec = new PaletteZone(Global.Loc("palette.prec"));
        JPPrec.addComponent(new JCursor("digits.lengths", Global.Loc("palette.prec.lengths"), 0, 12, 5));
        JPPrec.addComponent(new JCursor("digits.edit", Global.Loc("palette.prec.edit"), 0, 12, 5));
        JPPrec.addComponent(new JCursor("digits.angles", Global.Loc("palette.prec.angles"), 0, 12, 0));
        MainPanel.add(JPPrec);
    }

    public static void refresh() {
        JPSizes.clearContent();
        JPSizes.addComponent(new JCursor("minpointsize", Global.Loc("palette.sizes.point"), 1, 9, Global.getParameter("minpointsize", 3)));
        JPSizes.addComponent(new JCursor("minlinesize", Global.Loc("palette.sizes.line"), 1, 9, Global.getParameter("minlinesize", 1)));
        JPSizes.addComponent(new JCursor("arrowsize", Global.Loc("palette.sizes.arrow"), 3, 50, Global.getParameter("arrowsize", 15)));
        JPSizes.addComponent(new JCursor("minfontsize", Global.Loc("palette.sizes.font"), 1, 64, Global.getParameter("minfontsize", 18)));
        JPSizes.revalidate();
        JPSizes.repaint();
        JPPrec.clearContent();
        JPPrec.addComponent(new JCursor("digits.lengths", Global.Loc("palette.prec.lengths"), 0, 12, Global.getParameter("digits.lengths", 2)));
        JPPrec.addComponent(new JCursor("digits.edit", Global.Loc("palette.prec.edit"), 0, 12, Global.getParameter("digits.edit", 4)));
        JPPrec.addComponent(new JCursor("digits.angles", Global.Loc("palette.prec.angles"), 0, 12, Global.getParameter("digits.angles", 2)));
        JPPrec.revalidate();
        JPPrec.repaint();
        JPAspect.initPointNameBtn();
        colorpanel.refresh();
        PaletteManager.setSelected_with_clic("grid", Global.getParameter("axis_show", false));
        PaletteManager.setSelected_with_clic("acolor" + Global.getParameter("axis_color", 0), true);
        PaletteManager.setSelected_with_clic("athickness" + Global.getParameter("axis_thickness", 0), true);
        PaletteManager.setSelected_with_clic("numgrid", Global.getParameter("axis_labels", true));
        PaletteManager.setSelected_with_clic("dottedgrid", Global.getParameter("axis_with_grid", true));
    }

    public static void fixRestrictedEnvironment() {
        ZirkelCanvas zc = JZirkelCanvas.getCurrentZC();
        if (zc != null) {
            JPDisk.setVisible(!zc.isHiddenItem("z_disk"));
            JPEdit.setVisible(!zc.isHiddenItem("z_edit"));
            JPGeom.setVisible(!zc.isHiddenItem("z_geom"));
            JPAspect.setVisible(!zc.isHiddenItem("z_aspect"));
            JPfunc.setVisible(!zc.isHiddenItem("z_func"));
            JPTest.setVisible(!zc.isHiddenItem("z_test"));
            JPControls.setVisible(!zc.isHiddenItem("z_ctrl"));
            JPGrid.setVisible(!zc.isHiddenItem("z_grid"));
            JPHist.setVisible(!zc.isHiddenItem("z_hist"));
            JPColors.setVisible(!zc.isHiddenItem("z_back"));
            JPSizes.setVisible(!zc.isHiddenItem("z_size"));
            JPPrec.setVisible(!zc.isHiddenItem("z_prec"));
            MenuBar.setMenuVisible(!zc.isHiddenItem("x_menu"));
            zc.setLibraryMacrosVisible(!zc.isHiddenItem("x_lmcr"));
            LeftPanel.setMacroBtnVisible(!zc.isHiddenItem("x_macr"));
            LeftPanel.setHistoryBtnVisible(!zc.isHiddenItem("x_hist"));
            LeftPanel.setHelpBtnVisible(!zc.isHiddenItem("x_help"));
            for (int i = 0; i < allIcons.size(); ++i) {
                JIcon ji;
                ji.setVisible(!zc.isHiddenItem((ji = allIcons.get(i)).getIconName()));
            }
            zc.reloadCD();
        }
    }

    public static String ToolTip(String s) {
        String ToolTipText = "";
        String purename = s.startsWith("bi_") ? s.substring(3) : s;
        ToolTipText = Global.Loc("palette.info." + purename);
        if (ToolTipText == null) {
            ToolTipText = Global.Loc("palette.info." + s);
        }
        if (ToolTipText == null) {
            ToolTipText = Global.Loc("iconhelp." + purename);
        }
        return ToolTipText;
    }

    public static void FixPaletteHeight(PaletteZone caller) {
        if (caller != null) {
            caller.init();
        }
        MainPanel.validate();
        if (MainPanel.getComponentCount() != 0) {
            int i;
            PaletteZone lastpz = (PaletteZone)MainPanel.getComponent(i);
            for (i = MainPanel.getComponentCount() - 1; i >= 0 && lastpz.getBounds().y + lastpz.getBounds().height > PaletteManager.MainPanel.getBounds().height; --i) {
                PaletteZone pz = (PaletteZone)MainPanel.getComponent(i);
                if (pz.equals(caller)) continue;
                pz.setHideContent(true);
                pz.init();
                MainPanel.validate();
            }
        }
        MainPanel.repaint();
    }

    public static void registerIcon(JIcon icn) {
        allIcons.add(icn);
    }

    public static void setOverBtn(JIcon icn) {
        icn.setOver(true);
        for (int i = 0; i < allIcons.size(); ++i) {
            if (allIcons.get(i).equals(icn)) continue;
            allIcons.get(i).setOver(false);
        }
        MainPanel.repaint();
    }

    public static void setSelectBtn(JIcon icn) {
        if (!icn.isPushButton()) {
            if (icn.isToggleButton()) {
                icn.setSelected(!icn.isSelected());
                icn.repaint();
            } else {
                icn.setSelected(true);
                for (int i = 0; i < allIcons.size(); ++i) {
                    if (!icn.getIconGroup().equals(allIcons.get(i).getIconGroup()) || allIcons.get(i).equals(icn)) continue;
                    allIcons.get(i).setSelected(false);
                }
                MainPanel.repaint();
            }
        }
    }

    public static void repaint() {
        MainPanel.repaint();
    }

    public static String IconFamily(String name) {
        String f2 = ",ray,parallel,plumb,bi_med,bi_biss,";
        if (f2.indexOf("," + name + ",") != -1) {
            return "line";
        }
        f2 = ",intersection,midpoint,bi_syma,bi_symc,bi_trans,boundedpoint,";
        if (f2.indexOf("," + name + ",") != -1) {
            return "point";
        }
        f2 = ",vector,fixedsegment,";
        if (f2.indexOf("," + name + ",") != -1) {
            return "segment";
        }
        f2 = ",circle3,fixedcircle,bi_arc,bi_circ,quadric,";
        if (f2.indexOf("," + name + ",") != -1) {
            return "circle";
        }
        f2 = ",bi_function_u,expression,";
        if (f2.indexOf("," + name + ",") != -1) {
            return "text";
        }
        f2 = ",fixedangle,";
        if (f2.indexOf("," + name + ",") != -1) {
            return "angle";
        }
        return name;
    }

    public static void deselectgeomgroup() {
        for (int i = 0; i < allIcons.size(); ++i) {
            if (!GEOM_GROUP.equals(allIcons.get(i).getIconGroup())) continue;
            allIcons.get(i).setSelected(false);
            allIcons.get(i).repaint();
        }
        JIconMouseAdapter.deselect();
    }

    public static boolean isGeomGroup(String name) {
        for (int i = 0; i < allIcons.size(); ++i) {
            JIcon ji = allIcons.get(i);
            if (!allIcons.get(i).getIconName().equals(name)) continue;
            return GEOM_GROUP.equals(ji.getIconGroup());
        }
        return false;
    }

    public static void setGoodProperties(String iconname) {
        int i = 0;
        boolean b2 = false;
        if (PaletteManager.isGeomGroup(iconname)) {
            String familyIcon = PaletteManager.IconFamily(iconname);
            i = Global.getParameter("options." + familyIcon + ".color", 0);
            Color col = Global.getParameter("options." + familyIcon + ".pcolor", (Color)null);
            if (col == null) {
                PaletteManager.setSelected_with_clic("color" + i, true);
                PaletteZone_Aspect.getColorPicker().setDefaultColor();
            } else {
                PaletteZone_Aspect.getColorPicker().Select();
                PaletteZone_Aspect.getColorPicker().setCurrentColor(col);
            }
            i = Global.getParameter("options." + familyIcon + ".colortype", 0);
            PaletteManager.setSelected_with_clic("thickness" + i, true);
            b2 = Global.getParameter("options." + familyIcon + ".shownames", false);
            PaletteManager.setSelected_with_clic("showname", b2);
            b2 = Global.getParameter("options." + familyIcon + ".showvalues", false);
            PaletteManager.setSelected_with_clic("showvalue", b2);
            b2 = Global.getParameter("options." + familyIcon + ".filled", false);
            PaletteManager.setSelected_with_clic("filled", b2);
            b2 = Global.getParameter("options." + familyIcon + ".solid", false);
            PaletteManager.setSelected_with_clic("solid", b2);
            b2 = Global.getParameter("options." + familyIcon + ".bold", false);
            PaletteManager.setSelected_with_clic("bold", b2);
            b2 = Global.getParameter("options." + familyIcon + ".large", false);
            PaletteManager.setSelected_with_clic("large", b2);
            b2 = Global.getParameter("options." + familyIcon + ".obtuse", false);
            PaletteManager.setSelected_with_clic("obtuse", b2);
            if (Global.getParameter("background.usesize", false)) {
                PaletteManager.setSelected_with_clic("imstretch", true);
            } else if (Global.getParameter("background.tile", false)) {
                PaletteManager.setSelected_with_clic("imtile", true);
            } else if (Global.getParameter("background.center", false)) {
                PaletteManager.setSelected_with_clic("imcenter", true);
            }
            JPAspect.setLabel(Global.Loc("palette.aspect.label.text") + Global.Loc("palette.aspect.label." + familyIcon) + " :");
            PaletteManager.setAspectDisabledState(iconname);
        }
    }

    public static void setAspectDisabledState(String iconname) {
        String AspectIcons = " bold large filled thickness0 thickness1 thickness2 color0 color1 color2 color3 color4 color5 obtuse plines partial solid showvalue showname ";
        PaletteManager.setDisabledIcons(" bold large filled thickness0 thickness1 thickness2 color0 color1 color2 color3 color4 color5 obtuse plines partial solid showvalue showname ", false);
        String familyIcon = PaletteManager.IconFamily(iconname);
        if (familyIcon.equals("point")) {
            PaletteManager.setDisabledIcons(" filled obtuse plines partial solid ", true);
        } else if (familyIcon.equals("line")) {
            PaletteManager.setDisabledIcons(" filled obtuse partial solid showvalue ", true);
        } else if (familyIcon.equals("segment")) {
            PaletteManager.setDisabledIcons(" filled obtuse partial plines solid ", true);
        } else if (familyIcon.equals("angle")) {
            PaletteManager.setDisabledIcons(" partial plines ", true);
        } else if (familyIcon.equals("circle")) {
            PaletteManager.setDisabledIcons(" obtuse plines ", true);
        } else if (familyIcon.equals("area")) {
            PaletteManager.setDisabledIcons(" bold large obtuse plines partial showname ", true);
        } else if (familyIcon.equals("text")) {
            PaletteManager.setDisabledIcons(" showvalue filled obtuse plines partial solid ", true);
        } else if (familyIcon.equals("locus")) {
            PaletteManager.setDisabledIcons(" bold large obtuse plines partial solid showvalue showname ", true);
        } else if (familyIcon.equals("tracker")) {
            PaletteManager.setDisabledIcons(" bold large filled thickness0 thickness1 thickness2 color0 color1 color2 color3 color4 color5 obtuse plines partial solid showvalue showname ", true);
        } else {
            PaletteManager.setDisabledIcons(" bold large filled thickness0 thickness1 thickness2 color0 color1 color2 color3 color4 color5 obtuse plines partial solid showvalue showname ", true);
        }
        if (iconname.equals("quadric")) {
            PaletteManager.setDisabledIcons(" partial filled ", true);
        }
        if (iconname.equals("text")) {
            PaletteManager.setDisabledIcons(" showname ", true);
        }
    }

    public static void setDisabledIcons(String iconname, boolean dis) {
        for (int i = 0; i < allIcons.size(); ++i) {
            JIcon myicon = allIcons.get(i);
            if (iconname.indexOf(" " + myicon.getIconName() + " ") == -1) continue;
            if (myicon.isDisabled() != dis) {
                myicon.setDisabled(dis);
            }
            myicon.repaint();
            if (!myicon.getIconName().equals("color0")) continue;
            PaletteZone_Aspect.getColorPicker().setDisabled(dis);
            PaletteZone_Aspect.getColorPicker().repaint();
        }
    }

    public static void ClicOn(String iconname) {
        for (int i = 0; i < allIcons.size(); ++i) {
            JIcon myicon = allIcons.get(i);
            if (!iconname.equals(myicon.getIconName())) continue;
            myicon.ClicOnMe();
            return;
        }
    }

    public static void setSelected(String iconname, boolean sel) {
        for (int i = 0; i < allIcons.size(); ++i) {
            JIcon myicon = allIcons.get(i);
            if (!myicon.getIconName().equals(iconname)) continue;
            myicon.setSelected(sel);
            return;
        }
    }

    public static void setSelected_with_clic(String iconname, boolean sel) {
        for (int i = 0; i < allIcons.size(); ++i) {
            JIcon myicon = allIcons.get(i);
            if (!myicon.getIconName().equals(iconname)) continue;
            if (myicon.isSelected() != sel) {
                myicon.ClicOnMe();
            }
            return;
        }
    }

    public static String geomSelectedIcon() {
        for (int i = 0; i < allIcons.size(); ++i) {
            if (!GEOM_GROUP.equals(allIcons.get(i).getIconGroup()) || !allIcons.get(i).isSelected()) continue;
            return allIcons.get(i).getIconName();
        }
        return "";
    }

    public static void selectGeomIcon() {
        for (int i = 0; i < allIcons.size(); ++i) {
            if (!GEOM_GROUP.equals(allIcons.get(i).getIconGroup()) || !allIcons.get(i).isSelected()) continue;
            allIcons.get(i).ClicOnMe();
            return;
        }
    }

    public static boolean isSelected(String iconname) {
        for (int i = 0; i < allIcons.size(); ++i) {
            if (!iconname.equals(allIcons.get(i).getIconName())) continue;
            return allIcons.get(i).isSelected();
        }
        return false;
    }

    public static void CheckRestrictedIcons(String icons) {
    }

    public static void fix3Dpalette() {
        if (JZirkelCanvas.getCurrent3dMode()) {
            MainPanel.add((Component)JP3D, 2);
            JP3D.setHideContent(false);
            JP3D.init();
            PaletteManager.FixPaletteHeight(null);
        } else {
            MainPanel.remove(JP3D);
            PaletteManager.FixPaletteHeight(null);
        }
    }

    static {
        allIcons = new ArrayList();
    }
}

