/*
 * Decompiled with CFR 0.152.
 */
package carmetal.eric.GUI.palette;

import carmetal.constructors.AreaConstructor;
import carmetal.constructors.QuadricConstructor;
import carmetal.eric.FileTools;
import carmetal.eric.GUI.palette.JIconMouseAdapter;
import carmetal.eric.GUI.palette.PaletteManager;
import carmetal.eric.GUI.palette.PaletteZone_Aspect;
import carmetal.eric.GUI.pipe_tools;
import carmetal.eric.GUI.themes;
import carmetal.eric.GUI.window.LeftPanel;
import carmetal.eric.GUI.window.tab_main_panel;
import carmetal.eric.GUI.windowComponent;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.macros.CreateMacroDialog;
import carmetal.eric.macros.MacroTools;
import carmetal.rene.gui.Global;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.ZirkelFrame;
import carmetal.rene.zirkel.tools.JLocusObjectTracker;
import carmetal.rene.zirkel.tools.ObjectTracker;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.image.FilteredImageSource;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;

public class JIcon
extends windowComponent {
    private String icon_name = "";
    private String icon_group = "";
    private boolean isSelected;
    private boolean isDisabled = false;
    private boolean isEntered = false;
    private Image image = null;
    private int IconsPerRow = -1;
    private static ZirkelFrame ZF;
    private static ZirkelCanvas ZC;
    private static JZirkelCanvas JZF;
    private static String moveonreselect;

    @Override
    public void paintComponent(Graphics g) {
        AlphaComposite ac;
        super.paintComponent(g);
        Dimension d2 = this.getSize();
        int w = d2.width;
        int h = d2.height;
        Graphics2D g2 = windowComponent.getGraphics2D(g);
        if (this.isDisabled) {
            GrayFilter filter = new GrayFilter(true, 60);
            Image disImage = this.createImage(new FilteredImageSource(this.image.getSource(), filter));
            ImageIcon myicn = new ImageIcon(disImage);
            g2.drawImage(myicn.getImage(), 0, 0, w, h, this);
            return;
        }
        g2.drawImage(this.image, 0, 0, w, h, this);
        if (this.isSelected) {
            ac = AlphaComposite.getInstance(3, 0.2f);
            g2.setComposite(ac);
            g2.setColor(new Color(0, 0, 100));
            g2.fillRect(1, 1, w - 1, h - 1);
        }
        if (this.isEntered) {
            ac = AlphaComposite.getInstance(3, 0.1f);
            g2.setComposite(ac);
            g2.setColor(new Color(0, 0, 80));
            BasicStroke stroke = new BasicStroke(3.0f);
            g2.setStroke(stroke);
            g2.drawRect(2, 2, w - 4, h - 4);
        }
    }

    public JIcon(String name, String group) {
        this.icon_name = name;
        this.icon_group = group;
        this.image = themes.getPaletteImage(name);
        PaletteManager.registerIcon(this);
        String ttp = PaletteManager.ToolTip(name);
        if (ttp != null) {
            this.setToolTipText("<html>" + ttp.replace("+", "<br>") + "</html>");
        }
        this.setOpaque(false);
    }

    public JIcon(String name, String group, int iconperrow) {
        this(name, group);
        this.IconsPerRow = iconperrow;
    }

    public String getIconGroup() {
        return this.icon_group;
    }

    public String getIconName() {
        return this.icon_name;
    }

    public boolean isToggleButton() {
        return this.icon_name.equals(this.icon_group);
    }

    public boolean isPushButton() {
        return this.icon_group == null;
    }

    public void setOver(boolean b2) {
        this.isEntered = b2;
    }

    public void setSelected(boolean b2) {
        this.isSelected = b2;
    }

    public void setDisabled(boolean b2) {
        this.isDisabled = b2;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void init() {
        int w = this.getIconWidth();
        this.setPreferredSize(new Dimension(w, w));
    }

    public int getIconWidth() {
        if (this.IconsPerRow == -1) {
            return themes.getPaletteIconWidth();
        }
        int w = themes.getPaletteIconPerRow() * themes.getPaletteIconWidth() / this.IconsPerRow;
        return w;
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        return new Point(this.getSize().width / 2, this.getSize().height + 4);
    }

    @Override
    public void mouseClicked(MouseEvent e2) {
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        this.ClicOnMe();
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
    }

    @Override
    public void mouseEntered(MouseEvent e2) {
        PaletteManager.setOverBtn(this);
    }

    @Override
    public void mouseExited(MouseEvent e2) {
        this.isEntered = false;
        PaletteManager.repaint();
    }

    private static void TasksBeforeClick(JIcon me) {
        JIcon.ZF.CurrentTool = 0;
        if (PaletteManager.isGeomGroup(me.getIconName())) {
            AreaConstructor.deletePreview(JIcon.ZF.ZC);
            QuadricConstructor.deletePreview(JIcon.ZF.ZC);
        }
        CreateMacroDialog.quit();
        JIcon.ZF.ZC.JCM.hideHandles(null);
    }

    public void ClicOnMe() {
        if (moveonreselect.indexOf("," + this.icon_name + ",") != -1 && this.isSelected) {
            PaletteManager.setSelected_with_clic("move", true);
            return;
        }
        PaletteManager.setSelectBtn(this);
        ZF = JZirkelCanvas.getCurrentZF();
        JZF = JZirkelCanvas.getCurrentJZF();
        ZC = JZirkelCanvas.getCurrentZC();
        if (ZC == null) {
            return;
        }
        PaletteManager.setGoodProperties(this.icon_name);
        JIcon.TasksBeforeClick(this);
        JIcon.action(this, this.icon_name);
    }

    private static boolean checkReplay(String o) {
        if (o.equals("oneforward")) {
            JZF.getReplay().iconPressed(o);
        } else if (o.equals("oneback")) {
            JZF.getReplay().iconPressed(o);
        } else if (o.equals("fastforward")) {
            JZF.getReplay().iconPressed(o);
        } else if (o.equals("fastback")) {
            JZF.getReplay().iconPressed(o);
        } else if (o.equals("allforward")) {
            JZF.getReplay().iconPressed(o);
        } else if (o.equals("setbreak")) {
            JZF.getReplay().iconPressed(o);
        } else if (o.equals("nextbreak")) {
            JZF.getReplay().iconPressed(o);
        } else {
            JZF.getReplay().doclose();
            return false;
        }
        return true;
    }

    private static void action(JIcon me, String o) {
        if (JIcon.checkReplay(o)) {
            return;
        }
        ZC.pause(true);
        ZC.requestFocus();
        ZF.setinfo(o);
        if (o.equals("load")) {
            ZF.setinfo("save");
            FileTools.openFile();
        } else if (o.equals("save")) {
            ZF.setinfo("save");
            FileTools.saveFile();
        } else if (o.equals("new")) {
            tab_main_panel.newTabBtn();
            pipe_tools.actualiseMacroPanel();
        } else if (o.equals("newmacro")) {
            new CreateMacroDialog(JZirkelCanvas.getNewMacroPanel());
            JZirkelCanvas.ActualiseMacroPanel();
        } else if (o.equals("manage_macros")) {
            LeftPanel.showPanel(me.isSelected);
        } else if (o.startsWith("type")) {
            ZF.settype(Integer.parseInt(o.substring(4)));
            ZF.setinfo("zone_aspect");
        } else if (o.startsWith("thickness")) {
            JIcon.setObjectColorType(Integer.parseInt(o.substring(9)));
            ZF.setinfo("zone_aspect");
        } else if (o.startsWith("filled")) {
            JIcon.setObjectFilled(me.isSelected);
        } else if (o.startsWith("color")) {
            ZF.setinfo("zone_aspect");
            JIcon.setObjectColor(Integer.parseInt(o.substring(5)));
        } else if (o.startsWith("acolor")) {
            int chx = Integer.parseInt(o.substring(6));
            JIcon.ZF.ZC.setAxis_color(chx);
            JIcon.ZF.ZC.repaint();
        } else if (o.startsWith("athickness")) {
            int chx = Integer.parseInt(o.substring(10));
            JIcon.ZF.ZC.setAxis_thickness(chx);
            JIcon.ZF.ZC.repaint();
        } else if (o.equals("numgrid")) {
            JIcon.ZF.ZC.setAxis_labels(me.isSelected);
            JIcon.ZF.ZC.repaint();
        } else if (o.equals("dottedgrid")) {
            JIcon.ZF.ZC.setAxis_with_grid(me.isSelected);
            JIcon.ZF.ZC.repaint();
        } else if (o.equals("vector")) {
            ZF.setVectors(true);
            ZF.settool("segment");
        } else if (o.equals("segment")) {
            ZF.setVectors(false);
            ZF.settool("segment");
        } else if (o.equals("fixedsegment")) {
            ZF.setVectors(false);
            ZF.settool("fixedsegment");
        } else if (o.equals("image3")) {
            ZF.settool("image");
        } else if (o.equals("background")) {
            ZF.setinfo("background");
            if (me.isSelected) {
                Global.setParameter("background.usesize", false);
                Global.setParameter("background.tile", false);
                Global.setParameter("background.center", true);
                ZF.loadBackground();
                PaletteManager.setSelected_with_clic("imcenter", true);
            } else {
                JIcon.ZF.ZC.grab(false);
            }
        } else if (o.equals("imcenter")) {
            Global.setParameter("background.usesize", false);
            Global.setParameter("background.tile", false);
            Global.setParameter("background.center", true);
            ZF.setinfo("background");
            JIcon.ZF.ZC.repaint();
        } else if (o.equals("imtile")) {
            Global.setParameter("background.usesize", false);
            Global.setParameter("background.tile", true);
            Global.setParameter("background.center", false);
            ZF.setinfo("background");
            JIcon.ZF.ZC.repaint();
        } else if (o.equals("imstretch")) {
            Global.setParameter("background.usesize", true);
            Global.setParameter("background.tile", false);
            Global.setParameter("background.center", false);
            ZF.setinfo("background");
            JIcon.ZF.ZC.repaint();
        } else if (o.equals("allback")) {
            JZF.disposeReplay();
            JZF.newReplay();
            JZF.getReplay().iconPressed(o);
        } else if (o.equals("partial")) {
            JIcon.ZF.ZC.setPartial(me.isSelected);
        } else if (o.equals("plines")) {
            JIcon.ZF.ZC.setPartialLines(me.isSelected);
        } else if (o.equals("showvalue")) {
            JIcon.setObjectShowValue(me.isSelected);
        } else if (o.equals("hidden")) {
            ZF.sethidden(me.isSelected);
            ZC.reloadCD();
            ZF.setinfo("hidden");
        } else if (o.equals("showname")) {
            JIcon.setObjectShowName(me.isSelected);
        } else if (o.equals("bold")) {
            JIcon.setObjectBold(me.isSelected);
        } else if (o.equals("large")) {
            JIcon.setObjectLarge(me.isSelected);
        } else if (o.equals("longnames")) {
            ZF.setLongNames(me.isSelected);
            ZF.setinfo("defaults");
        } else if (o.equals("obtuse")) {
            JIcon.setObjectObtuse(me.isSelected);
        } else if (o.equals("solid")) {
            JIcon.setObjectSolid(me.isSelected);
        } else if (o.equals("grid")) {
            JIcon.ZF.ZC.setAxis_show(me.isSelected);
            if (me.isSelected) {
                JIcon.ZF.ZC.createAxisObjects();
            } else {
                JIcon.ZF.ZC.deleteAxisObjects();
            }
            JIcon.ZF.ZC.repaint();
            ZF.setinfo("grid");
        } else if (o.equals("objecttracker")) {
            ZirkelFrame.ObjectConstructors[17] = new ObjectTracker();
            ZF.settool("objecttracker");
        } else if (o.equals("locus")) {
            ZirkelFrame.ObjectConstructors[17] = new JLocusObjectTracker();
            ZF.settool("objecttracker");
        } else if (o.equals("function")) {
            JIcon.ZF.ZC.createCurve();
            ZF.setinfo("function");
        } else if (o.equals("equationxy")) {
            JIcon.ZF.ZC.createEquationXY();
        } else if (o.equals("copy")) {
            FileTools.savepng(false);
        } else if (o.equals("exportpng")) {
            FileTools.savepng(true);
        } else if (o.equals("exporteps")) {
            FileTools.saveeps();
        } else if (o.startsWith("bi_")) {
            if (o.equals("bi_function_u")) {
                Global.setParameter("options.point.shownames", false);
                JZF.getPointLabel().getBetterName(null, true);
            }
            MacroTools.runBuiltinMacro("@builtin@/" + o.substring(3));
        } else if (o.equals("back")) {
            JIcon.ZF.ZC.back();
            ZF.settool(o);
        } else if (o.equals("undo")) {
            JIcon.ZF.ZC.undo();
            ZF.settool(o);
        } else if (o.equals("boundedpoint")) {
            ZF.settool("boundedpoint");
        } else if (o.equals("ctrl_slider")) {
            JIcon.ZF.ZC.setNullTool();
        } else if (o.equals("ctrl_popup")) {
            JIcon.ZF.ZC.setNullTool();
        } else if (o.equals("ctrl_chkbox")) {
            JIcon.ZF.ZC.setNullTool();
        } else if (o.equals("ctrl_button")) {
            JIcon.ZF.ZC.setNullTool();
        } else if (o.equals("ctrl_edit")) {
            JIcon.ZF.ZC.setNullTool();
        } else if (o.equals("ctrl_txtfield")) {
            JIcon.ZF.ZC.setNullTool();
        } else {
            ZF.settool(o);
        }
        JIconMouseAdapter.setgeomSelectedIcon();
        ZC.pause(false);
        ZC.requestFocus();
    }

    private static boolean isIconWithProperties(String name) {
        String acceptedIcons = ",expression,locus,bi_function_u,text,area,ray,segment,line,point,parallel,plumb,intersection,midpoint,bi_syma,bi_symc,bi_trans,bi_med,bi_biss,vector,fixedsegment,circle,circle3,fixedcircle,bi_arc,bi_circ,angle,fixedangle,quadric,boundedpoint,";
        return ",expression,locus,bi_function_u,text,area,ray,segment,line,point,parallel,plumb,intersection,midpoint,bi_syma,bi_symc,bi_trans,bi_med,bi_biss,vector,fixedsegment,circle,circle3,fixedcircle,bi_arc,bi_circ,angle,fixedangle,quadric,boundedpoint,".indexOf("," + name + ",") != -1;
    }

    public static void setObjectColor(int i) {
        String iconname = PaletteManager.geomSelectedIcon();
        if (JIcon.isIconWithProperties(iconname)) {
            iconname = PaletteManager.IconFamily(iconname);
            Global.setParameter("options." + iconname + ".pcolor", (Color)null);
            Global.setParameter("options." + iconname + ".color", i);
            PaletteZone_Aspect.getColorPicker().setSelected(false);
            PaletteZone_Aspect.getColorPicker().setDefaultColor();
        } else {
            ZF.setcolor(i);
        }
    }

    public static void setObjectColor(Color c2) {
        String iconname = PaletteManager.geomSelectedIcon();
        if (JIcon.isIconWithProperties(iconname)) {
            iconname = PaletteManager.IconFamily(iconname);
            Global.setParameter("options." + iconname + ".pcolor", c2);
        }
    }

    private static void setObjectColorType(int i) {
        String iconname = PaletteManager.geomSelectedIcon();
        if (JIcon.isIconWithProperties(iconname)) {
            iconname = PaletteManager.IconFamily(iconname);
            Global.setParameter("options." + iconname + ".colortype", i);
        } else {
            ZF.setcolortype(i);
        }
    }

    private static void setObjectShowName(boolean bool) {
        String iconname = PaletteManager.geomSelectedIcon();
        if (JIcon.isIconWithProperties(iconname)) {
            iconname = PaletteManager.IconFamily(iconname);
            Global.setParameter("options." + iconname + ".shownames", bool);
        } else {
            ZF.setShowNames(bool);
        }
        ZF.setinfo("defaults");
        JZF.getPointLabel().getBetterName(null, true);
    }

    private static void setObjectShowValue(boolean bool) {
        String iconname = PaletteManager.geomSelectedIcon();
        if (JIcon.isIconWithProperties(iconname)) {
            iconname = PaletteManager.IconFamily(iconname);
            Global.setParameter("options." + iconname + ".showvalues", bool);
        } else {
            JIcon.ZF.ZC.setShowValues(bool);
        }
    }

    private static void setObjectFilled(boolean bool) {
        String iconname = PaletteManager.geomSelectedIcon();
        if (JIcon.isIconWithProperties(iconname)) {
            iconname = PaletteManager.IconFamily(iconname);
            Global.setParameter("options." + iconname + ".filled", bool);
        }
    }

    private static void setObjectSolid(boolean bool) {
        String iconname = PaletteManager.geomSelectedIcon();
        if (JIcon.isIconWithProperties(iconname)) {
            iconname = PaletteManager.IconFamily(iconname);
            Global.setParameter("options." + iconname + ".solid", bool);
        }
    }

    private static void setObjectLarge(boolean bool) {
        String iconname = PaletteManager.geomSelectedIcon();
        if (JIcon.isIconWithProperties(iconname)) {
            iconname = PaletteManager.IconFamily(iconname);
            Global.setParameter("options." + iconname + ".large", bool);
        } else {
            JIcon.ZF.ZC.setLargeFont(bool);
        }
    }

    private static void setObjectBold(boolean bool) {
        String iconname = PaletteManager.geomSelectedIcon();
        if (JIcon.isIconWithProperties(iconname)) {
            iconname = PaletteManager.IconFamily(iconname);
            Global.setParameter("options." + iconname + ".bold", bool);
        } else {
            JIcon.ZF.ZC.setBoldFont(bool);
        }
    }

    private static void setObjectObtuse(boolean bool) {
        String iconname = PaletteManager.geomSelectedIcon();
        if (JIcon.isIconWithProperties(iconname)) {
            iconname = PaletteManager.IconFamily(iconname);
            Global.setParameter("options." + iconname + ".obtuse", bool);
        } else {
            JIcon.ZF.ZC.setObtuse(bool);
        }
    }

    static {
        moveonreselect = ",delete,hide,rename,edit,zoom,animate,";
    }
}

