/*
 * Decompiled with CFR 0.152.
 */
package carmetal.constructors;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.constructors.LineConstructor;
import carmetal.objects.ConstructionObject;
import carmetal.objects.PointObject;
import carmetal.objects.SegmentObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;

public class SegmentConstructor
extends LineConstructor {
    boolean Fixed = false;

    public SegmentConstructor() {
        this(false);
    }

    public SegmentConstructor(boolean fixed) {
        this.Fixed = fixed;
    }

    @Override
    public ConstructionObject create(Construction c2, PointObject p1, PointObject p2) {
        return new SegmentObject(c2, p1, p2);
    }

    @Override
    public boolean isFixed() {
        return this.Fixed;
    }

    @Override
    public void setFixed(ZirkelCanvas zc, ConstructionObject o) {
        if (o instanceof SegmentObject) {
            SegmentObject s = (SegmentObject)o;
            if (s.canFix()) {
                try {
                    s.validate();
                    s.setFixed(true, "" + s.getLength());
                    s.edit(zc, true, true);
                    s.validate();
                    zc.repaint();
                }
                catch (Exception exception) {}
            } else {
                zc.warning(Global.name("error.fixedsegment"));
            }
        }
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        if (!this.Fixed) {
            if (this.P1 == null) {
                zc.showStatus(Global.name("message.segment.first"));
            } else {
                zc.showStatus(Global.name("message.segment.second"));
            }
        } else if (this.P1 == null) {
            zc.showStatus(Global.name("message.fixedsegment.first"));
        } else {
            zc.showStatus(Global.name("message.fixedsegment.second"));
        }
    }

    @Override
    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Segment")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("from") || !tag.hasParam("to")) {
            throw new ConstructionException("Segment endpoints missing!");
        }
        try {
            PointObject p1 = (PointObject)c2.find(tag.getValue("from"));
            PointObject p2 = (PointObject)c2.find(tag.getValue("to"));
            SegmentObject o = new SegmentObject(c2, p1, p2);
            this.setName(tag, o);
            this.set(tree, o);
            c2.add(o);
            this.setConditionals(tree, c2, o);
            o.setArrow(tag.hasParam("arrow"));
            if (tag.hasParam("fixed")) {
                try {
                    o.setFixed(true, tag.getValue("fixed"));
                }
                catch (Exception e2) {
                    throw new ConstructionException("Fixed value illegal!");
                }
            }
            if (tag.hasParam("code_symbol")) {
                o.setSegmentCode(Integer.parseInt(tag.getValue("code_symbol")));
            }
        }
        catch (ConstructionException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw new ConstructionException("Segment endpoints illegal!");
        }
        return true;
    }

    @Override
    public String getPrompt() {
        return Global.name("prompt.segment");
    }

    @Override
    public String getTag() {
        return "Segment";
    }

    @Override
    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams != 2 && nparams != 3) {
            throw new ConstructionException(Global.name("exception.nparams"));
        }
        ConstructionObject P1 = c2.find(params[0]);
        if (P1 == null) {
            throw new ConstructionException(Global.name("exception.notfound") + " " + params[0]);
        }
        if (!(P1 instanceof PointObject)) {
            throw new ConstructionException(Global.name("exception.type") + " " + params[0]);
        }
        ConstructionObject P2 = c2.find(params[1]);
        if (P2 == null) {
            Expression ex = new Expression(params[1], c2, null);
            if (!ex.isValid()) {
                throw new ConstructionException(Global.name("exception.expression"));
            }
            double x = ex.getValue();
            P2 = new PointObject(c2, ((PointObject)P1).getX() + x, ((PointObject)P1).getY());
            c2.add(P2);
            P2.setDefaults();
            SegmentObject s = new SegmentObject(c2, (PointObject)P1, (PointObject)P2);
            s.setDefaults();
            s.setFixed(true, params[1]);
            c2.add(s);
            if (!name.equals("")) {
                s.setNameCheck(name);
            }
            return;
        }
        if (!(P2 instanceof PointObject)) {
            throw new ConstructionException(Global.name("exception.type") + " " + params[1]);
        }
        SegmentObject s = new SegmentObject(c2, (PointObject)P1, (PointObject)P2);
        if (nparams == 3) {
            if (!s.canFix()) {
                throw new ConstructionException(Global.name("exception.canfix"));
            }
            s.setFixed(true, params[2]);
            if (!s.isValidFix()) {
                throw new ConstructionException(Global.name("exception.fix") + " " + params[2]);
            }
            s.validate();
        }
        c2.add(s);
        s.setDefaults();
        if (!name.equals("")) {
            s.setNameCheck(name);
        }
    }
}

