/*
 * Decompiled with CFR 0.152.
 */
package carmetal.constructors;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.constructors.ObjectConstructor;
import carmetal.eric.JZirkelCanvas;
import carmetal.eric.Media;
import carmetal.objects.ConstructionObject;
import carmetal.objects.ImageObject;
import carmetal.objects.PointObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.zirkel.ZirkelCanvas;
import java.awt.event.MouseEvent;

public class ImageConstructor
extends ObjectConstructor {
    PointObject[] P;
    int NPoints;

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.Visual) {
            return;
        }
        PointObject p = zc.selectCreatePoint(e2.getX(), e2.getY(), e2.isAltDown());
        if (p != null) {
            this.P[this.NPoints++] = p;
            p.setSelected(true);
            zc.repaint();
        }
        this.showStatus(zc);
        if (this.NPoints == 3) {
            String filename = zc.loadImage();
            if (filename.equals("")) {
                this.reset(zc);
                return;
            }
            Media.createMedia(filename);
            ImageObject o = new ImageObject(zc.getConstruction(), this.P, filename);
            zc.addObject(o);
            zc.clearSelected();
            this.reset(zc);
            zc.repaint();
        }
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        if (this.NPoints <= 1) {
            zc.showStatus(ConstructionObject.text1(Global.name("message.image"), "" + (this.NPoints + 1)));
        } else {
            zc.showStatus(Global.name("message.image.last"));
        }
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        if (zc.Visual) {
            this.P = new PointObject[3];
            this.NPoints = 0;
            this.showStatus(zc);
        } else {
            zc.setPrompt(Global.name("prompt.image"));
        }
    }

    @Override
    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        if (!this.testTree(tree, "Image")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        for (int i = 0; i < 3; ++i) {
            if (tag.hasParam("point" + (i + 1))) continue;
            throw new ConstructionException("Image points missing!");
        }
        if (!tag.hasParam("filename")) {
            throw new ConstructionException("Image filename missing!");
        }
        try {
            PointObject[] P = new PointObject[3];
            for (int i = 0; i < 3; ++i) {
                P[i] = (PointObject)c2.find(tag.getValue("point" + (i + 1)));
            }
            String filename = JZirkelCanvas.getFilePath(c2) + tag.getValue("filename");
            Media.createMedia(filename);
            ImageObject p = new ImageObject(c2, P, filename);
            this.setName(tag, p);
            this.set(tree, p);
            c2.add(p);
            this.setConditionals(tree, c2, p);
        }
        catch (ConstructionException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new ConstructionException("Image points illegal!");
        }
        return true;
    }

    public String getPrompt() {
        return Global.name("prompt.image");
    }

    @Override
    public String getTag() {
        return "Image";
    }

    @Override
    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
    }
}

