/*
 * Decompiled with CFR 0.152.
 */
package carmetal.constructors;

import carmetal.construction.Construction;
import carmetal.construction.ConstructionException;
import carmetal.constructors.ObjectConstructor;
import carmetal.objects.AngleObject;
import carmetal.objects.ConstructionObject;
import carmetal.objects.FixedAngleObject;
import carmetal.objects.PointObject;
import carmetal.rene.gui.Global;
import carmetal.rene.util.xml.XmlTag;
import carmetal.rene.util.xml.XmlTree;
import carmetal.rene.zirkel.ZirkelCanvas;
import carmetal.rene.zirkel.expression.Expression;
import java.awt.event.MouseEvent;

public class AngleConstructor
extends ObjectConstructor {
    PointObject P1 = null;
    PointObject P2 = null;
    PointObject P3 = null;
    boolean Fixed = false;
    FixedAngleObject A;
    ConstructionObject O;
    boolean ShowsValue;
    int Moved;

    public AngleConstructor(boolean fixed) {
        this.Fixed = fixed;
    }

    public AngleConstructor() {
        this(false);
    }

    @Override
    public void mousePressed(MouseEvent e2, ZirkelCanvas zc) {
        if (!zc.Visual) {
            return;
        }
        if (this.P1 == null) {
            this.P1 = this.select(e2.getX(), e2.getY(), zc, e2.isAltDown());
            if (this.P1 != null) {
                this.P1.setSelected(true);
                zc.repaint();
            }
            this.showStatus(zc);
        } else if (this.P2 == null) {
            this.P2 = this.select(e2.getX(), e2.getY(), zc, e2.isAltDown());
            if (this.P2 != null) {
                this.P2.setSelected(true);
                zc.repaint();
            }
            this.showStatus(zc);
        } else if (!e2.isShiftDown() && !this.Fixed) {
            this.P3 = this.select(e2.getX(), e2.getY(), zc, e2.isAltDown());
            if (this.P3 != null) {
                if (this.P3 == this.P1 || this.P3 == this.P2) {
                    this.P3 = null;
                    return;
                }
                AngleObject a2 = new AngleObject(zc.getConstruction(), this.P1, this.P2, this.P3);
                zc.addObject(a2);
                a2.setDefaults();
                if (this.P3.moveable() && !this.P3.isPointOn() && zc.isNewPoint()) {
                    this.ShowsValue = a2.showValue();
                    if (Global.getParameter("options.movefixname", true)) {
                        a2.setShowValue(true);
                    }
                    this.O = a2;
                    this.Dragging = true;
                    a2.validate();
                    zc.repaint();
                } else {
                    this.Dragging = false;
                    this.P3 = null;
                    this.P2 = null;
                    this.P1 = null;
                    this.reset(zc);
                    zc.validate();
                    zc.repaint();
                }
            }
        } else {
            FixedAngleObject a3 = new FixedAngleObject(zc.getConstruction(), this.P1, this.P2, zc.x(e2.getX()), zc.y(e2.getY()));
            zc.addObject(a3);
            a3.setDefaults();
            a3.init(zc.getConstruction(), zc.x(e2.getX()), zc.y(e2.getY()));
            this.Moved = 0;
            this.Dragging = true;
            this.ShowsValue = a3.showValue();
            if (Global.getParameter("options.movefixname", true)) {
                a3.setShowValue(true);
            }
            this.A = a3;
            this.O = this.A;
            this.P3 = null;
            zc.repaint();
        }
    }

    @Override
    public boolean waitForLastPoint() {
        return this.P1 != null && this.P2 != null;
    }

    @Override
    public boolean waitForPoint() {
        return !this.Fixed || this.P1 == null || this.P2 == null;
    }

    @Override
    public void finishConstruction(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Fixed) {
            this.P3 = this.select(e2.getX(), e2.getY(), zc, e2.isAltDown());
            if (this.P3 != null) {
                AngleObject a2 = new AngleObject(zc.getConstruction(), this.P1, this.P2, this.P3);
                zc.addObject(a2);
                a2.setDefaults();
            }
            zc.repaint();
            this.P3 = null;
        } else {
            FixedAngleObject a3 = new FixedAngleObject(zc.getConstruction(), this.P1, this.P2, zc.x(e2.getX()), zc.y(e2.getY()));
            zc.addObject(a3);
            a3.setDefaults();
            a3.init(zc.getConstruction(), zc.x(e2.getX()), zc.y(e2.getY()));
            zc.setPreviewObject(a3);
            zc.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        ++this.Moved;
        if (this.P3 == null) {
            this.A.init(zc.getConstruction(), zc.x(e2.getX()), zc.y(e2.getY()));
            if (this.A instanceof FixedAngleObject) {
                this.A.setDragable(this.Moved > 5);
            }
        } else {
            this.P3.move(zc.x(e2.getX()), zc.y(e2.getY()));
            zc.validate();
        }
        zc.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e2, ZirkelCanvas zc) {
        if (!this.Dragging) {
            return;
        }
        this.Dragging = false;
        this.O.setShowValue(this.ShowsValue);
        zc.repaint();
        if (this.P3 == null) {
            zc.clearSelected();
            this.A.round();
            if (this.Moved < 5) {
                this.A.edit(zc, true, true);
                if (this.A instanceof FixedAngleObject && this.A.isEditAborted()) {
                    zc.delete(this.A);
                    this.reset(zc);
                    return;
                }
            }
            this.A.validate();
            zc.check();
        } else {
            this.P3.updateText();
        }
        this.reset(zc);
        zc.showStatus();
    }

    public PointObject select(int x, int y, ZirkelCanvas zc, boolean altdown) {
        return zc.selectCreatePoint(x, y, altdown);
    }

    @Override
    public void reset(ZirkelCanvas zc) {
        super.reset(zc);
        if (zc.Visual) {
            this.P3 = null;
            this.P2 = null;
            this.P1 = null;
            this.showStatus(zc);
        } else {
            zc.setPrompt(Global.name("prompt.angle"));
        }
    }

    @Override
    public void showStatus(ZirkelCanvas zc) {
        if (this.Fixed) {
            if (this.P1 == null) {
                zc.showStatus(Global.name("message.fixedangle.first"));
            } else if (this.P2 == null) {
                zc.showStatus(Global.name("message.fixedangle.root"));
            } else {
                zc.showStatus(Global.name("message.fixedangle.second"));
            }
        } else if (this.P1 == null) {
            zc.showStatus(Global.name("message.angle.first"));
        } else if (this.P2 == null) {
            zc.showStatus(Global.name("message.angle.root"));
        } else {
            zc.showStatus(Global.name("message.angle.second"));
        }
    }

    @Override
    public boolean construct(XmlTree tree, Construction c2) throws ConstructionException {
        PointObject p2;
        PointObject p1;
        if (!this.testTree(tree, "Angle")) {
            return false;
        }
        XmlTag tag = tree.getTag();
        if (!tag.hasParam("first")) {
            AngleObject o = new AngleObject(c2);
            try {
                if (tag.hasParam("display")) {
                    String type = tag.getValue("display");
                    if (type.equals("small")) {
                        o.setDisplaySize(0);
                    }
                    if (type.equals("large")) {
                        o.setDisplaySize(3);
                    }
                    if (type.equals("larger")) {
                        o.setDisplaySize(2);
                    }
                    if (type.equals("rectangle")) {
                        o.setDisplaySize(4);
                    }
                }
                this.setName(tag, o);
                this.set(tree, o);
                c2.add(o);
                this.setConditionals(tree, c2, o);
                if (tag.hasTrueParam("filled")) {
                    o.setFilled(true);
                }
                if (tag.hasParam("fixed")) {
                    o.setFixed(tag.getValue("fixed"));
                }
                if (tag.hasTrueParam("acute")) {
                    o.setObtuse(false);
                } else {
                    o.setObtuse(true);
                }
            }
            catch (Exception type) {
                // empty catch block
            }
        }
        if (!tag.hasParam("first") || !tag.hasParam("root")) {
            throw new ConstructionException("Angle parameters missing!");
        }
        if (tag.hasParam("second")) {
            try {
                p1 = (PointObject)c2.find(tag.getValue("first"));
                p2 = (PointObject)c2.find(tag.getValue("root"));
                PointObject p3 = (PointObject)c2.find(tag.getValue("second"));
                AngleObject o = new AngleObject(c2, p1, p2, p3);
                if (tag.hasParam("display")) {
                    String type = tag.getValue("display");
                    if (type.equals("small")) {
                        o.setDisplaySize(0);
                    }
                    if (type.equals("large")) {
                        o.setDisplaySize(3);
                    }
                    if (type.equals("larger")) {
                        o.setDisplaySize(2);
                    }
                    if (type.equals("rectangle")) {
                        o.setDisplaySize(4);
                    }
                }
                this.setName(tag, o);
                this.set(tree, o);
                c2.add(o);
                this.setConditionals(tree, c2, o);
                if (tag.hasTrueParam("filled")) {
                    o.setFilled(true);
                }
                if (tag.hasParam("fixed")) {
                    o.setFixed(tag.getValue("fixed"));
                }
                if (tag.hasTrueParam("acute")) {
                    o.setObtuse(false);
                }
                o.setObtuse(true);
            }
            catch (ConstructionException e2) {
                throw e2;
            }
            catch (Exception e3) {
                throw new ConstructionException("Angle parameters illegal!");
            }
        } else {
            try {
                p1 = (PointObject)c2.find(tag.getValue("first"));
                p2 = (PointObject)c2.find(tag.getValue("root"));
                FixedAngleObject o = new FixedAngleObject(c2, p1, p2, 0.0, 0.0);
                if (tag.hasParam("display")) {
                    String type = tag.getValue("display");
                    if (type.equals("small")) {
                        o.setDisplaySize(0);
                    }
                    if (type.equals("large")) {
                        o.setDisplaySize(3);
                    }
                    if (type.equals("larger")) {
                        o.setDisplaySize(2);
                    }
                    if (type.equals("rectangle")) {
                        o.setDisplaySize(4);
                    }
                }
                this.setName(tag, o);
                this.set(tree, o);
                c2.add(o);
                this.setConditionals(tree, c2, o);
                if (tag.hasTrueParam("filled")) {
                    o.setFilled(true);
                }
                if (tag.hasTrueParam("acute")) {
                    o.setObtuse(false);
                } else {
                    o.setObtuse(true);
                }
                if (tag.hasTrueParam("inverse")) {
                    o.setInverse(true);
                } else {
                    o.setInverse(false);
                }
                if (tag.hasTrueParam("reduced")) {
                    o.setReduced(true);
                } else {
                    o.setReduced(false);
                }
                if (tag.hasTrueParam("dragable")) {
                    o.setDragable(true);
                }
                if (tag.hasTrueParam("drawable")) {
                    o.setDragable(true);
                }
                if (!tag.hasParam("fixed")) {
                    throw new ConstructionException("");
                }
                o.setFixed(tag.getValue("fixed"));
            }
            catch (ConstructionException e4) {
                throw e4;
            }
            catch (Exception e5) {
                throw new ConstructionException("Angle parameters illegal!");
            }
        }
        return true;
    }

    @Override
    public String getTag() {
        return "Angle";
    }

    @Override
    public void construct(Construction c2, String name, String[] params, int nparams) throws ConstructionException {
        if (nparams != 3) {
            throw new ConstructionException(Global.name("exception.nparams"));
        }
        ConstructionObject P1 = c2.find(params[0]);
        if (P1 == null) {
            throw new ConstructionException(Global.name("exception.notfound") + " " + params[0]);
        }
        ConstructionObject P2 = c2.find(params[1]);
        if (P2 == null) {
            throw new ConstructionException(Global.name("exception.notfound") + " " + params[1]);
        }
        ConstructionObject P3 = c2.find(params[2]);
        if (P3 == null || !(P3 instanceof PointObject)) {
            Expression ex = new Expression(params[2], c2, null);
            if (!ex.isValid()) {
                throw new ConstructionException(Global.name("exception.expression"));
            }
            FixedAngleObject s = new FixedAngleObject(c2, (PointObject)P1, (PointObject)P2, 0.0, 0.0);
            s.setFixed(params[2]);
            if (!name.equals("")) {
                s.setNameCheck(name);
            }
            c2.add(s);
            s.setDefaults();
            s.setObtuse(true);
            s.setFixed(params[2]);
            s.validate();
            return;
        }
        if (!(P1 instanceof PointObject)) {
            throw new ConstructionException(Global.name("exception.type") + " " + params[0]);
        }
        if (!(P2 instanceof PointObject)) {
            throw new ConstructionException(Global.name("exception.type") + " " + params[1]);
        }
        if (!(P3 instanceof PointObject)) {
            throw new ConstructionException(Global.name("exception.type") + " " + params[2]);
        }
        if (P1 == P2 || P2 == P3) {
            throw new ConstructionException(Global.name("exception.parameter"));
        }
        AngleObject s = new AngleObject(c2, (PointObject)P1, (PointObject)P2, (PointObject)P3);
        if (!name.equals("")) {
            s.setNameCheck(name);
        }
        c2.add(s);
        s.setDefaults();
    }
}

