/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.JFrame;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.Util;
import vmm.core.View;
import vmm.xm3d.DisplayXM;
import vmm.xm3d.HTMLDocWindow;
import vmm.xm3d.LauncherApplet;
import vmm.xm3d.Menus;

public class WindowXM
extends JFrame {
    private static int openWindowCount;
    private static WindowXM activeWindow;
    private static HTMLDocWindow htmlDocWindow;
    private Menus menus;
    private DisplayXM display;
    private LauncherApplet launcherApplet;

    public DisplayXM getDisplay() {
        return this.display;
    }

    public View getView() {
        return this.display.getView();
    }

    public Exhibit getExhibit() {
        return this.display.getExhibit();
    }

    public Menus getMenus() {
        return this.menus;
    }

    public WindowXM() {
        this((WindowXM)null);
    }

    public static void showHTMLDocWindow(String resourceFileName) {
        if (htmlDocWindow == null) {
            htmlDocWindow = new HTMLDocWindow();
        }
        htmlDocWindow.showFile(resourceFileName);
    }

    public static void showHTMLDocWindow(URL resourceURL) {
        if (htmlDocWindow == null) {
            htmlDocWindow = new HTMLDocWindow();
        }
        htmlDocWindow.showURL(resourceURL);
    }

    public WindowXM(WindowXM parent) {
        this(parent, null, 0);
    }

    public WindowXM(int menuOptionFlags) {
        this(null, null, menuOptionFlags);
    }

    WindowXM(LauncherApplet launcher, int menuOptionFlags) {
        this(null, launcher, menuOptionFlags);
    }

    private WindowXM(WindowXM parent, LauncherApplet launcher, int menuOptionFlags) {
        super(I18n.tr("3dxm.window.defaultname"));
        if (launcher != null) {
            this.launcherApplet = launcher;
        } else if (parent != null) {
            this.launcherApplet = parent.launcherApplet;
        }
        this.setDefaultCloseOperation(2);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int preferredWidth = screenSize.width * 3 / 4;
        if (preferredWidth > 800) {
            preferredWidth = 800;
        }
        int preferredHeight = (int)((double)preferredWidth / 1.628);
        if (preferredWidth > screenSize.width - 40) {
            preferredWidth = screenSize.width - 40;
        }
        if (preferredHeight > screenSize.height - 60) {
            preferredHeight = screenSize.height - 60;
        }
        if (activeWindow != null) {
            WindowXM.activeWindow.display.discardFilmstrip();
        }
        this.display = new DisplayXM();
        this.display.setPreferredSize(new Dimension(preferredWidth, preferredHeight));
        this.setContentPane(this.display.getHolder());
        int options = 0;
        if (menuOptionFlags != 0) {
            options = menuOptionFlags;
        } else if (parent != null) {
            options = parent.getMenus().getOptionFlags();
        }
        this.menus = new Menus(this, null, options);
        this.setJMenuBar(this.menus);
        this.pack();
        if (parent == null) {
            if (Util.isMacOS()) {
                this.setLocation(30, 35);
            } else {
                this.setLocation((screenSize.width - preferredWidth) / 2, 35);
            }
        } else {
            Point p = parent.getLocation();
            int x = p.x + 40;
            int y = p.y + 30;
            if (x + this.getWidth() > screenSize.width) {
                x = 20;
            }
            if (y + this.getHeight() > screenSize.height) {
                y = 40;
            }
            this.setLocation(x, y);
        }
        ++openWindowCount;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent evt) {
                if (WindowXM.this.launcherApplet != null) {
                    WindowXM.this.launcherApplet.windowOpened(WindowXM.this);
                }
            }

            @Override
            public void windowClosed(WindowEvent evt) {
                WindowXM.this.display.stopAnimation();
                WindowXM.this.display.install(null, null);
                openWindowCount--;
                if (WindowXM.this.launcherApplet != null) {
                    WindowXM.this.launcherApplet.windowClosed(WindowXM.this);
                }
                if (openWindowCount == 0 && WindowXM.this.launcherApplet == null) {
                    WindowXM.this.dispose();
                }
            }

            @Override
            public void windowActivated(WindowEvent evt) {
                if (activeWindow != WindowXM.this) {
                    if (activeWindow != null) {
                        activeWindow.display.stopAnimation();
                        activeWindow.display.discardFilmstrip();
                    }
                    activeWindow = WindowXM.this;
                }
            }
        });
        this.display.addPropertyChangeListener("preferredSize", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("preferredSize")) {
                    WindowXM.this.display.invalidate();
                    WindowXM.this.validate();
                    WindowXM.this.pack();
                }
            }
        });
    }

    static {
        I18n.addFile("vmm.xm3d.stringsXM");
    }
}

