/*
 * Decompiled with CFR 0.152.
 */
package vmm.xm3d;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.Prefs;
import vmm.xm3d.Menus;

public class Galleries {
    private GalleryItemList defaultGallery;
    private ArrayList<GalleryItemList> items;
    private GalleryItemList currentGallery;
    private String currentGalleryName;
    private static String documentationLocation;
    private static TreeSet<String> documentationFileList;
    private static Menus waitingForDocInfo;
    private static int setDocLocationCount;

    public Galleries() throws IOException {
        this("vmm/xm3d/galleries.xml");
    }

    public Galleries(String resourceName) throws IOException {
        InputStream input;
        try {
            ClassLoader cl = Galleries.class.getClassLoader();
            URL resourceURL = cl.getResource(resourceName);
            input = resourceURL.openStream();
        }
        catch (Exception e) {
            throw new IOException(I18n.tr("3dxm.galleries.error.CantRead"));
        }
        this.readStream(input);
    }

    public Galleries(InputStream xmlStream) throws IOException {
        this.readStream(xmlStream);
    }

    public String currentGalleryName() {
        return this.currentGalleryName;
    }

    public void selectGalleryByName(String name, Menus menus, JMenu exhibitMenu) {
        if (name == null) {
            this.currentGalleryName = null;
            return;
        }
        for (int i = 0; i < this.items.size(); ++i) {
            GalleryItemList item = this.items.get(i);
            if (item.nodeType.equals("gallery")) {
                if (!item.name.equals(name)) continue;
                this.setUpExhibitMenu(menus, exhibitMenu, item);
                return;
            }
            for (int j = 0; j < item.items.size(); ++j) {
                GalleryItemList subitem = (GalleryItemList)item.items.get(j);
                if (!subitem.name.equals(name)) continue;
                this.setUpExhibitMenu(menus, exhibitMenu, subitem);
                return;
            }
        }
        this.currentGalleryName = null;
    }

    String findGalleryForExhibit(Exhibit exhibit) {
        String classname = exhibit.getClass().getName();
        for (GalleryItemList gallery : this.items) {
            if (gallery == null) continue;
            if (gallery.nodeType.equals("gallery_group")) {
                for (GalleryItem gg : gallery.items) {
                    if (gg == null) continue;
                    assert (gg instanceof GalleryItemList && ((GalleryItemList)gg).nodeType.equals("gallery"));
                    if (!this.findGalleryHelper(classname, (GalleryItemList)gg)) continue;
                    return gg.name;
                }
                continue;
            }
            if (!this.findGalleryHelper(classname, gallery)) continue;
            return gallery.name;
        }
        return null;
    }

    private boolean findGalleryHelper(String classname, GalleryItemList group) {
        for (GalleryItem item : group.items) {
            if (item == null) continue;
            assert (item instanceof ExhibitItem || item instanceof GalleryItemList && ((GalleryItemList)item).nodeType.equals("exhbit_group"));
            if (item instanceof GalleryItemList) {
                for (GalleryItem exhibitItem : ((GalleryItemList)item).items) {
                    if (exhibitItem == null || !classname.equals(((ExhibitItem)exhibitItem).classname)) continue;
                    return true;
                }
                continue;
            }
            if (!classname.equals(((ExhibitItem)item).classname)) continue;
            return true;
        }
        return false;
    }

    public void setUpGalleryMenu(Menus menus, JMenu galleryMenu, JMenu exhibitMenu) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i) == null) {
                galleryMenu.addSeparator();
                continue;
            }
            if (this.items.get((int)i).nodeType.equals("gallery")) {
                GalleryItemList gallery = this.items.get(i);
                galleryMenu.add(new SelectGalleryAction(menus, gallery, exhibitMenu));
                continue;
            }
            GalleryItemList gallery_group = this.items.get(i);
            ArrayList<GalleryItem> subgallery = gallery_group.items;
            JMenu submenu = new JMenu(gallery_group.title);
            for (int j = 0; j < subgallery.size(); ++j) {
                if (subgallery.get(j) == null) {
                    submenu.addSeparator();
                    continue;
                }
                GalleryItemList gallery = (GalleryItemList)subgallery.get(j);
                submenu.add(new SelectGalleryAction(menus, gallery, exhibitMenu));
            }
            galleryMenu.add(submenu);
        }
        this.setUpExhibitMenu(menus, exhibitMenu, this.defaultGallery);
    }

    void setUpExhibitMenu(Menus menus, JMenu exhibitMenu) {
        this.setUpExhibitMenu(menus, exhibitMenu, null);
    }

    private void setUpExhibitMenu(Menus menus, JMenu exhibitMenu, GalleryItemList gallery) {
        if (gallery == null) {
            gallery = this.currentGallery;
        }
        if (gallery == null) {
            gallery = this.defaultGallery;
        }
        this.currentGallery = gallery;
        this.currentGalleryName = gallery.name;
        exhibitMenu.removeAll();
        exhibitMenu.setText(gallery.title);
        for (int i = 0; i < gallery.items.size(); ++i) {
            if (gallery.items.get(i) == null) {
                exhibitMenu.addSeparator();
                continue;
            }
            if (gallery.items.get(i) instanceof ExhibitItem) {
                exhibitMenu.add(new SelectExhibitAction(menus, (ExhibitItem)gallery.items.get(i)));
                continue;
            }
            GalleryItemList exhibitGroup = (GalleryItemList)gallery.items.get(i);
            ArrayList<GalleryItem> items = exhibitGroup.items;
            JMenu submenu = new JMenu(exhibitGroup.title);
            for (int j = 0; j < items.size(); ++j) {
                if (items.get(j) == null) {
                    submenu.addSeparator();
                    continue;
                }
                submenu.add(new SelectExhibitAction(menus, (ExhibitItem)items.get(j)));
            }
            exhibitMenu.add(submenu);
        }
    }

    private void readStream(InputStream xmlStream) throws IOException {
        Document doc;
        DocumentBuilder reader;
        try {
            reader = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new IOException(I18n.tr("3dxm.galleries.error.CantDoXML"));
        }
        try {
            doc = reader.parse(xmlStream);
        }
        catch (SAXException e) {
            throw new IOException(I18n.tr("3dxm.galleries.error.NotXML", e.getMessage()));
        }
        catch (IOException e) {
            throw new IOException(I18n.tr("3dxm.galleries.error.CantRead", e.getMessage()));
        }
        Element galleriesElement = doc.getDocumentElement();
        if (!galleriesElement.getTagName().equals("galleries")) {
            throw new IOException(I18n.tr("3dxm.galleries.error.WrongXML", galleriesElement.getTagName()));
        }
        NodeList children = galleriesElement.getChildNodes();
        this.items = new ArrayList();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element itemElement = (Element)children.item(i);
            if (itemElement.getTagName().equals("gallery")) {
                this.items.add(this.buildGallery(itemElement));
                continue;
            }
            if (itemElement.getTagName().equals("gallery_group")) {
                this.items.add(this.buildGalleryGroup(itemElement));
                continue;
            }
            throw new IOException(I18n.tr("3dxm.galleries.error.WrongXML", galleriesElement.getTagName()));
        }
    }

    private GalleryItemList buildGallery(Element galleryElement) throws IOException {
        String name = galleryElement.getAttribute("name").trim();
        if (name.length() == 0) {
            throw new IOException(I18n.tr("3dxm.galleries.error.MissingAttribute", "name", "gallery"));
        }
        String title = galleryElement.getAttribute("title").trim();
        if (title.length() == 0) {
            title = I18n.tr(name);
        }
        NodeList itemElements = galleryElement.getChildNodes();
        int itemCount = itemElements.getLength();
        ArrayList<GalleryItem> items = new ArrayList<GalleryItem>();
        for (int i = 0; i < itemCount; ++i) {
            if (!(itemElements.item(i) instanceof Element)) continue;
            Element itemElement = (Element)itemElements.item(i);
            String tagName = itemElement.getTagName();
            if (tagName.equals("separator")) {
                items.add(null);
                continue;
            }
            if (tagName.equals("exhibit")) {
                items.add(this.buildGalleryItem(itemElement));
                continue;
            }
            if (tagName.equals("xml_exhibit")) {
                items.add(this.buildXMLGalleryItem(itemElement));
                continue;
            }
            if (tagName.equals("exhibit_group")) {
                items.add(this.buildGalleryItemGroup(itemElement));
                continue;
            }
            throw new IOException(I18n.tr("3dxm.galleries.error.WrongXML", tagName));
        }
        GalleryItemList g = new GalleryItemList();
        g.nodeType = "gallery";
        g.name = name;
        g.title = title;
        g.items = items;
        String isDefault = galleryElement.getAttribute("default").trim();
        if (isDefault.equals("yes") || this.defaultGallery == null) {
            this.defaultGallery = g;
        }
        return g;
    }

    private GalleryItemList buildGalleryGroup(Element galleryGroupElement) throws IOException {
        String name = galleryGroupElement.getAttribute("name").trim();
        if (name.length() == 0) {
            throw new IOException(I18n.tr("3dxm.galleries.error.MissingAttribute", "name", "gallery_group"));
        }
        String title = galleryGroupElement.getAttribute("title").trim();
        if (title.length() == 0) {
            title = I18n.tr(name);
        }
        NodeList itemElements = galleryGroupElement.getChildNodes();
        int itemCount = itemElements.getLength();
        ArrayList<GalleryItemList> galleries = new ArrayList<GalleryItemList>();
        for (int i = 0; i < itemCount; ++i) {
            if (!(itemElements.item(i) instanceof Element)) continue;
            Element itemElement = (Element)itemElements.item(i);
            String tagName = itemElement.getTagName();
            if (tagName.equals("gallery")) {
                galleries.add(this.buildGallery(itemElement));
                continue;
            }
            if (tagName.equals("separator")) {
                galleries.add(null);
                continue;
            }
            throw new IOException(I18n.tr("3dxm.galleries.error.WrongXML", tagName));
        }
        GalleryItemList g = new GalleryItemList();
        g.nodeType = "gallery_group";
        g.name = name;
        g.title = title;
        g.items = galleries;
        return g;
    }

    private ExhibitItem buildGalleryItem(Element exhibitElement) throws IOException {
        String title;
        String classname = exhibitElement.getAttribute("class").trim();
        if (classname.length() == 0) {
            throw new IOException(I18n.tr("3dxm.galleries.error.MissingAttribute", "class", "exhibit"));
        }
        String name = exhibitElement.getAttribute("name").trim();
        if (name.length() == 0) {
            name = classname;
        }
        if ((title = exhibitElement.getAttribute("title").trim()).length() == 0) {
            title = I18n.tr(name);
        }
        ExhibitItem g = new ExhibitItem();
        g.classname = classname;
        g.name = name;
        g.title = title;
        g.isXML = false;
        return g;
    }

    private ExhibitItem buildXMLGalleryItem(Element exhibitElement) throws IOException {
        String title;
        String classname = exhibitElement.getAttribute("file").trim();
        if (classname.length() == 0) {
            throw new IOException(I18n.tr("3dxm.galleries.error.MissingAttribute", "file", "xml_exhibit"));
        }
        String name = exhibitElement.getAttribute("name").trim();
        if (name.length() == 0) {
            name = classname;
        }
        if ((title = exhibitElement.getAttribute("title").trim()).length() == 0) {
            title = I18n.tr(name);
        }
        ExhibitItem g = new ExhibitItem();
        g.classname = classname;
        g.name = name;
        g.title = title;
        g.isXML = true;
        return g;
    }

    private GalleryItemList buildGalleryItemGroup(Element exhibitGroupElement) throws IOException {
        String name = exhibitGroupElement.getAttribute("name").trim();
        if (name.length() == 0) {
            throw new IOException(I18n.tr("3dxm.galleries.error.MissingAttribute", "name", "exhibit_group"));
        }
        String title = exhibitGroupElement.getAttribute("title").trim();
        if (title.length() == 0) {
            title = I18n.tr(name);
        }
        NodeList itemElements = exhibitGroupElement.getChildNodes();
        int itemCount = itemElements.getLength();
        ArrayList<ExhibitItem> items = new ArrayList<ExhibitItem>();
        for (int i = 0; i < itemCount; ++i) {
            if (!(itemElements.item(i) instanceof Element)) continue;
            Element itemElement = (Element)itemElements.item(i);
            String tagName = itemElement.getTagName();
            if (tagName.equals("exhibit")) {
                items.add(this.buildGalleryItem(itemElement));
                continue;
            }
            if (tagName.equals("separator")) {
                items.add(null);
                continue;
            }
            throw new IOException(I18n.tr("3dxm.galleries.error.WrongXML", tagName));
        }
        GalleryItemList g = new GalleryItemList();
        g.nodeType = "exhibit_group";
        g.name = name;
        g.title = title;
        g.items = items;
        return g;
    }

    static synchronized void setDocumentationLocation() {
        final String docLoc = Prefs.get("3dxm.docprefs.documentationBaseURL", I18n.tr("3dxm.DocPrefsDialog.DefaultDocumentationLocation"));
        if (docLoc.equals(documentationLocation)) {
            return;
        }
        documentationLocation = docLoc;
        documentationFileList = null;
        final int ct = ++setDocLocationCount;
        Thread reader = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                TreeSet<String> files = new TreeSet<String>();
                try {
                    String line;
                    URL url;
                    if (docLoc.startsWith("http://")) {
                        String doc = docLoc.endsWith("/") ? docLoc + "doclist.txt" : docLoc + "/" + "doclist.txt";
                        url = new URL(doc);
                    } else {
                        File docFile = new File(docLoc, "doclist.txt");
                        url = docFile.getAbsoluteFile().toURI().toURL();
                    }
                    BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "ISO-8859-1"));
                    while ((line = in.readLine()) != null) {
                        files.add(line);
                    }
                    in.close();
                }
                catch (Exception e) {
                    System.out.println("Error reading documentation file list.\n" + e);
                }
                finally {
                    Galleries.gotDocInfo(files, ct);
                }
            }
        };
        reader.start();
    }

    private static synchronized void gotDocInfo(TreeSet<String> files, int idCount) {
        if (idCount != setDocLocationCount) {
            return;
        }
        documentationFileList = files;
        if (waitingForDocInfo != null) {
            waitingForDocInfo.gotDocumnetationFileList(files);
            waitingForDocInfo = null;
        }
    }

    static synchronized boolean documentationFileExists(Menus requester, String fileName) {
        if (documentationFileList == null) {
            waitingForDocInfo = requester;
            return false;
        }
        return documentationFileList.contains(fileName);
    }

    static {
        Galleries.setDocumentationLocation();
    }

    private class SelectExhibitAction
    extends AbstractAction {
        Menus menus;
        ExhibitItem exhibitItem;

        SelectExhibitAction(Menus menus, ExhibitItem exhibitItem) {
            super(exhibitItem.title);
            this.menus = menus;
            this.exhibitItem = exhibitItem;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.menus.installExhibit(this.exhibitItem);
        }
    }

    private class SelectGalleryAction
    extends AbstractAction {
        JMenu exhibitMenu;
        GalleryItemList gallery;
        Menus menus;

        SelectGalleryAction(Menus menus, GalleryItemList gallery, JMenu exhibitMenu) {
            super(gallery.title);
            this.menus = menus;
            this.gallery = gallery;
            this.exhibitMenu = exhibitMenu;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Galleries.this.currentGalleryName = this.gallery.name;
            this.menus.installExhibit(null);
            Galleries.this.setUpExhibitMenu(this.menus, this.exhibitMenu, this.gallery);
        }
    }

    private static class GalleryItemList
    extends GalleryItem {
        String nodeType;
        ArrayList<GalleryItem> items;

        private GalleryItemList() {
        }
    }

    static class ExhibitItem
    extends GalleryItem {
        boolean isXML;
        String classname;

        ExhibitItem() {
        }
    }

    static class GalleryItem {
        String name;
        String title;

        GalleryItem() {
        }
    }
}

