/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.Vector3D;
import vmm.surface.SurfaceView;
import vmm.surface.parametric.SurfaceParametric;

public class SnailShell
extends SurfaceParametric {
    private RealParamAnimateable a = new RealParamAnimateable("a", 1.0, 1.0, 1.0);
    private RealParamAnimateable b = new RealParamAnimateable("b", 1.4, 1.0, 1.4);
    private RealParamAnimateable c = new RealParamAnimateable("c", 0.05, 0.1, 0.05);
    private RealParamAnimateable d = new RealParamAnimateable("d", 6.0, 2.0, 6.0);

    public SnailShell() {
        this.addParameter(this.d);
        this.addParameter(this.c);
        this.addParameter(this.b);
        this.addParameter(this.a);
        this.setDefaultViewpoint(new Vector3D(-40.0, 20.0, 0.0));
        this.setDefaultWindow(-3.5, 3.5, -3.5, 3.5);
        this.umin.reset("-pi");
        this.umax.reset("pi");
        this.vmin.reset(-2.0);
        this.vmax.reset(25.0);
        this.uPatchCount.setValueAndDefault(30);
        this.vPatchCount.setValueAndDefault(40);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double auxa = this.a.getValue();
        double auxb = this.b.getValue();
        double auxc = this.c.getValue();
        double auxd = this.d.getValue();
        double vv = v + (v - this.vmin.getValue()) * (v - this.vmin.getValue()) / 16.0;
        double s = Math.exp(-auxc * vv);
        double r = s * (auxa + auxb * Math.cos(u));
        return new Vector3D(r * Math.cos(vv), auxd - s * (auxd + auxb * Math.sin(u)), r * Math.sin(vv));
    }

    @Override
    public View getDefaultView() {
        SurfaceView mySurfaceView = new SurfaceView();
        mySurfaceView.setGridSpacing(0);
        mySurfaceView.setAntialiased(true);
        return mySurfaceView;
    }
}

