/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import java.awt.Color;
import vmm.core.Complex;
import vmm.core.RealParamAnimateable;
import vmm.core.View;
import vmm.core3D.ComplexVector3D;
import vmm.core3D.GridTransformMatrix;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.WeierstrassMinimalSurface;

public class SchoenCLPsurface
extends WeierstrassMinimalSurface {
    private RealParamAnimateable aa = new RealParamAnimateable("vmm.surface.parametric.SchoenCLPsurface.aa", 0.6, 0.52, 0.98);
    private RealParamAnimateable bb = new RealParamAnimateable("vmm.surface.parametric.SchoenCLPsurface.bb", 0.2, 0.48, 0.02);
    private int um;
    private int vm;
    private double alpha;
    private double beta;
    private double c2a;
    private double c2b;
    private double coeff;
    private double coecc;
    private double scale;
    private Complex ccff;
    private Vector3D surf_1;
    private Vector3D surf_2;

    public SchoenCLPsurface() {
        this.addParameter(this.bb);
        this.bb.setMaximumValueForInput(0.95);
        this.bb.setMinimumValueForInput(0.02);
        this.addParameter(this.aa);
        this.aa.setMaximumValueForInput(0.99);
        this.aa.setMinimumValueForInput(0.05);
        this.setDefaultViewUp(new Vector3D(-0.57, 0.6, 0.58));
        this.setDefaultViewpoint(new Vector3D(15.0, -25.0, 40.0));
        this.setDefaultWindow(-5.0, 5.0, -4.0, 4.0);
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(24);
        this.umin.reset(0.005);
        this.umax.reset(0.999);
        this.vmin.reset(-1.0);
        this.vmax.reset(1.0);
        this.removeParameter(this.vmin);
        this.removeParameter(this.vmax);
        this.removeParameter(this.umin);
        this.removeParameter(this.umax);
        this.iFirstInHelper = false;
        this.wantsToSeeDomain = false;
        this.wantsToSeeGaussImage = false;
        if (this.wantsToSeeGaussImage) {
            this.wantsToSeeDomain = true;
        }
        if (this.wantsToSeeDomain) {
            this.setDefaultViewUp(new Vector3D(0.0, 0.0, 1.0));
            this.setDefaultViewpoint(new Vector3D(0.0, 0.0, 40.0));
        }
        this.multipleCopyOptions = new int[]{2};
        this.canShowConjugateSurface = true;
    }

    @Override
    public View getDefaultView() {
        WeierstrassMinimalSurface.WMSView view = new WeierstrassMinimalSurface.WMSView(this);
        view.setGridSpacing(12);
        this.setDefaultOrientation(1);
        float c0 = 0.2f;
        view.getLightSettings().setAmbientLight(new Color(c0, c0, c0));
        view.getLightSettings().setSpecularExponent(100);
        view.getLightSettings().setSpecularRatio(0.8f);
        return view;
    }

    @Override
    protected void createData() {
        super.createData();
        this.computePeriodData();
        this.data.discardGridTransforms();
        GridTransformMatrix[] trList = new GridTransformMatrix[64];
        trList[0] = new GridTransformMatrix();
        GridTransformMatrix a = new GridTransformMatrix();
        trList[1] = new GridTransformMatrix().scale(-1.0, -1.0, 1.0);
        if (!this.wantsToSeeDomain) {
            int e;
            this.data.addGridTransform(trList[1]);
            for (e = 0; e < 2; ++e) {
                trList[2 + e] = new GridTransformMatrix(trList[e]).scale(-1.0, -1.0, -1.0).reverse().translate(this.surf_1);
                this.data.addGridTransform(trList[2 + e]);
            }
            if (!this.inAssociateMorph && (this.flag0 || this.flag05)) {
                a = new GridTransformMatrix().scale(-1.0, -1.0, 1.0).reverse().translate(this.surf_1.x, this.surf_1.y, 0.0);
                for (e = 0; e < 4; ++e) {
                    trList[4 + e] = new GridTransformMatrix(trList[e]).leftMultiplyBy(a);
                    this.data.addGridTransform(trList[4 + e]);
                }
                a = new GridTransformMatrix().scale(-1.0, -1.0, 1.0);
                for (e = 0; e < 4; ++e) {
                    trList[8 + e] = new GridTransformMatrix(trList[2 + e]).leftMultiplyBy(a);
                    this.data.addGridTransform(trList[8 + e]);
                }
                if (this.getNumberOfPieces() == 2) {
                    if (this.flag0) {
                        a = new GridTransformMatrix().scale(1.0, 1.0, -1.0).translate(0.0, 0.0, this.surf_2.z);
                    } else if (this.flag05) {
                        a = new GridTransformMatrix().scale(1.0, 1.0, -1.0).translate(this.surf_2.x, this.surf_2.y, this.surf_2.z);
                    }
                    for (e = 0; e < 12; ++e) {
                        trList[12 + e] = new GridTransformMatrix(trList[e]).leftMultiplyBy(a);
                        this.data.addGridTransform(trList[12 + e]);
                    }
                }
            }
        }
    }

    public static double paramRescaleEnd(double x) {
        double y = Math.sin(1.5707963267948966 * x);
        return y;
    }

    public static double paramRescaleStart(double x) {
        double y = 1.0 - Math.cos(1.5707963267948966 * x);
        return y;
    }

    public static double paramRescaleBoth(double x) {
        double y = (1.0 - Math.cos(Math.PI * x)) / 2.0;
        return y;
    }

    public static double paramRescaleMiddle(double x) {
        double y = (1.0 + x * Math.abs(x)) / 2.0;
        return y;
    }

    @Override
    protected Complex domainGrid(double u, double v) {
        boolean vflag = false;
        double ph = 0.0;
        double r = SchoenCLPsurface.paramRescaleEnd(u);
        if (v < 0.0) {
            v = -v;
            vflag = true;
        }
        if (v <= 0.3333333333333333) {
            ph = this.beta * SchoenCLPsurface.paramRescaleEnd(3.0 * v);
        } else if (v <= 0.6666666666666666) {
            ph = this.beta - (this.beta - this.alpha) * SchoenCLPsurface.paramRescaleBoth(3.0 * v - 1.0);
        } else if (v <= 1.0) {
            ph = this.alpha + (1.5707963267948966 - this.alpha) * SchoenCLPsurface.paramRescaleStart(3.0 * v - 2.0);
        }
        Complex z = new Complex(r * Math.cos(ph), r * Math.sin(ph));
        if (this.wantsToSeeGaussImage) {
            z = this.mu(z);
        }
        if (vflag) {
            z = z.conj();
        }
        return z.conj();
    }

    @Override
    protected Complex gauss(Complex z) {
        return z;
    }

    protected Complex mu(Complex z) {
        boolean vflag = false;
        if (z.im < 0.0) {
            z = z.conj();
            vflag = true;
        }
        Complex g2 = z.times(z);
        Complex w2 = g2.inverse();
        w2.assignPlus(g2);
        Complex v2 = w2.minus(2.0 * this.c2a);
        w2.re -= 2.0 * this.c2b;
        w2.assignTimes(v2);
        v2 = w2.squareRootNearer(I_C);
        if (vflag) {
            v2 = v2.conj();
        }
        return v2;
    }

    @Override
    protected Complex hPrime(Complex z) {
        Complex w = this.mu(z);
        w.assignTimes(z);
        w.assignInvert();
        return w;
    }

    @Override
    protected void redoConstants() {
        super.redoConstants();
        this.alpha = 1.5707963267948966 * this.aa.getValue();
        this.beta = 1.5707963267948966 * this.bb.getValue();
        this.c2a = Math.cos(2.0 * this.alpha);
        this.c2b = Math.cos(2.0 * this.beta);
        this.coeff = 0.5 * (this.c2a - this.c2b);
        this.ccff = new Complex(0.0, -2.0 * this.coeff);
        this.coecc = this.c2a + this.c2b;
        this.scale = 1.0;
    }

    @Override
    protected ComplexVector3D getCenter() {
        ComplexVector3D gC = new ComplexVector3D(this.helperArray[0][0]);
        gC = gC.plus(this.helperArray[0][this.vcount - 1]).times(0.5);
        return gC;
    }

    public void computePeriodData() {
        this.surf_1 = this.surfacePoint(this.umax.getValue(), 0.3333333333333333).times(2.0);
        this.surf_2 = this.surfacePoint(this.umax.getValue(), 0.6666666666666666).times(2.0);
    }
}

