/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class ParametricBreather
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 0.4, 0.8, 0.4);

    public ParametricBreather() {
        this.uPatchCount.setValueAndDefault(24);
        this.vPatchCount.setValueAndDefault(24);
        this.umin.reset(-13.4, -10.0, -13.4);
        this.umax.reset(13.4, 10.0, 13.4);
        this.vmin.reset("-37.2", "-3*pi", "-37.2");
        this.vmax.reset("37.2", "3*pi", "37.2");
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.5));
        this.setDefaultWindow(-5.5, 5.5, -5.5, 5.5);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
    }

    private static double sinh(double t) {
        return 0.5 * (Math.exp(t) - Math.exp(-t));
    }

    private static double cosh(double t) {
        return 0.5 * (Math.exp(t) + Math.exp(-t));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double wsqr = 1.0 - AA * AA;
        double w = Math.sqrt(wsqr);
        double q = w * w * ParametricBreather.cosh(AA * u) * ParametricBreather.cosh(AA * u);
        double r = AA * AA * Math.sin(w * v) * Math.sin(w * v);
        double denom = AA * (q + r);
        double x = -u + 2.0 * wsqr * ParametricBreather.cosh(AA * u) * ParametricBreather.sinh(AA * u) / denom;
        double y = 2.0 * w * ParametricBreather.cosh(AA * u) * (-(w * Math.cos(v) * Math.cos(w * v)) - Math.sin(v) * Math.sin(w * v)) / denom;
        double z = 2.0 * w * ParametricBreather.cosh(AA * u) * (-(w * Math.sin(v) * Math.cos(w * v)) + Math.cos(v) * Math.sin(w * v)) / denom;
        return new Vector3D(x, y, z);
    }
}

