/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class LissajousSurface
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "1", "1", "1");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", "1", "1", "1");
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", "1", "1", "1");
    private RealParamAnimateable dd = new RealParamAnimateable("genericParam.dd", "0.0", "0.0", "pi/2");

    public LissajousSurface() {
        this.uPatchCount.setValueAndDefault(18);
        this.vPatchCount.setValueAndDefault(18);
        this.umin.reset("-pi");
        this.umax.reset("pi");
        this.vmin.reset("-pi");
        this.vmax.reset("pi");
        this.setDefaultViewpoint(new Vector3D(-4.25, -0.67, 8.7));
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.addParameter(this.cc);
        this.addParameter(this.dd);
    }

    private static double sin(double t) {
        return Math.sin(t);
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = Math.round(this.aa.getValue());
        double BB = Math.round(this.bb.getValue());
        double CC = Math.round(this.cc.getValue());
        double DD = this.dd.getValue();
        double x = AA * LissajousSurface.sin(u);
        double y = BB * LissajousSurface.sin(v);
        double z = CC * LissajousSurface.sin(DD - AA * u - BB * v);
        return new Vector3D(x, y, z);
    }
}

