/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class KuenSurface
extends SurfaceParametric {
    public KuenSurface() {
        this.uPatchCount.setValueAndDefault(21);
        this.vPatchCount.setValueAndDefault(21);
        this.umin.reset(-4.0);
        this.umax.reset(4.0);
        this.vmin.reset(-3.75);
        this.vmax.reset(3.75);
        this.setDefaultViewpoint(new Vector3D(10.0, -10.0, 10.0));
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
    }

    private static double sinh(double t) {
        return 0.5 * (Math.exp(t) - Math.exp(-t));
    }

    private static double cosh(double t) {
        return 0.5 * (Math.exp(t) + Math.exp(-t));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double x = 2.0 * KuenSurface.cosh(v) * (Math.cos(u) + u * Math.sin(u)) / (KuenSurface.cosh(v) * KuenSurface.cosh(v) + u * u);
        double y = 2.0 * KuenSurface.cosh(v) * (-u * Math.cos(u) + Math.sin(u)) / (KuenSurface.cosh(v) * KuenSurface.cosh(v) + u * u);
        double z = v - 2.0 * KuenSurface.sinh(v) * KuenSurface.cosh(v) / (KuenSurface.cosh(v) * KuenSurface.cosh(v) + u * u);
        return new Vector3D(x, y, z);
    }
}

