/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.Complex;
import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Enneper_Polar
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", 0.6, 0.6, 0.0);
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", 0.0, 0.0, 0.0);
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", 0.0, 0.0, 0.25);

    public Enneper_Polar() {
        this.uPatchCount.setValueAndDefault(24);
        this.vPatchCount.setValueAndDefault(24);
        this.umin.reset(0.0);
        this.umax.reset(2.0);
        this.vmin.reset(0.0);
        this.vmax.reset("2 * pi");
        this.setDefaultViewpoint(new Vector3D(-0.635, 0.635, 30.0));
        this.setDefaultWindow(-4.0, 4.0, -4.0, 4.0);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
    }

    private static Complex AplusZW(double a, Complex z, Complex w) {
        Complex A = new Complex(a, 0.0);
        return A.plus(z.times(w));
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double BB = this.bb.getValue();
        double CC = this.cc.getValue();
        Complex z = new Complex(u * Math.cos(v), u * Math.sin(v));
        Complex z2 = new Complex(z.re * z.re - z.im * z.im, 2.0 * z.re * z.im);
        Complex zCube = new Complex(z.times(z.times(z)));
        Complex CChalf = new Complex(0.5 * CC, 0.0);
        Complex CCSquareOver7 = new Complex(CC * CC / 7.0, 0.0);
        Complex wh = new Complex();
        wh = z2.times(Enneper_Polar.AplusZW(AA, z, Enneper_Polar.AplusZW(BB / 1.5, z, CChalf)));
        Complex w_g = new Complex();
        Complex wg = new Complex();
        w_g = z;
        wg = Enneper_Polar.AplusZW((BB * BB + 2.0 * AA * CC) / 5.0, z, Enneper_Polar.AplusZW(BB * CC / 3.0, z, CCSquareOver7));
        wg = zCube.times(Enneper_Polar.AplusZW(AA * AA / 3.0, z, Enneper_Polar.AplusZW(AA * BB / 2.0, z, wg)));
        double x = wg.re - w_g.re;
        double y = -wg.im - w_g.im;
        double zz = wh.re;
        return new Vector3D(x, y, zz);
    }
}

