/*
 * Decompiled with CFR 0.152.
 */
package vmm.surface.parametric;

import vmm.core.RealParamAnimateable;
import vmm.core3D.Vector3D;
import vmm.surface.parametric.SurfaceParametric;

public class Cyclide
extends SurfaceParametric {
    private RealParamAnimateable aa = new RealParamAnimateable("genericParam.aa", "1.75", "1.75", "1.2");
    private RealParamAnimateable bb = new RealParamAnimateable("genericParam.bb", "0.4", "0.4", "1.2");
    private RealParamAnimateable cc = new RealParamAnimateable("genericParam.cc", "0.4", "0.4", "1.2");
    private RealParamAnimateable dd = new RealParamAnimateable("genericParam.dd", "1", "1", "1");
    private RealParamAnimateable ee = new RealParamAnimateable("genericParam.ee", "1", "1", "1");
    private RealParamAnimateable ff = new RealParamAnimateable("genericParam.ff", "1", "1", "1");
    private RealParamAnimateable gg = new RealParamAnimateable("genericParam.gg", "3.25", "3.55", "3.55");
    private RealParamAnimateable hh = new RealParamAnimateable("genericParam.hh", "2.25", "2.25", "2.25");

    public Cyclide() {
        this.uPatchCount.setValueAndDefault(12);
        this.vPatchCount.setValueAndDefault(32);
        this.umin.reset("0");
        this.umax.reset("2 pi");
        this.vmin.reset("0");
        this.vmax.reset("2 pi");
        this.setDefaultViewpoint(new Vector3D(-20.0, -6.0, -6.0));
        this.setDefaultWindow(-3.0, 3.0, -3.0, 3.0);
        this.setDefaultOrientation(2);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.addParameter(this.cc);
        this.addParameter(this.dd);
        this.addParameter(this.ee);
        this.addParameter(this.ff);
        this.addParameter(this.gg);
        this.addParameter(this.hh);
    }

    private static Vector3D Inversion(double radius, Vector3D center, Vector3D source) {
        Vector3D u = new Vector3D();
        Vector3D P = new Vector3D();
        u.x = source.x - center.x;
        u.y = source.y - center.y;
        u.z = source.z - center.z;
        double nrmsqr = u.x * u.x + u.y * u.y + u.z * u.z;
        double mult = radius / nrmsqr;
        P.x = mult * u.x + center.x;
        P.y = mult * u.y + center.y;
        P.z = mult * u.z + center.z;
        return P;
    }

    @Override
    public Vector3D surfacePoint(double u, double v) {
        double AA = this.aa.getValue();
        double BB = this.bb.getValue();
        double CC = this.cc.getValue();
        double DD = this.dd.getValue();
        double EE = this.ee.getValue();
        double FF = this.ff.getValue();
        double GG = this.gg.getValue();
        double HH = this.hh.getValue();
        double x = (AA + BB * Math.cos(u)) * Math.cos(v);
        double y = (AA + BB * Math.cos(u)) * Math.sin(v);
        double z = CC * Math.sin(u);
        Vector3D center = new Vector3D(DD, EE, FF);
        Vector3D toruspoint = new Vector3D(x, y, z);
        Vector3D P = new Vector3D();
        P = Cyclide.Inversion(GG, center, toruspoint);
        P.z += HH;
        return P;
    }
}

