/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import vmm.core.Parameter;
import vmm.core.UserExhibit;
import vmm.core.VariableParamAnimateable;
import vmm.core3D.UserExhibit3D;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class UserSpaceCurveKappaTau
extends SpaceCurveParametric
implements UserExhibit3D {
    private UserExhibit3D.Support userExhibitSupport;
    private UserExhibit.FunctionInfo Kappa;
    private UserExhibit.FunctionInfo Tau;
    int tr;
    Vector3D startPoint;
    Vector3D P;
    Vector3D T;
    Vector3D N;
    Vector3D B;
    Vector3D[] initialFrenet;
    Vector3D[] repere;
    Vector3D[] pointSet;
    Vector3D[] helperFrame;
    boolean needsNewArray;
    Vector3D dT1;
    Vector3D dN1;
    Vector3D dB1;
    Vector3D dT2;
    Vector3D dN2;
    Vector3D dB2;
    Vector3D dT3;
    Vector3D dN3;
    Vector3D dB3;
    Vector3D dT4;
    Vector3D dN4;
    Vector3D dB4;
    Vector3D Vvv;

    public UserSpaceCurveKappaTau() {
        this.tr = this.tResolution.getValue();
        this.startPoint = new Vector3D(0.0, 0.0, 0.0);
        this.P = new Vector3D(0.0, 0.0, -1.0);
        this.T = new Vector3D(1.0, 0.0, 0.0);
        this.N = new Vector3D(0.0, 1.0, 0.0);
        this.B = new Vector3D(0.0, 0.0, 1.0);
        this.initialFrenet = new Vector3D[]{this.startPoint, this.T, this.N, this.B};
        this.repere = new Vector3D[]{this.P, this.T, this.N, this.B};
        this.pointSet = new Vector3D[this.tr + 1];
        this.helperFrame = new Vector3D[4 * (this.tr + 1)];
        this.needsNewArray = true;
        this.dT1 = new Vector3D(0.0, 0.0, 0.0);
        this.dN1 = new Vector3D(0.0, 0.0, 0.0);
        this.dB1 = new Vector3D(0.0, 0.0, 0.0);
        this.dT2 = new Vector3D(0.0, 0.0, 0.0);
        this.dN2 = new Vector3D(0.0, 0.0, 0.0);
        this.dB2 = new Vector3D(0.0, 0.0, 0.0);
        this.dT3 = new Vector3D(0.0, 0.0, 0.0);
        this.dN3 = new Vector3D(0.0, 0.0, 0.0);
        this.dB3 = new Vector3D(0.0, 0.0, 0.0);
        this.dT4 = new Vector3D(0.0, 0.0, 0.0);
        this.dN4 = new Vector3D(0.0, 0.0, 0.0);
        this.dB4 = new Vector3D(0.0, 0.0, 0.0);
        this.Vvv = new Vector3D(0.0, 0.0, 0.0);
        this.setDefaultViewpoint(new Vector3D(0.0, -16.0, -6.0));
        this.setDefaultWindow(-2.0, 2.0, -1.7, 1.7);
        this.tResolution.setValueAndDefault(300);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("4*pi");
        this.tubeSize.reset(0.1);
        this.userExhibitSupport = new UserExhibit3D.Support(this);
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("a", 2.0, 2.0, 2.0));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("b", 0.0, 0.0, 0.0));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("c", 0.2, 0.2, 0.2));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("d", 2.0, 1.5, 3.5));
        this.Kappa = this.userExhibitSupport.addRealFunction("kappa", "(a + b*cos(t))", "t");
        this.Tau = this.userExhibitSupport.addRealFunction("tau", "(c + d*sin(3*t))", "t");
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.needsNewArray = true;
    }

    protected double kappa(double t) {
        return this.Kappa.realFunctionValue(t);
    }

    protected double tau(double t) {
        return this.Tau.realFunctionValue(t);
    }

    protected Vector3D[] frenetODEstep2(double tInitial, double tFinal, Vector3D[] initialVal, int numSubdivision) {
        this.P = initialVal[0];
        this.T = initialVal[1];
        this.N = initialVal[2];
        this.B = initialVal[3];
        double t = tInitial;
        double newSub = (1.0 + Math.abs(tFinal - tInitial)) * (double)numSubdivision;
        double dt = (tFinal - tInitial) / newSub;
        Vector3D midT = new Vector3D(this.T);
        Vector3D midN = new Vector3D(this.N);
        Vector3D midB = new Vector3D(this.B);
        int i = 0;
        while ((double)i < newSub) {
            midT = this.T.plus(this.N.times(this.kappa(t) * dt / 2.0));
            midN = this.N.plus(this.T.times(-this.kappa(t) * dt / 2.0)).plus(this.B.times(this.tau(t) * dt / 2.0));
            midB = this.B.plus(this.N.times(-this.tau(t) * dt / 2.0));
            this.P = this.P.plus(this.T.plus(midT.times(4.0)).times(dt / 6.0));
            this.T = this.T.plus(midN.times(this.kappa(t += dt / 2.0) * dt));
            this.N = this.N.plus(midT.times(-this.kappa(t) * dt)).plus(midB.times(this.tau(t) * dt));
            this.B = this.B.plus(midN.times(-this.tau(t) * dt));
            this.P = this.P.plus(this.T.times(dt / 6.0));
            t += dt / 2.0;
            ++i;
        }
        return new Vector3D[]{this.P, this.T, this.N, this.B};
    }

    protected Vector3D[] frenetODEstep4(double tInitial, double tFinal, Vector3D[] initialVal, int numSubdivision) {
        this.P = initialVal[0];
        this.T = initialVal[1];
        this.N = initialVal[2];
        this.B = initialVal[3];
        double t = tInitial;
        double newSub = Math.floor((1.0 + Math.abs(tFinal - tInitial)) * (double)numSubdivision);
        double dt = (tFinal - tInitial) / newSub / 2.0;
        newSub -= 0.0625;
        int i = 0;
        while ((double)i < newSub) {
            for (int j = 1; j < 3; ++j) {
                this.dT1.assignTimes(this.kappa(t) * dt / 2.0, this.N);
                this.dN1.assignLinComb(-this.kappa(t) * dt / 2.0, this.T, this.tau(t) * dt / 2.0, this.B);
                this.dB1.assignTimes(-this.tau(t) * dt / 2.0, this.N);
                this.dT2.assignSumTimes(this.N, this.dN1, this.kappa(t += dt / 2.0) * dt);
                this.dN2.assignSumTimes(this.T, this.dT1, -this.kappa(t) * dt);
                this.Vvv.assignSumTimes(this.B, this.dB1, this.tau(t) * dt);
                this.dN2.assignPlus(this.Vvv);
                this.dB2.assignSumTimes(this.N, this.dN1, -this.tau(t) * dt);
                this.dT3.assignLinComb(this.kappa(t) * dt, this.N, this.kappa(t) * dt / 2.0, this.dN2);
                this.dN3.assignLinComb(-this.kappa(t) * dt, this.T, -this.kappa(t) * dt / 2.0, this.dT2);
                this.Vvv.assignLinComb(this.tau(t) * dt, this.B, this.tau(t) * dt / 2.0, this.dB2);
                this.dN3.assignPlus(this.Vvv);
                this.dB3.assignLinComb(-this.tau(t) * dt, this.N, -this.tau(t) * dt / 2.0, this.dN2);
                this.dT4.assignSumTimes(this.N, this.dN3, this.kappa(t += dt / 2.0) * dt / 2.0);
                this.dN4.assignSumTimes(this.T, this.dT3, -this.kappa(t) * dt / 2.0);
                this.Vvv.assignSumTimes(this.B, this.dB3, this.tau(t) * dt / 2.0);
                this.dN4.assignPlus(this.Vvv);
                this.dB4.assignSumTimes(this.N, this.dN3, -this.tau(t) * dt / 2.0);
                this.P = this.P.plus(this.T.times(dt * (double)j * (double)j / 3.0));
                this.Vvv.assignSumTimes(this.dT1, this.dT2, this.dT3, this.dT4, 0.3333333333333333);
                this.T = this.T.plus(this.Vvv);
                this.Vvv.assignSumTimes(this.dN1, this.dN2, this.dN3, this.dN4, 0.3333333333333333);
                this.N = this.N.plus(this.Vvv);
                this.Vvv.assignSumTimes(this.dB1, this.dB2, this.dB3, this.dB4, 0.3333333333333333);
                this.B = this.B.plus(this.Vvv);
            }
            this.P.assignLinComb(1.0, dt / 3.0, this.T);
            ++i;
        }
        return new Vector3D[]{this.P, this.T, this.N, this.B};
    }

    private void createFrenetArray() {
        int i;
        int tr = this.tResolution.getValue();
        double dt = (this.tmax.getValue() - this.tmin.getValue()) / (double)tr;
        double t = this.tmin.getValue();
        this.helperFrame = new Vector3D[4 * (tr + 1)];
        this.pointSet = new Vector3D[tr + 1];
        this.helperFrame[0] = new Vector3D(0.0, 0.0, 0.0);
        this.helperFrame[1] = new Vector3D(1.0, 0.0, 0.0);
        this.helperFrame[2] = new Vector3D(0.0, 1.0, 0.0);
        this.helperFrame[3] = new Vector3D(0.0, 0.0, 1.0);
        this.pointSet[0] = new Vector3D(this.helperFrame[0]);
        for (i = 0; i < tr; ++i) {
            int j;
            for (j = 0; j < 4; ++j) {
                this.initialFrenet[j] = this.helperFrame[j + 4 * i];
            }
            this.repere = this.frenetODEstep4(t, t + dt, this.initialFrenet, 32);
            for (j = 0; j < 4; ++j) {
                this.helperFrame[j + 4 * (i + 1)] = new Vector3D(this.repere[j]);
            }
            this.pointSet[i + 1] = this.helperFrame[4 * (i + 1)];
            t += dt;
        }
        this.startPoint = this.getCenterOfPoints(this.pointSet, tr + 1);
        this.startPoint.x = -this.startPoint.x;
        this.startPoint.y = -this.startPoint.y;
        this.startPoint.z = -this.startPoint.z;
        for (i = 0; i <= tr; ++i) {
            this.helperFrame[4 * i].assignPlus(this.startPoint);
        }
    }

    @Override
    public Vector3D[] makeRepereMobile(double t) {
        int i = 0;
        double tStart = 0.0;
        if (this.needsNewArray) {
            this.createFrenetArray();
            this.needsNewArray = false;
        }
        i = (int)Math.round((double)this.tResolution.getValue() * (t - this.tmin.getValue()) / (this.tmax.getValue() - this.tmin.getValue()));
        tStart = this.tmin.getValue() + (double)i * (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
        for (int j = 0; j < 4; ++j) {
            this.initialFrenet[j] = this.helperFrame[j + 4 * i];
        }
        this.repere = this.frenetODEstep4(tStart, t, this.initialFrenet, 16);
        return this.repere;
    }

    @Override
    protected Vector3D value(double t) {
        int i = 0;
        double tStart = 0.0;
        if (this.needsNewArray) {
            this.createFrenetArray();
            this.needsNewArray = false;
        }
        i = (int)Math.round((double)this.tResolution.getValue() * (t - this.tmin.getValue()) / (this.tmax.getValue() - this.tmin.getValue()));
        tStart = this.tmin.getValue() + (double)i * (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
        for (int j = 0; j < 4; ++j) {
            this.initialFrenet[j] = this.helperFrame[j + 4 * i];
        }
        Vector3D point = this.frenetODEstep4(tStart, t, this.initialFrenet, 16)[0];
        return point;
    }

    @Override
    public UserExhibit.Support getUserExhibitSupport() {
        return this.userExhibitSupport;
    }
}

