/*
 * Decompiled with CFR 0.152.
 */
package vmm.spacecurve.parametric;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.Random;
import vmm.actions.ActionList;
import vmm.actions.ToggleAction;
import vmm.core.I18n;
import vmm.core.RealParamAnimateable;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.DotCloudSurface;
import vmm.core3D.Vector3D;
import vmm.spacecurve.parametric.SpaceCurveParametric;

public class TorusKnot
extends SpaceCurveParametric {
    RealParamAnimateable aa = new RealParamAnimateable("vmm.spacecurve.parametric.TorusKnot.aa", 6.25, 6.25, 6.25);
    RealParamAnimateable bb = new RealParamAnimateable("vmm.spacecurve.parametric.TorusKnot.bb", 3.0, 2.0, 3.5);
    RealParamAnimateable cc = new RealParamAnimateable("vmm.spacecurve.parametric.TorusKnot.cc", 3.0, 5.0, 2.0);
    RealParamAnimateable dd = new RealParamAnimateable("vmm.spacecurve.parametric.TorusKnot.dd", 5.0, 5.0, 5.0);
    RealParamAnimateable ee = new RealParamAnimateable("vmm.spacecurve.parametric.TorusKnot.ee", 2.0, 2.0, 2.0);

    public TorusKnot() {
        this.setDefaultViewpoint(new Vector3D(30.0, 0.0, 10.0));
        this.setDefaultWindow(-12.0, 12.0, -10.0, 10.0);
        this.tResolution.setValueAndDefault(300);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefaultFromString("2 * pi");
        this.addParameter(this.ee);
        this.addParameter(this.dd);
        this.addParameter(this.cc);
        this.addParameter(this.bb);
        this.addParameter(this.aa);
        this.tubeSize.setValueAndDefault(1.0);
    }

    @Override
    protected Vector3D value(double t) {
        double a = this.aa.getValue();
        double b = this.bb.getValue();
        double c = this.cc.getValue();
        double d = this.dd.getValue();
        double e = this.ee.getValue();
        d = (int)d;
        e = (int)e;
        double x = (a + b * Math.cos(d * t)) * Math.cos(e * t);
        double y = (a + b * Math.cos(d * t)) * Math.sin(e * t);
        double z = c * Math.sin(d * t);
        return new Vector3D(x, y, z);
    }

    @Override
    public View getDefaultView() {
        TorusKnotView view = new TorusKnotView();
        view.setName("vmm.spacecurve.parametric.SpaceCurveParametric.view.ViewAsCurve");
        return view;
    }

    private class DotCloudTorus
    extends DotCloudSurface {
        private DotCloudTorus() {
        }

        @Override
        protected Vector3D makeRandomPixel(Random randomNumberGenerator) {
            double a = TorusKnot.this.aa.getValue();
            double b = TorusKnot.this.bb.getValue();
            double c = TorusKnot.this.cc.getValue();
            double u = randomNumberGenerator.nextDouble() * Math.PI * 2.0;
            double v = randomNumberGenerator.nextDouble() * Math.PI * 2.0;
            double x = (a + b * Math.cos(u)) * Math.cos(v);
            double y = (a + b * Math.cos(u)) * Math.sin(v);
            double z = c * Math.sin(u);
            return new Vector3D(x, y, z);
        }
    }

    public class TorusKnotView
    extends SpaceCurveParametric.SpaceCurveParametricView {
        @VMMSave
        private boolean showDotCloudTorus;
        private ToggleAction showCloudTorusOption = new ToggleAction(I18n.tr("vmm.spacecurve.parametric.TorusKnot.ShowCloudTorus")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TorusKnotView.this.setShowDotCloudTorus(this.getState());
            }
        };
        private DotCloudTorus cloudTorus;

        public void setShowDotCloudTorus(boolean show) {
            if (show != this.showDotCloudTorus) {
                this.showDotCloudTorus = show;
                this.showCloudTorusOption.setState(show);
                if (show) {
                    if (this.cloudTorus == null) {
                        this.cloudTorus = new DotCloudTorus();
                        this.cloudTorus.setColor(Color.blue);
                    }
                    this.addDecoration(this.cloudTorus);
                } else {
                    this.removeDecoration(this.cloudTorus);
                }
            }
        }

        @Override
        public ActionList getActions() {
            ActionList actions = super.getActions();
            actions.add(this.showCloudTorusOption);
            return actions;
        }

        public boolean getShowDotCloudTorus() {
            return this.showDotCloudTorus;
        }
    }
}

