/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import vmm.core.Parameter;
import vmm.core.UserExhibit;
import vmm.core.VariableParamAnimateable;
import vmm.planecurve.parametric.PlaneCurveParametric;

public class UserPlaneCurveParametricKappa
extends PlaneCurveParametric
implements UserExhibit {
    private UserExhibit.Support userExhibitSupport;
    private UserExhibit.FunctionInfo kappa;
    double[] helpArray = new double[513];
    boolean needsNewHelpArray;
    double DT;
    double Tstart;

    public UserPlaneCurveParametricKappa() {
        this.tmin.reset(-10.0);
        this.tmax.reset(10.0);
        this.tResolution.reset(257);
        this.userExhibitSupport = new UserExhibit.Support(this);
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("a", 1.0, 1.0, 1.0));
        this.userExhibitSupport.addFunctionParameter(new VariableParamAnimateable("b", 1.0, 0.5, 1.0));
        this.kappa = this.userExhibitSupport.addRealFunction("kappa", "b *(2+cos(a*t))", "t");
        this.setDefaultWindow(-2.0, 2.0, -2.0, 2.0);
        this.needsNewHelpArray = true;
        this.DT = (this.tmax.getValue() - this.tmin.getValue()) / (double)(this.helpArray.length - 1);
        this.Tstart = Math.max(Math.min(0.0, this.tmax.getValue()), this.tmin.getValue());
    }

    @Override
    public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
        super.parameterChanged(param, oldValue, newValue);
        this.needsNewHelpArray = true;
        this.Tstart = Math.max(Math.min(0.0, this.tmax.getValue()), this.tmin.getValue());
    }

    @Override
    public double xValue(double t) {
        long num = 2L * Math.round(2.0 + 4.0 * Math.abs(t - this.Tstart));
        double x = 0.0;
        double f = Math.cos(this.angle(this.Tstart));
        if (t - this.Tstart != 0.0) {
            x += f;
            double dt = (t - this.Tstart) / (double)num;
            int i = 1;
            while ((long)i < num) {
                f = Math.cos(this.angle(this.Tstart + (double)i * dt));
                x += 4.0 * f;
                f = Math.cos(this.angle(this.Tstart + (double)(i + 1) * dt));
                x += 2.0 * f;
                i += 2;
            }
            x = (x - f) * dt / 3.0;
        }
        return x;
    }

    @Override
    public double yValue(double t) {
        long num = 2L * Math.round(2.0 + 4.0 * Math.abs(t - this.Tstart));
        double y = 0.0;
        double f = Math.sin(this.angle(this.Tstart));
        if (t - this.Tstart != 0.0) {
            y += f;
            double dt = (t - this.Tstart) / (double)num;
            int i = 1;
            while ((long)i < num) {
                y += 4.0 * Math.sin(this.angle(this.Tstart + (double)i * dt));
                f = Math.sin(this.angle(this.Tstart + (double)(i + 1) * dt));
                y += 2.0 * f;
                i += 2;
            }
            y = (y - f) * dt / 3.0;
        }
        return y;
    }

    @Override
    public double xDerivativeValue(double t) {
        return Math.cos(this.angle(t));
    }

    @Override
    public double yDerivativeValue(double t) {
        return Math.sin(this.angle(t));
    }

    @Override
    public double x2ndDerivativeValue(double t) {
        return -Math.sin(this.angle(t)) * this.kappa.realFunctionValue(t);
    }

    @Override
    public double y2ndDerivativeValue(double t) {
        return Math.cos(this.angle(t)) * this.kappa.realFunctionValue(t);
    }

    @Override
    public UserExhibit.Support getUserExhibitSupport() {
        return this.userExhibitSupport;
    }

    private void recomputeHelpArray() {
        int num = 4;
        double tm = this.tmin.getValue();
        this.DT = (this.tmax.getValue() - tm) / (double)(this.helpArray.length - 1);
        double f = 0.0;
        double dt = this.DT / (double)num;
        this.helpArray[0] = 0.0;
        for (int j = 1; j < this.helpArray.length; ++j) {
            double w = this.kappa.realFunctionValue(tm);
            for (int i = 1; i < num; i += 2) {
                w += 4.0 * this.kappa.realFunctionValue(tm + (double)i * dt);
                f = this.kappa.realFunctionValue(tm + (double)(i + 1) * dt);
                w += 2.0 * f;
            }
            w = (w - f) * dt / 3.0;
            tm += this.DT;
            this.helpArray[j] = this.helpArray[j - 1] + w;
        }
        this.needsNewHelpArray = false;
        double an = this.angle(this.Tstart);
        for (int j = 0; j < this.helpArray.length; ++j) {
            this.helpArray[j] = this.helpArray[j] - an;
        }
    }

    private double angle(double t) {
        if (this.needsNewHelpArray) {
            this.recomputeHelpArray();
        }
        double w = 0.0;
        double y = 0.0;
        int k = (int)Math.max(0L, Math.min(Math.round((t - this.tmin.getValue()) / this.DT), (long)(this.helpArray.length - 1)));
        double ta = this.tmin.getValue() + (double)k * this.DT;
        if (t == ta) {
            w = this.helpArray[k];
        } else {
            int num = (int)(2L * Math.round(2.0 + 8.0 * Math.abs(t - ta)));
            double dt = (t - ta) / (double)num;
            w += this.kappa.realFunctionValue(ta);
            for (int i = 1; i < num; i += 2) {
                w += 4.0 * this.kappa.realFunctionValue(ta + (double)i * dt);
                y = this.kappa.realFunctionValue(ta + (double)(i + 1) * dt);
                w += 2.0 * y;
            }
            w = this.helpArray[k] + (w - y) * dt / 3.0;
        }
        return w;
    }
}

