/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import vmm.core.LinearAlgebra;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Lemniskate
extends DecoratedCurve {
    private RealParamAnimateable bb;
    private int pointCount;
    double a;
    double b;
    double xa;
    double ya;
    double xb;
    double yb;
    double corn1x;
    double corn1y;
    double foc1x;
    double foc2x;
    double corn2x;
    double corn2y;
    double rotx;
    double roty;
    double tx;
    double ty;
    double nn;
    double ex;
    double ey;
    double dt;
    Point2D Rot = new Point2D.Double();

    public Lemniskate() {
        this.bb = new RealParamAnimateable("vmm.planecurve.parametric.Lemniskate.bb", "pi/4", "0.0", "1.5707");
        this.addParameter(this.bb);
        this.tmin.setValueAndDefault(0.0);
        this.tmax.setValueAndDefault(Math.PI * 2);
        this.setDefaultWindow(-3.0, 3.0, -3.0, 3.0);
        this.tResolution.setValueAndDefault(600);
        this.pointCount = 12000;
        this.randomSquare = this.fillRandomSquare(this.pointCount);
        this.movingSquare = this.initializeMovingSquare(this.pointCount);
    }

    private static double sinsq(double t) {
        return 1.0 + Math.sin(t) * Math.sin(t);
    }

    @Override
    public double xValue(double t) {
        if (t < 0.1) {
            this.b = this.bb.getValue();
            if (this.b < 0.0 || this.b > 1.5707963267948966) {
                this.bb.setValue(Math.max(0.0, Math.min(this.b, 1.5707963267948966)));
                this.b = this.bb.getValue();
            }
            this.a = 3.0 * Math.cos((this.b - 0.39269908169872414) * 4.0 / 3.0);
            this.b = Math.tan(this.b);
        }
        return this.a * (Math.cos(t) / Lemniskate.sinsq(t) + (1.0 - this.b) * (2.0 / Lemniskate.sinsq(t) - 1.0) / Math.sqrt(2.0));
    }

    @Override
    public double yValue(double t) {
        return this.a * (Math.sin(t) * Math.cos(t) / Lemniskate.sinsq(t) + (1.0 - this.b) * Math.sqrt(2.0) * Math.sin(t) / Lemniskate.sinsq(t));
    }

    @Override
    public View getDefaultView() {
        DecoratedCurve.MMOView view = (DecoratedCurve.MMOView)super.getDefaultView();
        view.simplifyActionMenu = false;
        view.setUseCloud(false);
        return view;
    }

    private void abbreviations(double t) {
        this.foc1x = this.a / Math.sqrt(2.0);
        this.foc2x = -this.foc1x;
        this.xa = this.xValue(t);
        this.ya = this.yValue(t);
        this.corn1x = this.a * (Math.cos(t) / Lemniskate.sinsq(t) - Math.sqrt(2.0) * Math.sin(t) * Math.sin(t) / Lemniskate.sinsq(t) + Math.sqrt(0.5));
        this.corn2x = this.a * (Math.cos(t) / Lemniskate.sinsq(t) + Math.sqrt(2.0) * Math.sin(t) * Math.sin(t) / Lemniskate.sinsq(t) - Math.sqrt(0.5));
        this.corn1y = this.a * (Math.cos(t) + Math.sqrt(2.0)) * Math.sin(t) / Lemniskate.sinsq(t);
        this.corn2y = this.a * (Math.cos(t) - Math.sqrt(2.0)) * Math.sin(t) / Lemniskate.sinsq(t);
        this.ex = this.corn2x - this.corn1x;
        this.ey = this.corn2y - this.corn1y;
        this.nn = Math.sqrt(this.ex * this.ex + this.ey * this.ey);
        this.ex /= this.nn;
        this.ey /= this.nn;
        this.Rot = LinearAlgebra.intersectTwoLines(this.foc1x, 0.0, this.corn1x, this.corn1y, this.foc2x, 0.0, this.corn2x, this.corn2y);
        this.rotx = this.Rot.getX();
        this.roty = this.Rot.getY();
        this.tx = -this.roty + this.ya;
        this.ty = this.rotx - this.xa;
        this.dt = (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
    }

    @Override
    protected void drawNeededStuff(Graphics2D g, View view, Transform limits, double t) {
        double rc = 0.03;
        DecoratedCurve.MMOView myView = (DecoratedCurve.MMOView)view;
        Color saveColor = g.getColor();
        this.abbreviations(t);
        g.setColor(Color.red);
        myView.setStrokeSizeMultiplier(2);
        g.draw(new Ellipse2D.Double(this.foc1x - rc, -rc, 2.0 * rc, 2.0 * rc));
        g.draw(new Ellipse2D.Double(this.foc2x - rc, -rc, 2.0 * rc, 2.0 * rc));
        g.draw(new Ellipse2D.Double(this.corn1x - rc, this.corn1y - rc, 2.0 * rc, 2.0 * rc));
        g.draw(new Ellipse2D.Double(this.corn2x - rc, this.corn2y - rc, 2.0 * rc, 2.0 * rc));
        g.draw(new Line2D.Double(this.corn1x, this.corn1y, this.foc1x, 0.0));
        g.draw(new Line2D.Double(this.corn2x, this.corn2y, this.foc2x, 0.0));
        g.draw(new Line2D.Double(this.corn1x, this.corn1y, this.corn2x, this.corn2y));
        g.setColor(Color.green);
        g.draw(new Line2D.Double(this.corn2x, this.corn2y, this.xa, this.ya));
        g.draw(new Ellipse2D.Double(this.xa - rc, this.ya - rc, 2.0 * rc, 2.0 * rc));
        if (myView.getUseCloud()) {
            myView.setStrokeSizeMultiplier(1);
            g.draw(new Line2D.Double(this.corn1x, this.corn1y, this.rotx, this.roty));
            g.draw(new Line2D.Double(this.rotx, this.roty, this.corn2x, this.corn2y));
            g.setColor(Color.red);
            myView.setStrokeSizeMultiplier(2);
            g.draw(new Line2D.Double(this.corn1x, this.corn1y, this.foc1x, 0.0));
            g.draw(new Line2D.Double(this.corn2x, this.corn2y, this.foc2x, 0.0));
            g.setColor(Color.blue);
            myView.setStrokeSizeMultiplier(1);
            g.draw(new Line2D.Double(this.rotx, this.roty, this.xa, this.ya));
            g.draw(new Line2D.Double(this.xa + this.tx, this.ya + this.ty, this.xa - this.tx, this.ya - this.ty));
            g.draw(new Ellipse2D.Double(this.rotx - rc, this.roty - rc, 2.0 * rc, 2.0 * rc));
            this.abbreviations(t - this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, (this.corn1x + this.corn2x) / 2.0, (this.corn1y + this.corn2y) / 2.0, this.ex, this.ey, 3.0);
            myView.drawPixels(this.movingSquare, 0, this.pointCount);
            this.abbreviations(t + this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, (this.corn1x + this.corn2x) / 2.0, (this.corn1y + this.corn2y) / 2.0, this.ex, this.ey, 3.0);
            myView.drawPixels(this.movingSquare, 0, this.pointCount);
        }
        g.setColor(saveColor);
    }
}

