/*
 * Decompiled with CFR 0.152.
 */
package vmm.planecurve.parametric;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import vmm.core.RealParamAnimateable;
import vmm.core.Transform;
import vmm.core.View;
import vmm.planecurve.parametric.DecoratedCurve;

public class Conchoid
extends DecoratedCurve {
    private RealParamAnimateable aa;
    private RealParamAnimateable bb;
    double AA;
    double BB;
    private int pointCount;
    double xa;
    double ya;
    double xb;
    double yb;
    double tx;
    double ty;
    double m;
    double rotx;
    double roty;
    double nn;
    double dt;
    double ex;
    double ey;

    public Conchoid() {
        this.tResolution.setValueAndDefault(400);
        this.aa = new RealParamAnimateable("vmm.planecurve.parametric.Conchoid.aa", 2.0, 0.0, 4.0);
        this.bb = new RealParamAnimateable("vmm.planecurve.parametric.Conchoid.bb", 1.0, 1.0, 1.0);
        this.addParameter(this.aa);
        this.addParameter(this.bb);
        this.tmin.setValueAndDefaultFromString("-pi/2 + 0.000001");
        this.tmax.setValueAndDefaultFromString("3*pi/2 - 0.000001");
        this.setDefaultWindow(-5.0, 5.0, -4.0, 5.0);
        this.pointCount = 12000;
        this.randomSquare = this.fillRandomSquare(this.pointCount);
        this.movingSquare = this.initializeMovingSquare(this.pointCount);
    }

    @Override
    public double xValue(double t) {
        this.AA = this.aa.getValue();
        this.BB = this.bb.getValue();
        double r = this.AA + this.BB / Math.cos(t);
        return r * Math.sin(t);
    }

    @Override
    public double yValue(double t) {
        double r = this.AA + this.BB / Math.cos(t);
        return r * Math.cos(t);
    }

    @Override
    public View getDefaultView() {
        DecoratedCurve.MMOView view = (DecoratedCurve.MMOView)super.getDefaultView();
        view.simplifyActionMenu = false;
        view.setUseCloud(false);
        return view;
    }

    private void abbreviations(double t) {
        this.xa = this.xValue(t);
        this.ya = this.yValue(t);
        this.m = this.xa / this.ya;
        this.rotx = this.BB * this.m;
        this.roty = -this.rotx * this.m;
        this.tx = -(this.roty - this.ya);
        this.ty = this.rotx - this.xa;
        this.ex = this.xa - this.rotx;
        this.ey = this.ya - this.BB;
        this.dt = (this.tmax.getValue() - this.tmin.getValue()) / (double)this.tResolution.getValue();
    }

    @Override
    protected void drawNeededStuff(Graphics2D g, View view, Transform limits, double t) {
        DecoratedCurve.MMOView myView = (DecoratedCurve.MMOView)view;
        this.setWantedColor(Color.green);
        this.setStrokeSize(3);
        this.abbreviations(t);
        myView.setStrokeSizeMultiplier(4);
        g.setColor(Color.green);
        g.draw(new Line2D.Double(this.xa, this.ya, this.BB * this.m, this.BB));
        myView.setStrokeSizeMultiplier(1);
        g.setColor(Color.red);
        g.draw(new Line2D.Double(-20.0, this.BB, 20.0, this.BB));
        g.setColor(Color.blue);
        if (this.ya > this.BB) {
            g.draw(new Line2D.Double(0.0, 0.0, this.BB * this.m, this.BB));
        } else if (this.ya > 0.0) {
            g.draw(new Line2D.Double(0.0, 0.0, this.xa, this.ya));
        }
        if (myView.getUseCloud()) {
            g.draw(new Line2D.Double(this.rotx, this.roty, this.xa, this.ya));
            g.draw(new Line2D.Double(this.xa + this.tx, this.ya + this.ty, this.xa - this.tx, this.ya - this.ty));
            g.draw(new Ellipse2D.Double(this.rotx - 0.03, this.roty - 0.03, 0.06, 0.06));
            g.setColor(Color.green);
            g.draw(new Line2D.Double(0.0, 0.0, this.rotx, this.roty));
            g.draw(new Line2D.Double(this.rotx, this.roty, this.rotx, this.BB));
            g.setColor(Color.blue);
            this.abbreviations(t - this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 3.0 * this.BB);
            myView.drawPixels(this.movingSquare, 0, this.pointCount);
            this.abbreviations(t + this.dt);
            this.movingSquare = this.moveSquare(this.pointCount, this.xa, this.ya, this.ex, this.ey, 3.0 * this.BB);
            myView.drawPixels(this.movingSquare, 0, this.pointCount);
        }
    }
}

