/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode.firstorder2D;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import vmm.core.BasicMouseTask2D;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.Util;
import vmm.core.View;
import vmm.ode.ODE_2D;

public abstract class ODE1stOrder2DNonAutonomous
extends ODE_2D {
    public ODE1stOrder2DNonAutonomous() {
        super(true, false, "t", "x", "y");
        this.initialDataDefault = new double[]{0.0, 1.0, 1.0};
    }

    protected abstract double x1Prime(double var1, double var3, double var5);

    protected abstract double x2Prime(double var1, double var3, double var5);

    @Override
    protected final double vectorField_x(double x, double y, double t) {
        return this.x1Prime(x, y, t);
    }

    @Override
    protected final double vectorField_y(double x, double y, double t) {
        return this.x2Prime(x, y, t);
    }

    @Override
    protected void nextEulerPoint(double[] pointData, double dt) {
        double t = pointData[0];
        double x1 = pointData[1];
        double x2 = pointData[2];
        double dx1 = dt * this.x1Prime(x1, x2, t);
        double dx2 = dt * this.x2Prime(x1, x2, t);
        pointData[0] = t + dt;
        pointData[1] = x1 + dx1;
        pointData[2] = x2 + dx2;
    }

    @Override
    protected void nextRungeKuttaPoint(double[] pointData, double dt) {
        double t = pointData[0];
        double x1 = pointData[1];
        double x2 = pointData[2];
        double h1 = dt * this.x1Prime(x1, x2, t);
        double k1 = dt * this.x2Prime(x1, x2, t);
        double h2 = dt * this.x1Prime(x1 + h1 / 2.0, x2 + k1 / 2.0, t + dt / 2.0);
        double k2 = dt * this.x2Prime(x1 + h1 / 2.0, x2 + k1 / 2.0, t + dt / 2.0);
        double h3 = dt * this.x1Prime(x1 + h2 / 2.0, x2 + k2 / 2.0, t + dt / 2.0);
        double k3 = dt * this.x2Prime(x1 + h2 / 2.0, x2 + k2 / 2.0, t + dt / 2.0);
        double h4 = dt * this.x1Prime(x1 + h3, x2 + k3, t + dt);
        double k4 = dt * this.x2Prime(x1 + h3, x2 + k3, t + dt);
        double dx1 = h1 / 6.0 + h2 / 3.0 + h3 / 3.0 + h4 / 6.0;
        double dx2 = k1 / 6.0 + k2 / 3.0 + k3 / 3.0 + k4 / 6.0;
        pointData[0] = t + dt;
        pointData[1] = x1 + dx1;
        pointData[2] = x2 + dx2;
    }

    @Override
    protected MouseTask makeDefaultMouseTask(ODE_2D.ODEView view) {
        return new StartOrbit();
    }

    private class StartOrbit
    extends BasicMouseTask2D {
        private StartOrbit() {
        }

        @Override
        public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
            if (evt.isAltDown()) {
                ODE_2D.ODEView odeView = (ODE_2D.ODEView)view;
                Point2D.Double pt = new Point2D.Double(evt.getX(), evt.getY());
                view.getTransform().viewportToWindow(pt);
                double time = odeView.getCurrentTimeFromControlPanel();
                odeView.startOrbitAtPoint(new double[]{time, ((Point2D)pt).getX(), ((Point2D)pt).getY()});
                return false;
            }
            return super.doMouseDown(evt, display, view, width, height);
        }

        @Override
        public String getStatusText() {
            if (Util.isMacOS()) {
                return I18n.tr("vmm.ode.firstorder2D.mouseTaskStatusText.mac");
            }
            return I18n.tr("vmm.ode.firstorder2D.mouseTaskStatusText");
        }
    }
}

