/*
 * Decompiled with CFR 0.152.
 */
package vmm.ode;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.actions.ToggleAction;
import vmm.core.Decoration;
import vmm.core.Display;
import vmm.core.Exhibit;
import vmm.core.I18n;
import vmm.core.MouseTask;
import vmm.core.SaveAndRestore;
import vmm.core.TimerAnimation;
import vmm.core.Transform;
import vmm.core.Util;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.BasicMouseTask3D;
import vmm.core3D.Exhibit3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.ode.OrbitPoints3D;

public abstract class ODE_3D
extends Exhibit3D {
    public static final int ORBIT_TYPE_RUNGE_KUTTA = 0;
    public static final int ORBIT_TYPE_BOTH = 1;
    public static final int ORBIT_TYPE_EULER = 2;
    private static final int DF_SPACING = 30;
    private static final Color DIRECTION_FIELD_COLOR = Color.GRAY;
    private static final Color RUNGE_KUTTA_ORBIT_COLOR = Color.RED;
    private static final Color EULER_ORBIT_COLOR = Color.GREEN;
    private static final Color OLD_RUNGE_KUTTA_ORBIT_COLOR = new Color(150, 80, 80);
    private static final Color OLD_EULER_ORBIT_COLOR = new Color(80, 150, 80);
    private static final Color RUNGE_KUTTA_PROJECTED_ORBIT_X_COLOR = Color.CYAN;
    private static final Color RUNGE_KUTTA_PROJECTED_ORBIT_Y_COLOR = Color.MAGENTA;
    private static final Color RUNGE_KUTTA_PROJECTED_ORBIT_Z_COLOR = new Color(220, 220, 0);
    private static final Color EULER_PROJECTED_ORBIT_X_COLOR = new Color(100, 150, 150);
    private static final Color EULER_PROJECTED_ORBIT_Y_COLOR = new Color(150, 100, 150);
    private static final Color EULER_PROJECTED_ORBIT_Z_COLOR = new Color(150, 150, 80);
    protected final boolean isAutonomous;
    protected boolean showAxes = false;
    protected boolean anaglyphIsDefault = false;
    protected boolean addOrbitTypesToControlPanel = false;
    protected boolean addAnimateCheckBoxontrolPanel = true;
    protected boolean addLinesCheckBoxontrolPanel = true;
    protected final boolean canShowVectorField;
    protected final String[] inputLabelNames;
    protected double dtDefault = 0.05;
    protected double timeSpanDefault = 10.0;
    protected double[] initialDataDefault = null;

    protected abstract void nextEulerPoint(double[] var1, double var2);

    protected abstract void nextRungeKuttaPoint(double[] var1, double var2);

    protected Vector3D extractPointFromData(double[] pointData) {
        if (this.isAutonomous) {
            return new Vector3D(pointData[0], pointData[1], pointData[2]);
        }
        return new Vector3D(pointData[1], pointData[2], pointData[3]);
    }

    protected double vectorField_x(double x, double y, double z, double t) {
        return 0.0;
    }

    protected double vectorField_y(double x, double y, double z, double t) {
        return 0.0;
    }

    protected MouseTask makeDefaultMouseTask(ODEView view) {
        return new BasicMouseTask3D();
    }

    protected ODE_3D(boolean canShowVectorField, boolean isAutonomous, String ... inputLabelName) {
        this.setDefaultBackground(Color.BLACK);
        this.setDefaultViewpoint(new Vector3D(10.0, 10.0, 5.0));
        this.canShowVectorField = canShowVectorField;
        this.isAutonomous = isAutonomous;
        this.inputLabelNames = inputLabelName;
    }

    @Override
    public TimerAnimation getCreateAnimation(View view) {
        if (view instanceof ODEView) {
            return ((ODEView)view).makeCreateAnimation();
        }
        return null;
    }

    protected Vector3D screenPointTo3DPoint(View3D view, int x, int y) {
        if (view.getViewStyle() == 3 || view.getViewStyle() == 2) {
            Rectangle r1 = view.stereographLeftEyeRect();
            Rectangle r2 = view.stereographRightEyeRect();
            if (r1.contains(x, y)) {
                x -= r1.x;
                y -= r1.y;
            } else if (r2.contains(x, y)) {
                x -= r2.x;
                y -= r2.y;
            } else {
                return null;
            }
        }
        Point2D.Double p = new Point2D.Double(x, y);
        view.getTransform3D().viewportToWindow(p);
        Vector3D v = new Vector3D(((Point2D)p).getX(), 0.0, ((Point2D)p).getY());
        Vector3D xDir = view.getTransform3D().getImagePlaneXDirection();
        Vector3D zDir = view.getTransform3D().getImagePlaneYDirection();
        Vector3D yDir = view.getTransform3D().getViewDirection().negated();
        Vector3D v2 = new Vector3D();
        v2.x = v.x * xDir.x + v.y * yDir.x + v.z * zDir.x;
        v2.y = v.x * xDir.y + v.y * yDir.y + v.z * zDir.y;
        v2.z = v.x * xDir.z + v.y * yDir.z + v.z * zDir.z;
        return v2;
    }

    @Override
    protected void doDraw(Graphics2D g, View view, Transform transform) {
        if (!this.canShowVectorField) {
            return;
        }
        if (!(view instanceof ODEView) || ((ODEView)view).showDirectionField) {
            this.drawDirectionField(view, transform);
        }
    }

    private void drawDirectionField(View view, Transform transform) {
    }

    @Override
    public View getDefaultView() {
        return new ODEView();
    }

    private class ControlPanel
    extends JPanel {
        ODEView owner;
        JTextField[] icInputs;
        JTextField dtInput;
        JTextField timeSpanInput;
        JButton startOrbitButton;

        ControlPanel(ODEView view) {
            JCheckBox cb;
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
            JPanel componentPanel = new JPanel();
            componentPanel.setLayout(new GridLayout(0, 1));
            this.add(componentPanel);
            this.owner = view;
            Font font = new Font("SansSerif", 1, 10);
            Font inputFont = new Font("SansSerif", 0, 10);
            this.startOrbitButton = new JButton(I18n.tr("vmm.ode.command.StartOrbitAt"));
            this.startOrbitButton.setFont(font);
            componentPanel.add(this.startOrbitButton);
            this.icInputs = new JTextField[ODE_3D.this.inputLabelNames.length];
            for (int i = 0; i < ODE_3D.this.inputLabelNames.length; ++i) {
                this.icInputs[i] = new JTextField(6);
                this.icInputs[i].setFont(inputFont);
                JPanel p = new JPanel();
                JLabel lbl = new JLabel(ODE_3D.this.inputLabelNames[i] + " =");
                lbl.setFont(font);
                p.add(lbl);
                p.add(this.icInputs[i]);
                componentPanel.add(p);
            }
            this.dtInput = new JTextField("" + ODE_3D.this.dtDefault, 4);
            this.timeSpanInput = new JTextField("" + ODE_3D.this.timeSpanDefault, 3);
            this.dtInput.setFont(inputFont);
            this.timeSpanInput.setFont(inputFont);
            JPanel p = new JPanel();
            JLabel lbl = new JLabel(I18n.tr("vmm.ode.StepSize") + "=");
            lbl.setFont(font);
            p.add(lbl);
            p.add(this.dtInput);
            componentPanel.add(p);
            p = new JPanel();
            lbl = new JLabel(I18n.tr("vmm.ode.TimeSpan") + "=");
            lbl.setFont(font);
            p.add(lbl);
            p.add(this.timeSpanInput);
            componentPanel.add(p);
            componentPanel.add(Box.createVerticalStrut(1));
            JButton b = new JButton(view.continueOrbitAction);
            b.setFont(font);
            componentPanel.add(b);
            b = new JButton(view.eraseOrbitsAction);
            b.setFont(font);
            componentPanel.add(b);
            if (ODE_3D.this.addAnimateCheckBoxontrolPanel) {
                cb = this.owner.animateDrawingToggle.createCheckBox();
                cb.setFont(font);
                cb.setText(I18n.tr("vmm.ode.command.AnimateDrawing.short"));
                componentPanel.add(cb);
            }
            if (ODE_3D.this.addLinesCheckBoxontrolPanel) {
                cb = this.owner.connectDotsToggle.createCheckBox();
                cb.setFont(font);
                cb.setText(I18n.tr("vmm.ode.command.ConnectDotsOnOrbit.short"));
                componentPanel.add(cb);
            }
            if (ODE_3D.this.addOrbitTypesToControlPanel) {
                JRadioButton[] radioButtons;
                for (JRadioButton rb : radioButtons = view.orbitTypeSelect.createRadioButtons()) {
                    rb.setFont(font);
                    componentPanel.add(rb);
                }
            }
            this.startOrbitButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    double timeSpan;
                    double dt;
                    ControlPanel.this.owner.getDisplay().stopAnimation();
                    double[] ic = new double[ControlPanel.this.icInputs.length];
                    for (int i = 0; i < ControlPanel.this.icInputs.length; ++i) {
                        try {
                            ic[i] = Double.parseDouble(ControlPanel.this.icInputs[i].getText());
                            continue;
                        }
                        catch (NumberFormatException e) {
                            JOptionPane.showMessageDialog(ControlPanel.this.owner.getDisplay(), I18n.tr("vmm.ode.error.BadNumberInput", ODE_3D.this.inputLabelNames[i]));
                            return;
                        }
                    }
                    try {
                        dt = Double.parseDouble(ControlPanel.this.dtInput.getText());
                        if (dt <= 0.0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ControlPanel.this.owner.getDisplay(), I18n.tr("vmm.ode.error.BadPositiveNumberInput", "dt"));
                        return;
                    }
                    try {
                        timeSpan = Double.parseDouble(ControlPanel.this.timeSpanInput.getText());
                        if (timeSpan <= 0.0) {
                            throw new NumberFormatException();
                        }
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(ControlPanel.this.owner.getDisplay(), I18n.tr("vmm.ode.error.BadPositiveNumberInput", I18n.tr("vmm.ode.TimeSpan")));
                        return;
                    }
                    ControlPanel.this.owner.startOrbitAtPoint(ic, dt, timeSpan);
                }
            });
        }

        void resetStartPointInputText(double[] ic) {
            for (int i = 0; i < this.icInputs.length; ++i) {
                try {
                    if (Math.abs(ic[i] - Double.parseDouble(this.icInputs[i].getText())) < 5.0E-10) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String str = String.format("%.4g", ic[i]);
                this.icInputs[i].setText(str);
            }
        }
    }

    private class ExtendOrbitAnimation
    extends TimerAnimation {
        ODEView view;
        Orbit orbit;
        int finalNumberOfPoints;

        ExtendOrbitAnimation(ODEView view, Orbit orbit, int numberOfPointsToAdd) {
            super(numberOfPointsToAdd, 10);
            this.view = view;
            this.orbit = orbit;
            this.finalNumberOfPoints = orbit.getPointCount() + numberOfPointsToAdd;
            if (orbit.isCurrentOrbit && view.projectedOrbitView != null) {
                view.projectedOrbitView.setMaxPoints(orbit.getPointCount() + numberOfPointsToAdd + 1);
            }
        }

        @Override
        protected void drawFrame() {
            if (!this.view.getAnimateDrawing()) {
                this.orbit.setPointCount(this.finalNumberOfPoints);
                this.cancel();
                return;
            }
            boolean nextPoint = this.orbit.addNextPoint();
            if (!nextPoint) {
                this.cancel();
            }
            if (ODE_3D.this.canShowVectorField && !ODE_3D.this.isAutonomous) {
                this.view.forceRedraw();
            }
        }

        @Override
        protected void animationStarting() {
            if (ODE_3D.this.canShowVectorField && !ODE_3D.this.isAutonomous) {
                this.view.setShowDirectionField(true);
            }
        }

        @Override
        protected void animationEnding() {
            this.orbit.forceRedraw();
            if (ODE_3D.this.canShowVectorField && !ODE_3D.this.isAutonomous) {
                this.view.setShowDirectionField(false);
            }
        }
    }

    private class Orbit
    extends Decoration {
        double[] initialData;
        double[] currentEulerData;
        double[] currentRungeKuttaData;
        OrbitPoints3D eulerPoints;
        OrbitPoints3D rungeKuttaPoints;
        ODEView view;
        boolean isCurrentOrbit;
        int orbitType;
        double dt;
        int pointCount;

        Orbit(ODEView view, double[] initialData, int orbitType, double dt) {
            this.view = view;
            this.initialData = initialData;
            this.orbitType = orbitType;
            this.dt = dt;
            this.eulerPoints = new OrbitPoints3D();
            this.rungeKuttaPoints = new OrbitPoints3D();
            this.eulerPoints.setColor(EULER_ORBIT_COLOR);
            this.eulerPoints.setStyle(1);
            this.rungeKuttaPoints.setColor(RUNGE_KUTTA_ORBIT_COLOR);
            this.rungeKuttaPoints.setStyle(1);
            Vector3D startPoint = ODE_3D.this.extractPointFromData(initialData);
            this.eulerPoints.addPoint(startPoint);
            this.rungeKuttaPoints.addPoint(startPoint);
            this.currentEulerData = orbitType == 0 ? null : (double[])initialData.clone();
            this.currentRungeKuttaData = orbitType == 2 ? null : (double[])initialData.clone();
            this.pointCount = 1;
        }

        void setStyle(int style) {
            this.eulerPoints.setStyle(style);
            this.rungeKuttaPoints.setStyle(style);
            this.fireDecorationChangeEvent();
        }

        int getOrbitType() {
            return this.orbitType;
        }

        OrbitPoints3D getEulerPoints() {
            return this.eulerPoints;
        }

        OrbitPoints3D getRungeKuttaPoints() {
            return this.rungeKuttaPoints;
        }

        int getPointCount() {
            return this.pointCount;
        }

        void setPointCount(int ct) {
            this.pointCount = ct;
            if (this.isCurrentOrbit && this.view.projectedOrbitView != null) {
                this.view.projectedOrbitView.setMaxPoints(this.pointCount);
            }
            this.forceRedraw();
        }

        void removePoints() {
            this.eulerPoints.clear();
            this.rungeKuttaPoints.clear();
            Vector3D startPoint = ODE_3D.this.extractPointFromData(this.initialData);
            this.eulerPoints.addPoint(startPoint);
            this.rungeKuttaPoints.addPoint(startPoint);
            this.currentEulerData = this.orbitType == 0 ? null : (double[])this.initialData.clone();
            this.currentRungeKuttaData = this.orbitType == 2 ? null : (double[])this.initialData.clone();
            this.pointCount = 1;
            this.forceRedraw();
        }

        Vector3D getEulerPoint(int i) {
            if (i >= this.eulerPoints.getPointCount()) {
                return null;
            }
            return this.eulerPoints.getPoint(i);
        }

        Vector3D getRungeKuttaPoint(int i) {
            if (i >= this.rungeKuttaPoints.getPointCount()) {
                return null;
            }
            return this.rungeKuttaPoints.getPoint(i);
        }

        void setOrbitType(int type) {
            this.orbitType = type;
            this.forceRedraw();
        }

        void setIsCurrentOrbit(boolean b) {
            if (this.isCurrentOrbit && this.view.projectedOrbitView != null) {
                this.view.projectedOrbitView.clear();
            }
            this.isCurrentOrbit = b;
            this.eulerPoints.setColor(this.isCurrentOrbit ? EULER_ORBIT_COLOR : OLD_EULER_ORBIT_COLOR);
            this.rungeKuttaPoints.setColor(this.isCurrentOrbit ? RUNGE_KUTTA_ORBIT_COLOR : OLD_RUNGE_KUTTA_ORBIT_COLOR);
            if (this.isCurrentOrbit && this.view.projectedOrbitView != null) {
                this.view.projectedOrbitView.setMaxPoints(this.pointCount);
                this.view.projectedOrbitView.resetPointsFromOrbit(this);
            }
        }

        boolean addNextPoint() {
            Vector3D eulerPt = null;
            Vector3D rkPoint = null;
            if (this.orbitType >= 1 && this.currentEulerData != null) {
                ODE_3D.this.nextEulerPoint(this.currentEulerData, this.dt);
                for (double d : this.currentEulerData) {
                    if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
                    this.currentEulerData = null;
                    break;
                }
                if (this.currentEulerData != null) {
                    eulerPt = ODE_3D.this.extractPointFromData(this.currentEulerData);
                }
            }
            if (this.orbitType <= 1 && this.currentRungeKuttaData != null) {
                ODE_3D.this.nextRungeKuttaPoint(this.currentRungeKuttaData, this.dt);
                for (double d : this.currentRungeKuttaData) {
                    if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
                    this.currentRungeKuttaData = null;
                    break;
                }
                if (this.currentRungeKuttaData != null) {
                    rkPoint = ODE_3D.this.extractPointFromData(this.currentRungeKuttaData);
                }
            }
            if (eulerPt == null && rkPoint == null) {
                return false;
            }
            if (!ODE_3D.this.isAutonomous) {
                double d = Double.NEGATIVE_INFINITY;
                if (this.currentEulerData != null) {
                    d = this.currentEulerData[0];
                }
                if (this.currentRungeKuttaData != null && this.currentRungeKuttaData[0] > d) {
                    d = this.currentRungeKuttaData[0];
                }
                this.view.currentTime = d;
            }
            ++this.pointCount;
            boolean ok = true;
            if (eulerPt != null) {
                ok = this.eulerPoints.addNow((View3D)this.view, eulerPt);
            }
            if (rkPoint != null) {
                boolean bl = ok = ok && this.rungeKuttaPoints.addNow((View3D)this.view, rkPoint);
            }
            if (!ok) {
                this.view.forceRedraw();
            }
            if (this.isCurrentOrbit && this.view.projectedOrbitView != null) {
                this.view.projectedOrbitView.addPoints(eulerPt, rkPoint);
            }
            return true;
        }

        @Override
        public void computeDrawData(View v, boolean exhibitNeedsRedraw, Transform previousTransform, Transform newTransform) {
            if ((this.decorationNeedsRedraw || exhibitNeedsRedraw) && this.pointCount > 1) {
                int i;
                this.currentRungeKuttaData = null;
                this.currentEulerData = null;
                if (this.orbitType >= 1) {
                    this.currentEulerData = (double[])this.initialData.clone();
                    this.eulerPoints.clear();
                    this.eulerPoints.addPoint(ODE_3D.this.extractPointFromData(this.initialData));
                    for (i = 1; i < this.pointCount; ++i) {
                        ODE_3D.this.nextEulerPoint(this.currentEulerData, this.dt);
                        for (double d : this.currentEulerData) {
                            if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
                            this.currentEulerData = null;
                            break;
                        }
                        if (this.currentEulerData == null) break;
                        this.eulerPoints.addPoint(ODE_3D.this.extractPointFromData(this.currentEulerData));
                    }
                }
                if (this.orbitType <= 1) {
                    this.currentRungeKuttaData = (double[])this.initialData.clone();
                    this.rungeKuttaPoints.clear();
                    this.rungeKuttaPoints.addPoint(ODE_3D.this.extractPointFromData(this.initialData));
                    for (i = 1; i < this.pointCount; ++i) {
                        ODE_3D.this.nextRungeKuttaPoint(this.currentRungeKuttaData, this.dt);
                        for (double d : this.currentRungeKuttaData) {
                            if (!Double.isNaN(d) && !Double.isInfinite(d)) continue;
                            this.currentRungeKuttaData = null;
                            break;
                        }
                        if (this.currentRungeKuttaData == null) break;
                        this.rungeKuttaPoints.addPoint(ODE_3D.this.extractPointFromData(this.currentRungeKuttaData));
                    }
                }
                if (this.isCurrentOrbit && this.view.projectedOrbitView != null) {
                    this.view.projectedOrbitView.resetPointsFromOrbit(this);
                }
            }
        }

        @Override
        public void doDraw(Graphics2D g, View view, Transform transform) {
            if (this.orbitType >= 1) {
                this.eulerPoints.draw(g, (View3D)view, transform);
            }
            if (this.orbitType <= 1) {
                this.rungeKuttaPoints.draw(g, (View3D)view, transform);
            }
        }
    }

    private class ProjectedOrbitView
    extends View {
        ArrayList<Vector3D> eulerPoints;
        ArrayList<Vector3D> rungeKuttaPoints;
        int maxNumberOfPoints;
        ODEView owner;

        ProjectedOrbitView(ODEView owner) {
            this.owner = owner;
            this.setPreserveAspect(false);
            this.setApplyGraphics2DTransform(false);
            this.setAntialiased(true);
            this.eulerPoints = new ArrayList();
            this.rungeKuttaPoints = new ArrayList();
            this.setExhibit(new Exhibit(){

                @Override
                protected void doDraw(Graphics2D g, View view, Transform transform) {
                    ProjectedOrbitView.this.draw(g, transform);
                }

                @Override
                public Color getDefaultBackground() {
                    return Color.BLACK;
                }

                @Override
                public Transform getDefaultTransform(View view) {
                    return new POVTransform();
                }
            });
        }

        @Override
        public MouseTask getDefaultMouseTask() {
            return null;
        }

        void setMaxPoints(int ct) {
            this.maxNumberOfPoints = ct;
            this.forceRedraw();
        }

        void resetPointsFromOrbit(Orbit orbit) {
            int i;
            int ct;
            this.eulerPoints.clear();
            this.rungeKuttaPoints.clear();
            if (orbit.getOrbitType() >= 1) {
                OrbitPoints3D euler = orbit.getEulerPoints();
                ct = euler.getPointCount();
                for (i = 0; i < ct; ++i) {
                    this.eulerPoints.add(euler.getPoint(i));
                }
            }
            if (orbit.getOrbitType() <= 1) {
                OrbitPoints3D rk = orbit.getRungeKuttaPoints();
                ct = rk.getPointCount();
                for (i = 0; i < ct; ++i) {
                    this.rungeKuttaPoints.add(rk.getPoint(i));
                }
            }
            this.forceRedraw();
        }

        void clear() {
            this.eulerPoints.clear();
            this.rungeKuttaPoints.clear();
            this.forceRedraw();
        }

        void addPoints(Vector3D eulerPt, Vector3D rkPoint) {
            int ptNum;
            this.eulerPoints.add(eulerPt);
            this.rungeKuttaPoints.add(rkPoint);
            if (eulerPt == null && rkPoint == null) {
                return;
            }
            if (eulerPt != null && this.eulerPoints.size() > 1 && !this.drawLineNow(ptNum = this.eulerPoints.size() - 1, this.eulerPoints.get(ptNum - 1), this.eulerPoints.get(ptNum), true)) {
                this.forceRedraw();
                return;
            }
            if (rkPoint != null && this.rungeKuttaPoints.size() > 1 && !this.drawLineNow(ptNum = this.rungeKuttaPoints.size() - 1, this.rungeKuttaPoints.get(ptNum - 1), this.rungeKuttaPoints.get(ptNum), false)) {
                this.forceRedraw();
            }
        }

        boolean drawLineNow(int ptNum, Vector3D pt1, Vector3D pt2, boolean eulerColors) {
            if (pt1 == null || pt2 == null) {
                return true;
            }
            if (!this.beginDrawToOffscreenImage()) {
                return false;
            }
            Transform transform = this.getTransform();
            ((POVTransform)transform).getLimitsFromOwner();
            double pixelWidth = (transform.getXmax() - transform.getXmin()) / (double)transform.getWidth();
            double leftSpace = 15.0 * pixelWidth;
            double left = transform.getXmin() + 3.0 * leftSpace;
            double dt = (transform.getXmax() - transform.getXmin() - 3.0 * leftSpace) / (double)(this.maxNumberOfPoints - 1);
            double t = left + (double)ptNum * dt;
            if (eulerColors) {
                this.setColor(EULER_PROJECTED_ORBIT_X_COLOR);
                this.drawLine(t - dt, pt1.x, t, pt2.x);
                this.setColor(EULER_PROJECTED_ORBIT_Y_COLOR);
                this.drawLine(t - dt, pt1.y, t, pt2.y);
                this.setColor(EULER_PROJECTED_ORBIT_Z_COLOR);
                this.drawLine(t - dt, pt1.z, t, pt2.z);
            } else {
                this.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_X_COLOR);
                this.drawLine(t - dt, pt1.x, t, pt2.x);
                this.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_Y_COLOR);
                this.drawLine(t - dt, pt1.y, t, pt2.y);
                this.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_Z_COLOR);
                this.drawLine(t - dt, pt1.z, t, pt2.z);
            }
            return true;
        }

        void draw(Graphics2D g, Transform transform) {
            Vector3D pt2;
            double t;
            int i;
            Vector3D pt1;
            ((POVTransform)transform).getLimitsFromOwner();
            double pixelWidth = (transform.getXmax() - transform.getXmin()) / (double)transform.getWidth();
            double leftSpace = 15.0 * pixelWidth;
            g.setColor(Color.LIGHT_GRAY);
            this.drawLine(transform.getXmin() + 2.0 * leftSpace, 0.0, transform.getXmax(), 0.0);
            this.drawLine(transform.getXmin() + 3.0 * leftSpace, transform.getYmin(), transform.getXmin() + 3.0 * leftSpace, transform.getYmax());
            double height = transform.getYmax() - transform.getYmin();
            g.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_X_COLOR);
            this.drawString("x", transform.getXmin() + leftSpace, transform.getYmax() - height / 4.0 - 3.0 * pixelWidth);
            g.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_Y_COLOR);
            this.drawString("y", transform.getXmin() + leftSpace, transform.getYmax() - height / 2.0 - 3.0 * pixelWidth);
            g.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_Z_COLOR);
            this.drawString("z", transform.getXmin() + leftSpace, transform.getYmax() - 3.0 * height / 4.0 - 3.0 * pixelWidth);
            double left = transform.getXmin() + 3.0 * leftSpace;
            double dt = (transform.getXmax() - transform.getXmin() - 3.0 * leftSpace) / (double)(this.maxNumberOfPoints - 1);
            if (this.owner.getOrbitType() >= 1 && this.eulerPoints.size() > 0) {
                pt1 = this.eulerPoints.get(0);
                for (i = 1; i < this.eulerPoints.size(); ++i) {
                    t = left + (double)i * dt;
                    pt2 = this.eulerPoints.get(i);
                    if (pt1 != null && pt2 != null) {
                        g.setColor(EULER_PROJECTED_ORBIT_X_COLOR);
                        this.drawLine(t - dt, pt1.x, t, pt2.x);
                        g.setColor(EULER_PROJECTED_ORBIT_Y_COLOR);
                        this.drawLine(t - dt, pt1.y, t, pt2.y);
                        g.setColor(EULER_PROJECTED_ORBIT_Z_COLOR);
                        this.drawLine(t - dt, pt1.z, t, pt2.z);
                    }
                    pt1 = pt2;
                }
            }
            if (this.owner.getOrbitType() <= 1 && this.rungeKuttaPoints.size() > 0) {
                pt1 = this.rungeKuttaPoints.get(0);
                for (i = 1; i < this.rungeKuttaPoints.size(); ++i) {
                    t = left + (double)i * dt;
                    pt2 = this.rungeKuttaPoints.get(i);
                    if (pt1 != null && pt2 != null) {
                        g.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_X_COLOR);
                        this.drawLine(t - dt, pt1.x, t, pt2.x);
                        g.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_Y_COLOR);
                        this.drawLine(t - dt, pt1.y, t, pt2.y);
                        g.setColor(RUNGE_KUTTA_PROJECTED_ORBIT_Z_COLOR);
                        this.drawLine(t - dt, pt1.z, t, pt2.z);
                    }
                    pt1 = pt2;
                }
            }
        }

        private class POVTransform
        extends Transform {
            private POVTransform() {
            }

            void getLimitsFromOwner() {
                Transform tr = ProjectedOrbitView.this.owner.getTransform();
                this.resetLimits(-1.0, 1.0, tr.getYmin(), tr.getYmax());
            }
        }
    }

    public class ODEView
    extends View3D {
        private boolean showDirectionField;
        @VMMSave
        private boolean showProjectedOrbits = false;
        @VMMSave
        private boolean showControlPanel = true;
        @VMMSave
        private int orbitType = 0;
        @VMMSave
        private boolean connectDotsOnOrbit;
        private boolean animateDrawing = true;
        private Orbit currentOrbit;
        private ControlPanel controlPanel;
        private ProjectedOrbitView projectedOrbitView;
        private double[] initialDataForCreateAnimation;
        private double currentTime;
        protected ToggleAction showDirectionFieldToggle;
        protected ToggleAction showProjectedOrbitsToggle = new ToggleAction(I18n.tr("vmm.ode.command.ShowProjectedOrbits"), false){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ODEView.this.setShowProjectedOrbits(this.getState());
            }
        };
        protected ToggleAction showControlPanelToggle = new ToggleAction(I18n.tr("vmm.ode.command.ShowControlPanel"), true){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ODEView.this.setShowControlPanel(this.getState());
            }
        };
        protected ToggleAction animateDrawingToggle = new ToggleAction(I18n.tr("vmm.ode.command.AnimateDrawing"), true){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ODEView.this.setAnimateDrawing(this.getState());
            }
        };
        protected AbstractActionVMM continueOrbitAction = new AbstractActionVMM(I18n.tr("vmm.ode.command.ContinueOrbit")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Orbit orbit = ODEView.this.getCurrentOrbit();
                if (orbit != null) {
                    double timeSpan;
                    try {
                        timeSpan = Double.parseDouble(((ODEView)ODEView.this).controlPanel.timeSpanInput.getText());
                    }
                    catch (Exception e) {
                        timeSpan = ODE_3D.this.timeSpanDefault;
                        ((ODEView)ODEView.this).controlPanel.timeSpanInput.setText("" + ODE_3D.this.timeSpanDefault);
                    }
                    int numberOfPoints = (int)(timeSpan / orbit.dt + 0.5);
                    ((ODEView)ODEView.this).controlPanel.dtInput.setText("" + orbit.dt);
                    if (ODEView.this.animateDrawing) {
                        ODEView.this.getDisplay().installAnimation(new ExtendOrbitAnimation(ODEView.this, orbit, numberOfPoints));
                    } else {
                        orbit.setPointCount(orbit.getPointCount() + numberOfPoints);
                    }
                }
            }
        };
        protected ToggleAction connectDotsToggle = new ToggleAction(I18n.tr("vmm.ode.command.ConnectDotsOnOrbit"), false){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ODEView.this.setConnectDotsOnOrbit(this.getState());
            }
        };
        protected AbstractActionVMM eraseOrbitsAction = new AbstractActionVMM(I18n.tr("vmm.ode.command.EraseOrbits")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Decoration[] decorations;
                if (ODEView.this.getDisplay() != null) {
                    ODEView.this.getDisplay().stopAnimation();
                }
                ODEView.this.setCurrentOrbit(null);
                for (Decoration dec : decorations = ODEView.this.getDecorations()) {
                    if (!(dec instanceof Orbit)) continue;
                    ODEView.this.removeDecoration(dec);
                }
            }
        };
        protected ActionRadioGroup orbitTypeSelect = new ActionRadioGroup(new String[]{I18n.tr("vmm.ode.command.orbitType.RungeKutta"), I18n.tr("vmm.ode.command.orbitType.Euler"), I18n.tr("vmm.ode.command.orbitType.Both")}, 0){

            @Override
            public void optionSelected(int option) {
                int style = option == 0 ? 0 : (option == 1 ? 2 : 1);
                ODEView.this.setOrbitType(style);
            }
        };

        public ODEView() {
            if (ODE_3D.this.showAxes) {
                this.setShowAxes(true);
            }
            if (ODE_3D.this.anaglyphIsDefault) {
                this.setViewStyle(1);
            }
            this.setAntialiased(true);
            this.continueOrbitAction.setEnabled(this.getCurrentOrbit() != null);
            this.controlPanel = new ControlPanel(this);
            boolean bl = this.showDirectionField = ODE_3D.this.isAutonomous && ODE_3D.this.canShowVectorField;
            if (ODE_3D.this.isAutonomous && ODE_3D.this.canShowVectorField) {
                this.showDirectionFieldToggle = new ToggleAction(I18n.tr("vmm.ode.command.ShowDirectionField"), true){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        ODEView.this.setShowDirectionField(this.getState());
                    }
                };
            }
        }

        public boolean getShowDirectionField() {
            return this.showDirectionField;
        }

        public void setShowDirectionField(boolean showDirectionField) {
            if (!ODE_3D.this.canShowVectorField) {
                return;
            }
            if (this.showDirectionField == showDirectionField) {
                return;
            }
            this.showDirectionField = showDirectionField;
            if (this.showDirectionFieldToggle != null) {
                this.showDirectionFieldToggle.setState(showDirectionField);
            }
            this.forceRedraw();
        }

        public boolean getAnimateDrawing() {
            return this.animateDrawing;
        }

        public void setAnimateDrawing(boolean animateDrawing) {
            this.animateDrawing = animateDrawing;
            this.animateDrawingToggle.setState(animateDrawing);
        }

        protected Orbit getCurrentOrbit() {
            return this.currentOrbit;
        }

        protected void setCurrentOrbit(Orbit orbit) {
            if (this.currentOrbit == orbit) {
                return;
            }
            if (this.currentOrbit != null) {
                this.currentOrbit.setIsCurrentOrbit(false);
            }
            this.currentOrbit = orbit;
            if (this.currentOrbit != null) {
                this.currentOrbit.setIsCurrentOrbit(true);
            }
            this.continueOrbitAction.setEnabled(this.currentOrbit != null);
        }

        public boolean getConnectDotsOnOrbit() {
            return this.connectDotsOnOrbit;
        }

        public void setConnectDotsOnOrbit(boolean connectDotsOnOrbit) {
            if (this.connectDotsOnOrbit == connectDotsOnOrbit) {
                return;
            }
            this.connectDotsOnOrbit = connectDotsOnOrbit;
            this.connectDotsToggle.setState(connectDotsOnOrbit);
            if (this.currentOrbit != null) {
                this.currentOrbit.setStyle(connectDotsOnOrbit ? 0 : 1);
            }
        }

        public boolean getShowProjectedOrbits() {
            return this.showProjectedOrbits;
        }

        public int getOrbitType() {
            return this.orbitType;
        }

        public void setOrbitType(int type) {
            if (type == this.orbitType) {
                return;
            }
            this.orbitType = type;
            if (this.currentOrbit != null) {
                this.currentOrbit.setOrbitType(this.orbitType);
                if (this.showProjectedOrbits) {
                    this.projectedOrbitView.forceRedraw();
                }
            }
        }

        public boolean getShowControlPanel() {
            return this.showControlPanel;
        }

        public void setShowControlPanel(boolean showControlPanel) {
            if (this.showControlPanel == showControlPanel) {
                return;
            }
            this.showControlPanel = showControlPanel;
            this.showControlPanelToggle.setState(showControlPanel);
            if (showControlPanel) {
                if (this.getDisplay() != null) {
                    this.getDisplay().getHolder().add((Component)this.controlPanel, "East");
                    this.getDisplay().getHolder().validate();
                }
            } else if (this.getDisplay() != null) {
                this.getDisplay().getHolder().remove(this.controlPanel);
                this.getDisplay().getHolder().validate();
            }
        }

        public void setShowProjectedOrbits(boolean showProjectedOrbits) {
            if (this.showProjectedOrbits == showProjectedOrbits) {
                return;
            }
            this.showProjectedOrbits = showProjectedOrbits;
            this.showProjectedOrbitsToggle.setState(showProjectedOrbits);
            if (showProjectedOrbits) {
                this.projectedOrbitView = new ProjectedOrbitView(this);
                if (this.getCurrentOrbit() != null) {
                    this.projectedOrbitView.setMaxPoints(this.getCurrentOrbit().getPointCount());
                    this.projectedOrbitView.resetPointsFromOrbit(this.getCurrentOrbit());
                }
                if (this.getDisplay() != null) {
                    this.getDisplay().installAuxiliaryView(this, this.projectedOrbitView, 3, 0.2, true);
                }
            } else {
                this.projectedOrbitView = null;
                if (this.getDisplay() != null) {
                    this.getDisplay().installAuxiliaryView(this, null);
                }
            }
        }

        @Override
        public ActionList getActions() {
            ActionList actions = super.getActions();
            actions.add(this.continueOrbitAction);
            actions.add(this.eraseOrbitsAction);
            actions.add(this.connectDotsToggle);
            actions.add(this.animateDrawingToggle);
            actions.add(null);
            actions.add(this.orbitTypeSelect);
            actions.add(null);
            if (this.showDirectionFieldToggle != null) {
                actions.add(this.showDirectionFieldToggle);
            }
            actions.add(this.showControlPanelToggle);
            actions.add(this.showProjectedOrbitsToggle);
            return actions;
        }

        @Override
        public void setDisplay(Display display) {
            super.setDisplay(display);
            if (display != null) {
                display.setStopAnimationsOnResize(false);
            }
            if (display != null && this.projectedOrbitView != null) {
                display.installAuxiliaryView(this, this.projectedOrbitView, 3, 0.2, true);
            }
            if (display != null && this.showControlPanel) {
                display.getHolder().add((Component)this.controlPanel, "East");
                display.getHolder().validate();
            }
        }

        @Override
        public void setExhibit(Exhibit ex) {
            super.setExhibit(ex);
            if (ex != null && ex == ODE_3D.this) {
                this.initialDataForCreateAnimation = ODE_3D.this.initialDataDefault;
            }
        }

        @Override
        public void stateChanged(ChangeEvent evt) {
            super.stateChanged(evt);
            Object source = evt.getSource();
            if (this.projectedOrbitView != null && source instanceof Transform) {
                this.projectedOrbitView.forceRedraw();
            }
        }

        @Override
        public MouseTask getDefaultMouseTask() {
            return ODE_3D.this.makeDefaultMouseTask(this);
        }

        public double getCurrentTimeFromControlPanel() {
            if (ODE_3D.this.isAutonomous) {
                return 0.0;
            }
            try {
                return Double.parseDouble(this.controlPanel.icInputs[0].getText());
            }
            catch (NumberFormatException e) {
                this.controlPanel.icInputs[0].setText("0");
                return 0.0;
            }
        }

        public void startOrbitAtPoint(double[] initialPointData) {
            double timeSpan;
            double dt;
            try {
                dt = Double.parseDouble(this.controlPanel.dtInput.getText());
                if (dt <= 0.0) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                dt = ODE_3D.this.dtDefault;
                this.controlPanel.dtInput.setText("" + ODE_3D.this.dtDefault);
            }
            try {
                timeSpan = Double.parseDouble(this.controlPanel.timeSpanInput.getText());
                if (timeSpan <= 0.0) {
                    throw new Exception();
                }
            }
            catch (Exception e) {
                timeSpan = ODE_3D.this.timeSpanDefault;
                this.controlPanel.timeSpanInput.setText("" + ODE_3D.this.timeSpanDefault);
            }
            this.controlPanel.resetStartPointInputText(initialPointData);
            this.startOrbitAtPoint(initialPointData, dt, timeSpan);
        }

        private TimerAnimation makeCreateAnimation() {
            double timeSpan;
            double dt;
            Orbit orbit;
            if (!this.animateDrawing) {
                return null;
            }
            if (this.currentOrbit == null && this.initialDataForCreateAnimation == null) {
                return null;
            }
            if (this.currentOrbit != null) {
                orbit = this.currentOrbit;
                dt = this.currentOrbit.dt;
                timeSpan = dt * (double)this.currentOrbit.pointCount;
                this.currentOrbit.removePoints();
            } else {
                int dataCt = ODE_3D.this.inputLabelNames.length;
                dt = this.initialDataForCreateAnimation.length > dataCt && this.initialDataForCreateAnimation[dataCt] > 0.0 ? this.initialDataForCreateAnimation[dataCt] : ODE_3D.this.dtDefault;
                timeSpan = this.initialDataForCreateAnimation.length > dataCt + 1 && this.initialDataForCreateAnimation[dataCt + 1] > 0.0 ? this.initialDataForCreateAnimation[dataCt + 1] : ODE_3D.this.timeSpanDefault;
                double[] data = new double[dataCt];
                for (int i = 0; i < dataCt; ++i) {
                    data[i] = this.initialDataForCreateAnimation[i];
                }
                orbit = new Orbit(this, data, 0, dt);
                this.controlPanel.resetStartPointInputText(this.initialDataForCreateAnimation);
                this.addDecoration(orbit);
                this.setCurrentOrbit(orbit);
            }
            this.initialDataForCreateAnimation = null;
            int numberOfPoints = (int)(timeSpan / dt) + 1;
            this.controlPanel.dtInput.setText("" + dt);
            this.controlPanel.timeSpanInput.setText("" + timeSpan);
            if (!ODE_3D.this.isAutonomous) {
                this.currentTime = orbit.initialData[0];
            }
            return new ExtendOrbitAnimation(this, orbit, numberOfPoints);
        }

        private void startOrbitAtPoint(double[] initialPointData, double dt, double timeSpan) {
            Orbit orbit = new Orbit(this, initialPointData, this.orbitType, dt);
            this.addDecoration(orbit);
            this.setCurrentOrbit(orbit);
            if (this.getConnectDotsOnOrbit()) {
                orbit.setStyle(0);
            }
            int numberOfPoints = (int)(timeSpan / dt + 0.5);
            if (!ODE_3D.this.isAutonomous && this.animateDrawing) {
                this.currentTime = initialPointData[0];
            }
            if (this.animateDrawing) {
                this.getDisplay().installAnimation(new ExtendOrbitAnimation(this, orbit, numberOfPoints));
            } else {
                orbit.setPointCount(numberOfPoints + 1);
            }
        }

        @Override
        public void addExtraXML(Document containingDocument, Element viewElement) {
            super.addExtraXML(containingDocument, viewElement);
            if (ODE_3D.this.isAutonomous && ODE_3D.this.canShowVectorField) {
                SaveAndRestore.addProperty(this, "showDirectionField", containingDocument, viewElement);
            }
            for (Decoration d : this.getDecorations()) {
                if (!(d instanceof Orbit)) continue;
                Orbit orbit = (Orbit)d;
                Element orbElm = containingDocument.createElement("orbit");
                orbElm.setAttribute("start", Util.toExternalString(orbit.initialData));
                orbElm.setAttribute("type", Util.toExternalString(orbit.orbitType));
                orbElm.setAttribute("dt", Util.toExternalString(orbit.dt));
                orbElm.setAttribute("points", Util.toExternalString(orbit.pointCount));
                orbElm.setAttribute("isCurrentOrbit", Util.toExternalString(orbit.isCurrentOrbit));
                orbElm.setAttribute("style", "" + orbit.eulerPoints.getStyle());
                viewElement.appendChild(orbElm);
            }
        }

        @Override
        public void readExtraXML(Element viewInfo) throws IOException {
            super.readExtraXML(viewInfo);
            NodeList nodes = viewInfo.getElementsByTagName("orbit");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element orbElm = (Element)nodes.item(i);
                double[] startPt = (double[])Util.externalStringToValue(orbElm.getAttribute("start"), double[].class);
                double dt = (Double)Util.externalStringToValue(orbElm.getAttribute("dt"), Double.TYPE);
                int type = (Integer)Util.externalStringToValue(orbElm.getAttribute("type"), Integer.TYPE);
                int pointCount = (Integer)Util.externalStringToValue(orbElm.getAttribute("points"), Integer.TYPE);
                boolean isCurrentOrbit = (Boolean)Util.externalStringToValue(orbElm.getAttribute("isCurrentOrbit"), Boolean.TYPE);
                int style = (Integer)Util.externalStringToValue(orbElm.getAttribute("style"), Integer.TYPE);
                Orbit orbit = new Orbit(this, startPt, type, dt);
                orbit.pointCount = pointCount;
                orbit.setIsCurrentOrbit(isCurrentOrbit);
                orbit.setStyle(style);
                this.addDecoration(orbit);
                if (!isCurrentOrbit) continue;
                this.controlPanel.dtInput.setText("" + dt);
                this.controlPanel.resetStartPointInputText(startPt);
                this.currentOrbit = orbit;
                this.continueOrbitAction.setEnabled(true);
            }
        }
    }
}

