/*
 * Decompiled with CFR 0.152.
 */
package vmm.latticemodel;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import vmm.actions.AbstractActionVMM;
import vmm.actions.ActionItem;
import vmm.actions.ActionList;
import vmm.actions.ActionRadioGroup;
import vmm.actions.ToggleAction;
import vmm.core.Animation;
import vmm.core.Display;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.MouseTask;
import vmm.core.Parameter;
import vmm.core.ParameterDialog;
import vmm.core.ParameterInput;
import vmm.core.RealParam;
import vmm.core.TimerAnimation;
import vmm.core.Transform;
import vmm.core.Util;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Exhibit3D;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;
import vmm.fourier.FourierSeries;
import vmm.functions.ParseError;

public abstract class LatticeModel
extends Exhibit3D {
    public static final int MAX_NUMBER_OF_NODES = 256;
    public static final int DISPLAY_TRANSVERSE = 0;
    public static final int DISPLAY_LONGITUDINAL = 1;
    public static final int DISPLAY_CIRCILAR = 2;
    public static final int DISPLAY_PENDULUM = 3;
    public static final int DISPLAY_BRIDGE = 4;
    public static final int DISPLAY_FPU_GRAPH = 5;
    public static final int BOUNDARY_CONDITION_ZERO = 0;
    public static final int BOUNDARY_CONDITION_PERIODIC = 1;
    public static final int INITIAL_SHAPE_SINUSOIDAL = 0;
    public static final int INITIAL_SHAPE_GAUSSIAN = 1;
    public static final int INITIAL_SHAPE_THERMAL = 2;
    public static final int INITIAL_SHAPE_KINK = 3;
    public static final int INITIAL_SHAPE_BREATHER = 4;
    public static final int INITIAL_MODE_FIRST = 0;
    public static final int INITIAL_MODE_SECOND = 1;
    public static final int INITIAL_MODE_FOURTH = 2;
    public static final int INITIAL_MODE_EIGHTH = 3;
    public static final int INITIAL_MODE_SIXTEENTH = 4;
    protected int numIterations;
    protected double defaultStepSize = 0.1;
    protected int defaultBoundaryCondition = 0;
    protected int defaultInitialShape = 0;
    protected int defaultInitialMode = 0;
    protected int defaultDisplayStyle = 0;
    protected boolean canShowNormalModeDisplay = true;
    protected double defaultLatticeLength = 6.2832;
    protected double defaultLatticeDensity = 1.0;
    protected double defaultAmplitude = 1.0;
    protected int defaultNumberOfNodes = 32;
    protected double defaultScaleFactor = 1.0;
    protected boolean MaxPermittedDisplacementExceeded;

    protected abstract double potentialEnergy(double var1, double var3);

    protected abstract double internalForceLaw(double var1, double var3);

    protected abstract double externalForceLaw(double var1, double var3);

    protected void drawTransverse(View3D view) {
        int i;
        Color saveColor = view.getColor();
        LMView lmView = (LMView)view;
        LatticeData data = lmView.getLatticeData();
        double scale = lmView.controlPanel.getScaleFactor();
        if (((LMView)view).getShowNormalModeDisplay()) {
            data.GetLatticeModeEnergies((LMView)view);
        }
        view.drawLine(0.0, 0.0, data.latticeLength, 0.0);
        view.drawLine(0.0, -1.6 / scale, 0.0, 1.6 / scale);
        view.drawLine(data.latticeLength, -1.6 / scale, data.latticeLength, 1.6 / scale);
        for (i = 0; i < data.nodeCount; ++i) {
            view.drawLine(data.LatticeAbscissa(i, lmView), data.currentDisplacement[i], data.LatticeAbscissa(i + 1, lmView), data.currentDisplacement[i + 1]);
        }
        view.setColor(Color.BLUE);
        for (i = 0; i < data.nodeCount; ++i) {
            view.drawLine(data.LatticeAbscissa(i, lmView), data.currentVelocity[i], data.LatticeAbscissa(i + 1, lmView), data.currentVelocity[i + 1]);
        }
        view.setColor(saveColor);
    }

    @Override
    protected void doDraw3D(Graphics2D g, View3D view, Transform3D transform) {
        LMView lmView = (LMView)view;
        int displayStyle = lmView.getDisplayStyle();
        LatticeData data = lmView.getLatticeData();
        double pixelWidth = data.latticeLength / (double)(transform.getWidth() - 30);
        double xmin = -15.0 * pixelWidth;
        double xmax = data.latticeLength + 15.0 * pixelWidth;
        double scale = 1.0;
        if (displayStyle == 0) {
            scale = lmView.controlPanel.getScaleFactor();
            double ymax = 2.0 / scale;
            double ymin = -ymax;
            ((LMTransform)transform).resetXYLimits(xmin, xmax, ymin, ymax);
            this.drawTransverse(view);
        }
        if (displayStyle == 3) {
            view.setViewPoint(new Vector3D(0.0, -5.0 * data.latticeLength, 0.0));
        } else if (displayStyle == 4) {
            view.setViewPoint(new Vector3D(data.latticeLength, -5.0 * data.latticeLength, data.latticeLength));
        }
        if (view.getEnableThreeD()) {
            view.drawString("(3D) Step number = " + data.stepNumber, new Vector3D(0.0, 0.0, 1.0));
        } else {
            view.drawString("  TNE = " + (double)Math.round(100000.0 * data.LatticeTotalEnergy(lmView)) / 100000.0, 0.0, -1.25 / scale);
        }
        view.drawString("  Time = " + (double)Math.round(4.0 * data.currentTime) / 4.0, 0.0, -1.55 / scale);
        if (((LMView)view).getShowNormalModeDisplay()) {
            // empty if block
        }
    }

    @Override
    public View getDefaultView() {
        return new LMView();
    }

    @Override
    public Animation getCreateAnimation(View view) {
        LMView lmView;
        LMView lMView = lmView = (LMView)view;
        lMView.getClass();
        return lMView.new LMView.EvolveLattice(true);
    }

    @Override
    public ActionList getSettingsCommandsForView(View view) {
        ActionList commands = super.getSettingsCommandsForView(view);
        ActionItem setXYLimitsCommand = commands.getItem(commands.getItemCount() - 1);
        if (setXYLimitsCommand instanceof AbstractActionVMM) {
            ((AbstractActionVMM)setXYLimitsCommand).setEnabled(false);
        }
        return commands;
    }

    @Override
    public Transform getDefaultTransform(View view) {
        return new LMTransform();
    }

    public class LMView
    extends View3D {
        protected AbstractActionVMM restartAction = new AbstractActionVMM(I18n.tr("vmm.latticemodel.command.Start")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LMView.this.doRestart();
            }
        };
        protected AbstractActionVMM stopAction = new AbstractActionVMM(I18n.tr("vmm.latticemodel.command.Stop")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LMView.this.doStop();
            }
        };
        protected AbstractActionVMM continueAction = new AbstractActionVMM(I18n.tr("vmm.latticemodel.command.Continue")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LMView.this.doContinue();
            }
        };
        protected AbstractActionVMM stepAction = new AbstractActionVMM(I18n.tr("vmm.latticemodel.command.Step")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LMView.this.doStep();
            }
        };
        protected ActionRadioGroup displayStyleSelect = new ActionRadioGroup(){

            @Override
            public void optionSelected(int selectedIndex) {
                LMView.this.setDisplayStyle(this.getSelectedIndex());
            }
        };
        protected ActionRadioGroup initialModeSelect = new ActionRadioGroup(){

            @Override
            public void optionSelected(int selectedIndex) {
                LMView.this.setInitialMode(this.getSelectedIndex());
            }
        };
        protected ActionRadioGroup initialShapeSelect = new ActionRadioGroup(){

            @Override
            public void optionSelected(int selectedIndex) {
                LMView.this.setInitialShape(this.getSelectedIndex());
            }
        };
        protected ActionRadioGroup boundaryConditionSelect = new ActionRadioGroup(){

            @Override
            public void optionSelected(int selectedIndex) {
                LMView.this.setBoundaryCondition(this.getSelectedIndex());
            }
        };
        protected ToggleAction showNormalModeToggle;
        protected ToggleAction showControlPanelToggle;
        protected RealParam latticeLength;
        protected RealParam latticeDensity;
        protected RealParam amplitude;
        protected IntegerParam numberOfNodes;
        @VMMSave
        private int displayStyle;
        @VMMSave
        private int initialShape;
        @VMMSave
        private int initialMode;
        @VMMSave
        private int boundaryCondition;
        @VMMSave
        private boolean showControlPanel;
        @VMMSave
        private boolean showNormalModeDisplay;
        protected LatticeData latticeData;
        private ControlPanel controlPanel;

        public LMView() {
            this.showNormalModeToggle = new ToggleAction(I18n.tr("vmm.latticemodel.ShowNormalModeDisplay"), LatticeModel.this.canShowNormalModeDisplay){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LMView.this.setShowNormalModeDisplay(this.getState());
                }
            };
            this.showControlPanelToggle = new ToggleAction(I18n.tr("vmm.latticemodel.ShowControlPanel"), true){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LMView.this.setShowControlPanel(this.getState());
                }
            };
            this.latticeLength = new RealParam("vmm.latticeModel.LatticeLength", LatticeModel.this.defaultLatticeLength);
            this.latticeDensity = new RealParam("vmm.latticeModel.LatticeDensity", LatticeModel.this.defaultLatticeDensity);
            this.amplitude = new RealParam("vmm.latticeModel.Amplitude", LatticeModel.this.defaultAmplitude);
            this.numberOfNodes = new IntegerParam("vmm.latticeModel.NumberOfNodes", LatticeModel.this.defaultNumberOfNodes){

                @Override
                public ParameterInput createParameterInput(int inputType) {
                    return new ParameterInput(this, inputType){

                        @Override
                        public String checkContents() {
                            String contents = this.getText();
                            double val = 0.0;
                            try {
                                val = Util.parseConstantExpression(contents).value();
                            }
                            catch (ParseError e) {
                                this.requestFocus();
                                this.selectAll();
                                return I18n.tr("vmm.core.ParameterInput.badExpression", this.getTitle(), contents, e.getMessage());
                            }
                            int intval = val > 0.0 ? (int)(val + 1.0E-8) : (int)(val - 1.0E-8);
                            if (Math.abs(val - (double)intval) > 5.0E-9) {
                                this.requestFocus();
                                this.selectAll();
                                return I18n.tr("vmm.core.ParameterInput.badint", this.getTitle());
                            }
                            if (intval < 3 || intval > 65 && intval != 128 && intval != 256) {
                                this.requestFocus();
                                this.selectAll();
                                return I18n.tr("vmm.latticemodel.LatticeModel.badNumberOfNodes");
                            }
                            return null;
                        }
                    };
                }
            };
            this.displayStyle = 0;
            this.initialMode = LatticeModel.this.defaultInitialMode;
            this.showControlPanel = true;
            this.showNormalModeDisplay = LatticeModel.this.canShowNormalModeDisplay;
            this.setAntialiased(true);
            this.addParameter(this.latticeLength);
            this.latticeLength.setMinimumValueForInput(Double.MIN_VALUE);
            this.addParameter(this.latticeDensity);
            this.addParameter(this.amplitude);
            this.latticeDensity.setMinimumValueForInput(Double.MIN_VALUE);
            this.addParameter(this.numberOfNodes);
            this.numberOfNodes.setMinimumValueForInput(3);
            this.numberOfNodes.setMaximumValueForInput(512);
            this.displayStyleSelect.addItem(I18n.tr("vmm.latticemodel.TransverseDisplay"));
            this.displayStyleSelect.addItem(I18n.tr("vmm.latticemodel.LongitudinalDisplay"));
            this.displayStyleSelect.addItem(I18n.tr("vmm.latticemodel.CircularDisplay"));
            this.displayStyleSelect.addItem(I18n.tr("vmm.latticemodel.PendulumDisplay"));
            this.displayStyleSelect.addItem(I18n.tr("vmm.latticemodel.BridgeDisplay"));
            this.displayStyleSelect.setSelectedIndex(LatticeModel.this.defaultDisplayStyle);
            this.initialShapeSelect.addItem(I18n.tr("vmm.latticeModel.SinusoidalInitialShape"));
            this.initialShapeSelect.addItem(I18n.tr("vmm.latticeModel.GaussianInitialShape"));
            this.initialShapeSelect.addItem(I18n.tr("vmm.latticeModel.ThermalInitialShape"));
            this.initialShapeSelect.addItem(I18n.tr("vmm.latticeModel.KinkInitialShape"));
            this.initialShapeSelect.addItem(I18n.tr("vmm.latticeModel.BreatherInitialShape"));
            this.initialShapeSelect.setSelectedIndex(LatticeModel.this.defaultInitialShape);
            this.initialModeSelect.addItem(I18n.tr("vmm.latticeModel.initialMode.First"));
            this.initialModeSelect.addItem(I18n.tr("vmm.latticeModel.initialMode.Second"));
            this.initialModeSelect.addItem(I18n.tr("vmm.latticeModel.initialMode.Fourth"));
            this.initialModeSelect.addItem(I18n.tr("vmm.latticeModel.initialMode.Eighth"));
            this.initialModeSelect.addItem(I18n.tr("vmm.latticeModel.initialMode.Sixteenth"));
            this.initialModeSelect.setSelectedIndex(LatticeModel.this.defaultInitialMode);
            this.boundaryConditionSelect.addItem(I18n.tr("vmm.latticeModel.ZeroBoundaryCondition"));
            this.boundaryConditionSelect.addItem(I18n.tr("vmm.latticeModel.PeriodicBoundaryCondition"));
            this.boundaryConditionSelect.setSelectedIndex(LatticeModel.this.defaultBoundaryCondition);
            this.stopAction.setEnabled(false);
            this.setEnableThreeD(false);
            this.setTransform(new LMTransform());
            this.showAxesAction.setEnabled(false);
            this.setApplyGraphics2DTransform(false);
            this.setPreserveAspect(false);
        }

        public int getNumberOfNodes() {
            int nodes = this.numberOfNodes.getValue();
            if (nodes < 3) {
                return 3;
            }
            if (nodes <= 64) {
                return nodes;
            }
            if (nodes <= 128) {
                return 128;
            }
            return 256;
        }

        public LatticeData getLatticeData() {
            if (this.latticeData == null) {
                this.latticeData = new LatticeData(this);
            }
            return this.latticeData;
        }

        public int getDisplayStyle() {
            return this.displayStyle;
        }

        public void setDisplayStyle(int displayStyle) {
            if (displayStyle < 0 || displayStyle >= this.displayStyleSelect.getItemCount()) {
                return;
            }
            if (this.displayStyle == displayStyle) {
                return;
            }
            this.displayStyle = displayStyle;
            this.displayStyleSelect.setSelectedIndex(displayStyle);
            this.forceRedraw();
            boolean is3D = displayStyle == 3 || displayStyle == 4;
            boolean changingDimension = is3D != this.getEnableThreeD();
            this.setEnableThreeD(is3D);
            if (is3D && changingDimension) {
                this.setViewStyle(1);
                this.setViewpointAction.setEnabled(false);
            }
            if (displayStyle == 0) {
                this.controlPanel.showScaleFactor(I18n.tr("vmm.latticemodel.yScaleFactor"));
            } else if (displayStyle == 5) {
                this.controlPanel.showScaleFactor(I18n.tr("vmm.latticemodel.xScaleFactor"));
            } else {
                this.controlPanel.hideScaleFactor();
            }
            if (displayStyle == 0) {
                this.controlPanel.setScaleFactor(LatticeModel.this.defaultScaleFactor);
            } else if (displayStyle == 5) {
                this.controlPanel.setScaleFactor(0.005);
            }
            if (changingDimension && this.getDisplay() != null) {
                this.getDisplay().installMouseTask(this.getDefaultMouseTask());
            }
        }

        public int getBoundaryCondition() {
            return this.boundaryCondition;
        }

        public void setBoundaryCondition(int boundaryCondition) {
            if (boundaryCondition != 0 && boundaryCondition != 1) {
                return;
            }
            if (this.boundaryCondition == boundaryCondition) {
                return;
            }
            this.boundaryCondition = boundaryCondition;
            this.boundaryConditionSelect.setSelectedIndex(boundaryCondition);
            this.initialConditionChanged();
        }

        public int getInitialShape() {
            return this.initialShape;
        }

        public void setInitialShape(int initialShape) {
            if (initialShape < 0 || initialShape >= this.initialShapeSelect.getItemCount()) {
                return;
            }
            if (this.initialShape == initialShape) {
                return;
            }
            this.initialShape = initialShape;
            this.initialShapeSelect.setSelectedIndex(initialShape);
            this.initialModeSelect.setEnabled(initialShape == 0);
            this.initialConditionChanged();
        }

        public int getInitialMode() {
            return this.initialMode;
        }

        public void setInitialMode(int initialMode) {
            if (initialMode < 0 || initialMode >= this.initialModeSelect.getItemCount()) {
                return;
            }
            if (this.initialMode == initialMode) {
                return;
            }
            this.initialMode = initialMode;
            this.initialModeSelect.setSelectedIndex(initialMode);
            this.initialConditionChanged();
        }

        @Override
        public MouseTask getDefaultMouseTask() {
            if (this.getEnableThreeD()) {
                return null;
            }
            return new LatticeMouseTask2D();
        }

        @Override
        public ActionList getActions() {
            ActionList actions = super.getActions();
            actions.add(this.stopAction);
            actions.add(this.continueAction);
            actions.add(this.stepAction);
            actions.add(null);
            ActionList boundary = new ActionList(I18n.tr("vmm.latticemodel.BoundaryCondition"));
            boundary.add(this.boundaryConditionSelect);
            actions.add(boundary);
            ActionList initialShp = new ActionList(I18n.tr("vmm.latticemodel.InitialShape"));
            initialShp.add(this.initialShapeSelect);
            actions.add(initialShp);
            ActionList initialMode = new ActionList(I18n.tr("vmm.latticemodel.InitialMode"));
            initialMode.add(this.initialModeSelect);
            actions.add(initialMode);
            actions.add(null);
            ActionList displayStyle = new ActionList(I18n.tr("vmm.latticemodel.DisplayStyle"));
            displayStyle.add(this.displayStyleSelect);
            actions.add(displayStyle);
            actions.add(null);
            if (LatticeModel.this.canShowNormalModeDisplay) {
                actions.add(this.showNormalModeToggle);
            }
            actions.add(this.showControlPanelToggle);
            return actions;
        }

        public boolean getShowControlPanel() {
            return this.showControlPanel;
        }

        public void setShowControlPanel(boolean showControlPanel) {
            if (this.showControlPanel == showControlPanel) {
                return;
            }
            this.showControlPanel = showControlPanel;
            this.showControlPanelToggle.setState(showControlPanel);
            if (showControlPanel) {
                if (this.getDisplay() != null) {
                    this.getDisplay().getHolder().add((Component)this.getControlPanel(), "East");
                    this.getDisplay().getHolder().validate();
                }
            } else if (this.getDisplay() != null && this.controlPanel != null) {
                this.getDisplay().getHolder().remove(this.controlPanel);
                this.getDisplay().getHolder().validate();
            }
        }

        public boolean getShowNormalModeDisplay() {
            return this.showNormalModeDisplay;
        }

        public void setShowNormalModeDisplay(boolean showNormalModeDisplay) {
            if (!LatticeModel.this.canShowNormalModeDisplay) {
                showNormalModeDisplay = false;
            }
            if (this.showNormalModeDisplay == showNormalModeDisplay) {
                return;
            }
            this.showNormalModeDisplay = showNormalModeDisplay;
            this.showNormalModeToggle.setState(showNormalModeDisplay);
            this.forceRedraw();
        }

        @Override
        public void parameterChanged(Parameter param, Object oldValue, Object newValue) {
            super.parameterChanged(param, oldValue, newValue);
            this.initialConditionChanged();
        }

        @Override
        public void setDisplay(Display display) {
            super.setDisplay(display);
            if (display != null) {
                display.setStopAnimationsOnResize(false);
            }
            if (display != null && this.showControlPanel) {
                display.getHolder().add((Component)this.getControlPanel(), "East");
                display.getHolder().validate();
            }
        }

        ControlPanel getControlPanel() {
            if (this.controlPanel == null) {
                this.controlPanel = new ControlPanel();
            }
            return this.controlPanel;
        }

        private void initialConditionChanged() {
            if (this.getDisplay() != null) {
                this.getDisplay().stopAnimation();
            }
            this.latticeData = null;
            this.restartAction.putValue("Name", I18n.tr("vmm.latticemodel.command.Start"));
            this.forceRedraw();
        }

        private void doRestart() {
            this.getDisplay().stopAnimation();
            this.getDisplay().installAnimation(new EvolveLattice(true));
        }

        private void doStop() {
            this.getDisplay().stopAnimation();
        }

        private void doStep() {
            LatticeData data = this.getLatticeData();
            data.stepSize = this.getControlPanel().getStepSize();
            data.step(this);
            this.forceRedraw();
        }

        private void doContinue() {
            this.getDisplay().installAnimation(new EvolveLattice(false));
        }

        protected class ControlPanel
        extends JPanel {
            JTextField stepSizeInput;
            JTextField scaleFactorInput;
            boolean scaleFactorShown = true;
            JLabel scaleFactorLabel;
            JPanel scaleFactorPanel;
            JPanel componentPanel;
            Font font;

            ControlPanel() {
                JRadioButton[] displaySelectButtons;
                this.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                this.componentPanel = new JPanel();
                this.componentPanel.setLayout(new GridLayout(0, 1));
                this.add(this.componentPanel);
                this.font = new Font("SansSerif", 1, 10);
                Font inputFont = new Font("SansSerif", 0, 10);
                JButton restartButton = new JButton(LMView.this.restartAction);
                restartButton.setFont(this.font);
                this.componentPanel.add(restartButton);
                JButton stopButton = new JButton(LMView.this.stopAction);
                stopButton.setFont(this.font);
                this.componentPanel.add(stopButton);
                JButton continueButton = new JButton(LMView.this.continueAction);
                continueButton.setFont(this.font);
                this.componentPanel.add(continueButton);
                JButton stepButton = new JButton(LMView.this.stepAction);
                stepButton.setFont(this.font);
                this.componentPanel.add(stepButton);
                this.componentPanel.add(Box.createVerticalStrut(1));
                this.stepSizeInput = new JTextField("" + LatticeModel.this.defaultStepSize, 6);
                this.stepSizeInput.setFont(inputFont);
                JLabel lbl = new JLabel(I18n.tr("vmm.latticemodel.StepSize") + "=");
                lbl.setFont(this.font);
                JPanel p = new JPanel();
                p.add(lbl);
                p.add(this.stepSizeInput);
                this.componentPanel.add(p);
                this.scaleFactorInput = new JTextField("" + LatticeModel.this.defaultScaleFactor, 5);
                this.scaleFactorInput.setFont(inputFont);
                this.scaleFactorLabel = new JLabel(I18n.tr("vmm.latticemodel.yScaleFactor") + "=");
                this.scaleFactorLabel.setFont(this.font);
                this.scaleFactorPanel = new JPanel();
                this.scaleFactorPanel.add(this.scaleFactorLabel);
                this.scaleFactorPanel.add(this.scaleFactorInput);
                this.componentPanel.add(this.scaleFactorPanel);
                for (JRadioButton rb : displaySelectButtons = LMView.this.displayStyleSelect.createRadioButtons()) {
                    rb.setFont(this.font);
                    this.componentPanel.add(rb);
                }
                this.componentPanel.add(Box.createVerticalStrut(1));
                JButton b = new JButton(I18n.tr("vmm.latticemodel.setParams"));
                b.setFont(this.font);
                this.componentPanel.add(b);
                b.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        LMView.this.getDisplay().stopAnimation();
                        Parameter[] params = LMView.this.getViewAndExhibitParameters();
                        ParameterDialog.showDialog(LMView.this.getDisplay(), I18n.tr("vmm.core.dialogtitle.SetParameters"), params);
                    }
                });
            }

            double getStepSize() {
                try {
                    double d = Double.parseDouble(this.stepSizeInput.getText().trim());
                    if (d <= 0.0) {
                        throw new NumberFormatException();
                    }
                    return d;
                }
                catch (NumberFormatException e) {
                    this.stepSizeInput.setText("" + LatticeModel.this.defaultStepSize);
                    return LatticeModel.this.defaultStepSize;
                }
            }

            double getScaleFactor() {
                try {
                    double d = Double.parseDouble(this.scaleFactorInput.getText().trim());
                    if (d <= 0.0) {
                        throw new NumberFormatException();
                    }
                    return d;
                }
                catch (NumberFormatException e) {
                    this.scaleFactorInput.setText("" + LatticeModel.this.defaultScaleFactor);
                    return LatticeModel.this.defaultScaleFactor;
                }
            }

            void setScaleFactor(double scaleFactor) {
                String str = String.format("%.4f", scaleFactor);
                this.scaleFactorInput.setText(str);
            }

            boolean isScaleFactorShown() {
                return this.scaleFactorShown;
            }

            void hideScaleFactor() {
                if (this.scaleFactorShown) {
                    this.componentPanel.remove(6);
                    this.componentPanel.add(Box.createVerticalStrut(1), 6);
                    this.scaleFactorShown = false;
                    this.validate();
                }
            }

            void showScaleFactor(String label) {
                this.scaleFactorLabel.setText(label);
                if (!this.scaleFactorShown) {
                    this.componentPanel.remove(6);
                    this.componentPanel.add((Component)this.scaleFactorPanel, 6);
                    this.scaleFactorShown = true;
                }
                this.validate();
            }
        }

        private class EvolveLattice
        extends TimerAnimation {
            boolean create;

            EvolveLattice(boolean create) {
                this.setMillisecondsPerFrame(5);
                this.create = create;
            }

            @Override
            protected void drawFrame() {
                LMView.this.doStep();
            }

            @Override
            protected void animationStarting() {
                if (this.create) {
                    LMView.this.latticeData = null;
                }
                LMView.this.continueAction.setEnabled(false);
                LMView.this.stepAction.setEnabled(false);
                LMView.this.stopAction.setEnabled(true);
                LMView.this.restartAction.putValue("Name", I18n.tr("vmm.latticemodel.command.Restart"));
            }

            @Override
            protected void animationEnding() {
                LMView.this.continueAction.setEnabled(true);
                LMView.this.stepAction.setEnabled(true);
                LMView.this.stopAction.setEnabled(false);
            }
        }

        private class LatticeMouseTask2D
        extends MouseTask {
            int startY;
            int startX;
            double initialScaleFactor;
            boolean dragging;

            private LatticeMouseTask2D() {
            }

            @Override
            public boolean doMouseDown(MouseEvent evt, Display display, View view, int width, int height) {
                if (!LMView.this.controlPanel.isScaleFactorShown()) {
                    this.dragging = false;
                    return false;
                }
                this.startX = evt.getX();
                this.startY = evt.getY();
                this.initialScaleFactor = LMView.this.controlPanel.getScaleFactor();
                this.dragging = true;
                return true;
            }

            @Override
            public void doMouseDrag(MouseEvent evt, Display display, View view, int width, int height) {
                if (!this.dragging) {
                    return;
                }
                double multiplier = Math.exp((double)(this.startY - evt.getY() + (evt.getX() - this.startX)) / 250.0);
                LMView.this.controlPanel.setScaleFactor(this.initialScaleFactor * multiplier);
                LMView.this.forceRedraw();
            }

            @Override
            public void doMouseUp(MouseEvent evt, Display display, View view, int width, int height) {
                this.dragging = false;
            }
        }
    }

    protected class LMTransform
    extends Transform3D {
        protected LMTransform() {
        }

        public void resetXYLimits(double xmin, double xmax, double ymin, double ymax) {
            this.resetLimits(xmin, xmax, ymin, ymax);
        }
    }

    protected class LatticeData {
        public double currentTime = 0.0;
        public double stepNumber = 0.0;
        int nodeCount;
        public double stepSize;
        public double density;
        public double maxDisplacement;
        public double youngsModulus;
        public double latticeLength;
        public int latticeBoundaryCondition;
        public int latticeInitialShape;
        public int latticeInitialMode;
        public double TotalModalEnergy;
        public double[] currentDisplacement = new double[513];
        public double[] currentVelocity = new double[513];
        public double[] RealNormalModeAngularFrequencies = new double[513];
        public double[] MyWaveArray = new double[513];
        public double[] MyVelocityArray = new double[513];

        private void CopyCurrentDisplacementsAndCurrentVelocitiesToMyWaveArrayAndMyVelocityArray() {
            for (int i = 1; i <= this.nodeCount; ++i) {
                this.MyWaveArray[i] = this.currentDisplacement[i];
                this.MyVelocityArray[i] = this.currentVelocity[i];
            }
        }

        private void GetRealNormalModeAngularFrequencies(LMView view) {
            double gamma = Math.sqrt(this.youngsModulus / (this.massPerNode(view) * 16.0 * this.latticeSpacing(view)));
            for (int mode = 1; mode <= this.nodeCount; ++mode) {
                this.RealNormalModeAngularFrequencies[mode] = 2.0 * gamma * Math.sin((double)mode * Math.PI / (double)(2 * this.nodeCount));
            }
        }

        private void DSTMyWaveArrayAndMyVelocityArray() {
            FourierSeries.DSTinPlace(this.MyWaveArray, this.nodeCount);
            FourierSeries.DSTinPlace(this.MyVelocityArray, this.nodeCount);
        }

        private void IDSTMyWaveArrayAndMyVelocityArray() {
            FourierSeries.IDSTinPlace(this.MyWaveArray, this.nodeCount);
            FourierSeries.IDSTinPlace(this.MyVelocityArray, this.nodeCount);
        }

        double sqr(double x) {
            return x * x;
        }

        private double PotentialEnergyOfMode(int k) {
            return 17.77 * Math.sqrt(2.0) * this.sqr(this.RealNormalModeAngularFrequencies[k]) * this.sqr(this.MyWaveArray[k]);
        }

        private double KineticEnergyOfMode(int k) {
            return 17.77 * Math.sqrt(2.0) * this.sqr(this.MyVelocityArray[k]);
        }

        private double TotalEnergyOfMode(int k) {
            return this.KineticEnergyOfMode(k) + this.PotentialEnergyOfMode(k);
        }

        private void GetLatticeModeEnergies(LMView view) {
            this.CopyCurrentDisplacementsAndCurrentVelocitiesToMyWaveArrayAndMyVelocityArray();
            this.DSTMyWaveArrayAndMyVelocityArray();
            this.GetRealNormalModeAngularFrequencies(view);
            this.TotalModalEnergy = 0.0;
            for (int i = 1; i <= this.nodeCount; ++i) {
                double TotalEnergyOfMode_i = this.KineticEnergyOfMode(i) + this.PotentialEnergyOfMode(i);
                this.TotalModalEnergy += TotalEnergyOfMode_i;
            }
        }

        public double latticeSpacing(LMView view) {
            return this.latticeLength / (double)view.getNumberOfNodes();
        }

        private double LatticeAbscissa(int NodeIndex, LMView view) {
            return (double)NodeIndex * this.latticeSpacing(view);
        }

        public double massPerNode(LMView view) {
            return this.density * this.latticeSpacing(view);
        }

        public double pulseWidth() {
            return 1.0 / Math.pow(2.0, this.latticeInitialMode);
        }

        public double waveNumber() {
            return 1.0 / (2.0 * this.pulseWidth());
        }

        private double SineWave(double x, double WaveNumber, double FundamentalLength) {
            return this.maxDisplacement * Math.sin(Math.PI * 2 * this.waveNumber() / FundamentalLength * x);
        }

        private double Breather(double x, double u) {
            return 4.0 * Math.atan(Math.sqrt(1.0 - u * u) / u * (1.0 / Math.cosh(Math.sqrt(1.0 - u * u) * x)));
        }

        private double Kink(double s, double u) {
            return 4.0 * Math.atan(Math.exp(s / Math.sqrt(1.0 - u * u)));
        }

        private double Gaussian(double x, double sigma) {
            return 1.0 / (sigma * Math.sqrt(Math.PI * 2)) * Math.exp(-(x * x / (sigma * sigma)));
        }

        private double shapeFunction(double x, double sigma, double u) {
            switch (this.latticeInitialShape) {
                case 0: {
                    return Math.sqrt(2.0) * this.SineWave(x, this.waveNumber(), this.latticeLength);
                }
                case 1: {
                    return this.Gaussian(x, sigma);
                }
                case 2: {
                    return 0.0;
                }
                case 3: {
                    return this.Kink(x, u);
                }
                case 4: {
                    return this.Breather(x, u);
                }
            }
            return 0.0;
        }

        private void InitializeDisplacementsAndVelocities(LMView view) {
            for (int i = 1; i <= view.getNumberOfNodes(); ++i) {
                this.currentVelocity[i] = 0.0;
                this.currentDisplacement[i] = this.shapeFunction(this.LatticeAbscissa(i, view), 1.0, 1.0);
                this.currentVelocity[0] = 0.0;
                this.currentDisplacement[0] = this.currentDisplacement[view.getNumberOfNodes()];
            }
        }

        public LatticeData(LMView view) {
            this.nodeCount = view.getNumberOfNodes();
            this.density = view.latticeDensity.getValue();
            this.maxDisplacement = view.amplitude.getValue();
            this.youngsModulus = 1.0;
            this.latticeLength = view.latticeLength.getValue();
            this.latticeBoundaryCondition = view.getBoundaryCondition();
            this.latticeInitialShape = view.getInitialShape();
            this.latticeInitialMode = view.getInitialMode();
            this.InitializeDisplacementsAndVelocities(view);
        }

        private int NextNodeIndex(int i, int numNodes) {
            if (i >= numNodes || i < 0) {
                return 0;
            }
            return i + 1;
        }

        private double PotentialEnergyOfSpring(LMView view, int node) {
            return LatticeModel.this.potentialEnergy(this.currentDisplacement[this.NextNodeIndex(node, this.nodeCount)] - this.currentDisplacement[node], this.latticeSpacing(view));
        }

        private double KineticEnergyOfNode(LMView view, int node) {
            return 0.5 * this.massPerNode(view) * this.currentVelocity[node] * this.currentVelocity[node];
        }

        private double LatticeTotalKineticEnergy(LMView view) {
            double KE = 0.0;
            for (int node = 1; node <= this.nodeCount; ++node) {
                KE += this.KineticEnergyOfNode(view, node);
            }
            return KE;
        }

        private double LatticeTotalPotentialEnergy(LMView view) {
            double PE = 0.0;
            for (int spring = 0; spring <= this.nodeCount; ++spring) {
                PE += this.PotentialEnergyOfSpring(view, spring);
            }
            return PE;
        }

        protected double LatticeTotalEnergy(LMView view) {
            return this.LatticeTotalPotentialEnergy(view) + this.LatticeTotalKineticEnergy(view);
        }

        private double Acceleration(LMView view, int theNode, double PreviousNodeDisplacement, double theNodeDisplacement, double NextNodeDisplacement) {
            if (this.latticeBoundaryCondition == 0 & (theNode == 0 || theNode == this.nodeCount)) {
                return 0.0;
            }
            double internalForce = LatticeModel.this.internalForceLaw(theNodeDisplacement - PreviousNodeDisplacement, this.latticeSpacing(view)) - LatticeModel.this.internalForceLaw(NextNodeDisplacement - theNodeDisplacement, this.latticeSpacing(view));
            double externalForce = LatticeModel.this.externalForceLaw(theNodeDisplacement, this.latticeSpacing(view));
            double totalForce = internalForce + externalForce;
            return totalForce / this.massPerNode(view);
        }

        protected void RungeKuttaLattice(double[] x0, double[] u0, LMView view) {
            int i;
            double h = this.stepSize;
            double[] h1 = new double[this.nodeCount + 1];
            double[] k1 = new double[this.nodeCount + 1];
            double[] h2 = new double[this.nodeCount + 1];
            double[] k2 = new double[this.nodeCount + 1];
            double[] h3 = new double[this.nodeCount + 1];
            double[] k3 = new double[this.nodeCount + 1];
            double[] h4 = new double[this.nodeCount + 1];
            double[] k4 = new double[this.nodeCount + 1];
            for (i = 1; i <= this.nodeCount; ++i) {
                h1[i] = h * u0[i];
                k1[i] = h * this.Acceleration(view, i, x0[i - 1], x0[i], x0[this.NextNodeIndex(i, this.nodeCount)]);
            }
            h1[0] = h1[this.nodeCount];
            k1[0] = k1[this.nodeCount];
            for (i = 1; i <= this.nodeCount; ++i) {
                h2[i] = h * (u0[i] + k1[i] / 2.0);
                k2[i] = h * this.Acceleration(view, i, x0[i - 1] + h1[i - 1] / 2.0, x0[i] + h1[i] / 2.0, x0[this.NextNodeIndex(i, this.nodeCount)] + h1[this.NextNodeIndex(i, this.nodeCount)] / 2.0);
            }
            h2[0] = h2[this.nodeCount];
            k2[0] = k2[this.nodeCount];
            for (i = 1; i <= this.nodeCount; ++i) {
                h3[i] = h * (u0[i] + k2[i] / 2.0);
                k3[i] = h * this.Acceleration(view, i, x0[i - 1] + h2[i - 1] / 2.0, x0[i] + h2[i] / 2.0, x0[this.NextNodeIndex(i, this.nodeCount)] + h2[this.NextNodeIndex(i, this.nodeCount)] / 2.0);
            }
            h3[0] = h3[this.nodeCount];
            k3[0] = k3[this.nodeCount];
            for (i = 1; i <= this.nodeCount; ++i) {
                h4[i] = h * (u0[i] + k3[i]);
                k4[i] = h * this.Acceleration(view, i, x0[i - 1] + h3[i - 1], x0[i] + h3[i], x0[this.NextNodeIndex(i, this.nodeCount)] + h3[this.NextNodeIndex(i, this.nodeCount)]);
            }
            h4[0] = h4[this.nodeCount];
            k4[0] = k4[this.nodeCount];
            for (i = 0; i <= this.nodeCount; ++i) {
                x0[i] = x0[i] + h1[i] / 6.0 + h2[i] / 3.0 + h3[i] / 3.0 + h4[i] / 6.0;
                u0[i] = u0[i] + k1[i] / 6.0 + k2[i] / 3.0 + k3[i] / 3.0 + k4[i] / 6.0;
            }
        }

        public void step(LMView view) {
            LatticeModel.this.numIterations = 3;
            for (int i = 0; i < LatticeModel.this.numIterations; ++i) {
                this.RungeKuttaLattice(this.currentDisplacement, this.currentVelocity, view);
                this.currentTime += this.stepSize;
            }
            this.stepNumber += 1.0;
        }
    }
}

