/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import vmm.core.I18n;
import vmm.core.ParameterInput;
import vmm.core.Prefs;
import vmm.core.RealParam;
import vmm.core.SettingsDialog;
import vmm.core3D.View3D;

public class Set3DViewOptionsDialog
extends SettingsDialog {
    private View3D view;
    private RealParam multiplier;
    private ParameterInput input;
    private double originalVal;
    private JRadioButton alwaysAnaglyphButton;
    private JRadioButton neverAnaglyphButton;
    private JRadioButton defaultAnaglyphButton;
    private String originalAnaglyph;
    private JCheckBox moveObjectsForwardInAnaglyphToggle;
    private boolean originalMoveObjectsForwardInAnaglyph;

    public static void showDialog(View3D view) {
        new Set3DViewOptionsDialog(view).setVisible(true);
    }

    private Set3DViewOptionsDialog(View3D view) {
        super(view.getDisplay(), I18n.tr("vmm.core3D.commands.SetEyeSep"));
        this.view = view;
        this.originalVal = Prefs.getDouble("eyeSeparationMultiplier", 1.0);
        this.multiplier = new RealParam(I18n.tr("vmm.core3D.SetEyeSepDialog.EyeSep"), this.originalVal);
        this.multiplier.setDefaultValue(1.0);
        this.multiplier.setMinimumValueForInput(0.1);
        this.multiplier.setMaximumValueForInput(10.0);
        this.input = new ParameterInput(this.multiplier);
        this.input.setColumns(5);
        Box inputPanel = Box.createVerticalBox();
        inputPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        Box eyeSepInput = Box.createVerticalBox();
        Box viewModeInput = Box.createVerticalBox();
        Box anaglyphPositioningInput = Box.createVerticalBox();
        eyeSepInput.setAlignmentX(0.0f);
        viewModeInput.setAlignmentX(0.0f);
        inputPanel.add(eyeSepInput);
        inputPanel.add(Box.createVerticalStrut(12));
        inputPanel.add(viewModeInput);
        inputPanel.add(Box.createVerticalStrut(12));
        inputPanel.add(anaglyphPositioningInput);
        eyeSepInput.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.SetEyeSepMul")), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        viewModeInput.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.SetViewModePref")), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        anaglyphPositioningInput.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.SetAnaglyphObjectPosition")), BorderFactory.createEmptyBorder(8, 8, 8, 8)));
        JLabel labl = new JLabel(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.EyeSep.info"));
        labl.setAlignmentX(0.0f);
        eyeSepInput.add(labl);
        viewModeInput.add(Box.createVerticalStrut(18));
        JPanel temp = new JPanel();
        labl = new JLabel(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.EyeSepMul") + " = ");
        labl.setAlignmentX(0.0f);
        temp.add(labl);
        eyeSepInput.add(temp);
        temp.add(this.input);
        temp.setAlignmentX(0.0f);
        this.originalAnaglyph = Prefs.get("view3d.initialAnaglyphMode", "default");
        this.alwaysAnaglyphButton = new JRadioButton(I18n.tr("vmm.core3D.SetAnaglyphDefaultMode.always"));
        this.neverAnaglyphButton = new JRadioButton(I18n.tr("vmm.core3D.SetAnaglyphDefaultMode.never"));
        this.defaultAnaglyphButton = new JRadioButton(I18n.tr("vmm.core3D.SetAnaglyphDefaultMode.default"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.alwaysAnaglyphButton);
        group.add(this.neverAnaglyphButton);
        group.add(this.defaultAnaglyphButton);
        if (this.originalAnaglyph.equalsIgnoreCase("always")) {
            this.alwaysAnaglyphButton.setSelected(true);
        } else if (this.originalAnaglyph.equalsIgnoreCase("never")) {
            this.neverAnaglyphButton.setSelected(true);
        } else {
            this.defaultAnaglyphButton.setSelected(true);
        }
        labl = new JLabel(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.AnaglyphPref.info"));
        viewModeInput.add(labl);
        viewModeInput.add(Box.createVerticalStrut(12));
        viewModeInput.add(this.defaultAnaglyphButton);
        viewModeInput.add(this.alwaysAnaglyphButton);
        viewModeInput.add(this.neverAnaglyphButton);
        this.moveObjectsForwardInAnaglyphToggle = new JCheckBox(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.AnaglyphPositionOption"));
        this.originalMoveObjectsForwardInAnaglyph = "yes".equals(Prefs.get("view3d.moveObjectsForwardInAnaglyph"));
        this.moveObjectsForwardInAnaglyphToggle.setSelected(this.originalMoveObjectsForwardInAnaglyph);
        anaglyphPositioningInput.add(Box.createVerticalStrut(2));
        anaglyphPositioningInput.add(this.moveObjectsForwardInAnaglyphToggle);
        this.addInfoLabel(I18n.tr("vmm.core3D.Set3DViewOptionsDialog.info"));
        this.addInputPanel(inputPanel);
    }

    @Override
    protected boolean doOK() {
        String error = this.input.checkContents();
        if (error != null) {
            JOptionPane.showMessageDialog(this, error, I18n.tr("vmm.core.SettingsDialog.errorTitle"), 0);
            return false;
        }
        this.input.setValueFromContents();
        double sep = this.multiplier.getValue();
        if (sep != this.originalVal) {
            Prefs.putDouble("eyeSeparationMultiplier", sep);
            if (this.view.getViewStyle() == 1 || this.view.getViewStyle() == 2 || this.view.getViewStyle() == 3) {
                this.view.forceRedraw();
            }
        }
        if (this.defaultAnaglyphButton.isSelected()) {
            Prefs.put("view3d.initialAnaglyphMode", "default");
        } else if (this.alwaysAnaglyphButton.isSelected()) {
            if (this.view.getViewStyle() == 0) {
                this.view.setViewStyle(1);
            }
            Prefs.put("view3d.initialAnaglyphMode", "always");
        } else if (this.neverAnaglyphButton.isSelected()) {
            if (this.view.getViewStyle() == 1) {
                this.view.setViewStyle(0);
            }
            Prefs.put("view3d.initialAnaglyphMode", "never");
        }
        if (this.moveObjectsForwardInAnaglyphToggle.isSelected()) {
            if (this.view.getViewStyle() == 1 && this.view.getTransform3D() != null) {
                double extent = Math.max(this.view.getTransform3D().getXmaxRequested() - this.view.getTransform3D().getXminRequested(), this.view.getTransform3D().getYmaxRequested() - this.view.getTransform3D().getYminRequested());
                this.view.getTransform3D().setObjectDisplacementNormalToScreen(extent / 3.0);
            }
            Prefs.put("view3d.moveObjectsForwardInAnaglyph", "yes");
        } else {
            if (this.view.getViewStyle() == 1 && this.view.getTransform3D() != null) {
                this.view.getTransform3D().setObjectDisplacementNormalToScreen(0.0);
            }
            Prefs.put("view3d.moveObjectsForwardInAnaglyph", "no");
        }
        return true;
    }

    @Override
    protected void doDefaults() {
        this.input.defaultVal();
        this.defaultAnaglyphButton.setSelected(true);
        this.moveObjectsForwardInAnaglyphToggle.setSelected(false);
    }
}

