/*
 * Decompiled with CFR 0.152.
 */
package vmm.core3D;

import java.awt.Graphics2D;
import vmm.core.Exhibit;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;
import vmm.core3D.Transform3D;
import vmm.core3D.Vector3D;
import vmm.core3D.View3D;

public abstract class Exhibit3D
extends Exhibit {
    protected Transform3D previousTransform3D;
    @VMMSave
    protected Vector3D defaultViewpoint = new Vector3D(20.0, 0.0, 0.0);
    @VMMSave
    protected Vector3D defaultViewUp = null;

    @Override
    public Transform getDefaultTransform(View view) {
        double[] window = this.getDefaultWindow();
        if (view instanceof View3D) {
            Transform3D tr = new Transform3D(this.defaultViewpoint, window[0], window[1], window[2], window[3]);
            if (this.defaultViewUp != null) {
                tr.setImagePlaneYDirection(this.defaultViewUp);
            }
            return tr;
        }
        return new Transform(window[0], window[1], window[2], window[3]);
    }

    @Override
    public View getDefaultView() {
        return new View3D();
    }

    public Vector3D getDefaultViewpoint() {
        return this.defaultViewpoint;
    }

    public void setDefaultViewpoint(Vector3D defaultViewpoint) {
        this.defaultViewpoint = defaultViewpoint == null ? new Vector3D(20.0, 0.0, 0.0) : defaultViewpoint;
    }

    public Vector3D getDefaultViewUp() {
        return this.defaultViewpoint;
    }

    public void setDefaultViewUp(Vector3D defaultViewUp) {
        this.defaultViewUp = defaultViewUp;
    }

    @Override
    protected void computeDrawDataHook(View view, Transform transform) {
        if (view instanceof View3D && transform instanceof Transform3D) {
            this.computeDrawData3D((View3D)view, this.exhibitNeedsRedraw, this.previousTransform3D, (Transform3D)transform);
            this.previousTransform3D = (Transform3D)transform.clone();
        } else {
            this.computeDrawData(view, this.exhibitNeedsRedraw, this.previousTransform, transform);
            this.previousTransform = (Transform)transform.clone();
        }
    }

    @Override
    protected void doDrawHook(Graphics2D g, View view, Transform transform) {
        if (view instanceof View3D && transform instanceof Transform3D) {
            this.doDraw3D(g, (View3D)view, (Transform3D)transform);
        } else {
            this.doDraw(g, view, transform);
        }
    }

    protected void computeDrawData3D(View3D view, boolean exhibitNeedsRedraw, Transform3D previousTransform3D, Transform3D newTransform3D) {
    }

    protected void doDraw3D(Graphics2D g, View3D view, Transform3D transform) {
    }
}

