/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import javax.swing.JTextField;
import vmm.core.Animateable;
import vmm.core.Complex;
import vmm.core.ComplexParam;
import vmm.core.I18n;
import vmm.core.IntegerParam;
import vmm.core.Parameter;
import vmm.core.RealParam;
import vmm.core.RealParamAnimateable;
import vmm.functions.ParseError;
import vmm.functions.Parser;

public class ParameterInput
extends JTextField {
    private Parameter param;
    private int inputType;
    private String originalString;
    private static Parser parser = new Parser();
    public static final int VALUE = 0;
    public static final int ANIMATION_START = 1;
    public static final int ANIMATION_END = 2;

    public ParameterInput(Parameter param) {
        this(param, 0);
    }

    public ParameterInput(Parameter param, int propertyToInput) {
        super(12);
        this.param = param;
        if (param instanceof Animateable) {
            this.inputType = propertyToInput;
            if (this.inputType != 0 && this.inputType != 2 && this.inputType != 1) {
                this.inputType = 0;
            }
            switch (this.inputType) {
                case 0: {
                    this.originalString = param.getValueAsString();
                    break;
                }
                case 1: {
                    this.originalString = ((Animateable)((Object)param)).getAnimationStartAsString();
                    break;
                }
                default: {
                    this.originalString = ((Animateable)((Object)param)).getAnimationEndAsString();
                    break;
                }
            }
        } else {
            this.inputType = 0;
            this.originalString = param.getValueAsString();
        }
        this.setText(this.originalString);
        String tooltip = null;
        if (param instanceof IntegerParam) {
            tooltip = "<html>" + I18n.tr("vmm.core.ParameterInput.isInteger");
            int min = ((IntegerParam)param).getMinimumValueForInput();
            int max = ((IntegerParam)param).getMaximumValueForInput();
            if (max == Integer.MAX_VALUE) {
                if (min == 1) {
                    tooltip = tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.positive");
                } else if (min == 0) {
                    tooltip = tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.nonnegative");
                } else if (min > Integer.MIN_VALUE) {
                    tooltip = tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.greater", min);
                }
            } else {
                tooltip = min == Integer.MIN_VALUE ? tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.less", max) : tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.range", min, max);
            }
        } else if (param instanceof RealParam) {
            tooltip = "<html>" + I18n.tr("vmm.core.ParameterInput.isReal");
            double min = ((RealParam)param).getMinimumValueForInput();
            double max = ((RealParam)param).getMaximumValueForInput();
            if (max == Double.POSITIVE_INFINITY) {
                if (min == Double.MIN_VALUE) {
                    tooltip = tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.positive");
                } else if (min == 0.0) {
                    tooltip = tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.nonnegative");
                } else if (min > Double.NEGATIVE_INFINITY) {
                    tooltip = tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.greater", min);
                }
            } else {
                tooltip = min == Double.NEGATIVE_INFINITY ? tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.less", max) : tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.range", min, max);
            }
        } else if (param instanceof ComplexParam) {
            tooltip = "<html>" + I18n.tr("vmm.core.ParameterInput.isComplex");
            Complex min = ((ComplexParam)param).getMinimumValueForInput();
            Complex max = ((ComplexParam)param).getMaximumValueForInput();
            if (min.re == Double.NEGATIVE_INFINITY && max.re < Double.POSITIVE_INFINITY) {
                tooltip = tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.less.realpart", max.re);
            } else if (min.re > Double.NEGATIVE_INFINITY && max.re == Double.POSITIVE_INFINITY) {
                tooltip = tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.greater.realpart", min.re);
            } else if (min.re > Double.NEGATIVE_INFINITY && max.re < Double.POSITIVE_INFINITY) {
                tooltip = tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.range.realpart", min.re, max.re);
            }
            if (min.im == Double.NEGATIVE_INFINITY && max.im < Double.POSITIVE_INFINITY) {
                tooltip = tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.less.imaginarypart", max.im);
            } else if (min.im > Double.NEGATIVE_INFINITY && max.im == Double.POSITIVE_INFINITY) {
                tooltip = tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.greater.imaginarypart", min.im);
            } else if (min.im > Double.NEGATIVE_INFINITY && max.im < Double.POSITIVE_INFINITY) {
                tooltip = tooltip + "<br>" + I18n.tr("vmm.core.ParameterInput.range.imaginarypart", min.im, max.im);
            }
        }
        this.setToolTipText(tooltip);
    }

    @Override
    public void setColumns(int columns) {
        double value;
        super.setColumns(columns);
        String content = this.getText();
        if (content.length() < columns || !content.equals(this.originalString) || !(this.param instanceof RealParam)) {
            return;
        }
        switch (this.inputType) {
            case 0: {
                value = ((RealParam)this.param).getValue();
                break;
            }
            case 1: {
                value = ((RealParamAnimateable)this.param).getAnimationStart();
                break;
            }
            default: {
                value = ((RealParamAnimateable)this.param).getAnimationEnd();
            }
        }
        String str = String.format("%" + columns + "g", value);
        this.setText(str);
        this.originalString = str;
    }

    public Parameter getParameter() {
        return this.param;
    }

    public String checkContents() {
        String contents = this.getText();
        double val = 0.0;
        Complex cval = null;
        try {
            if (this.param instanceof ComplexParam) {
                cval = parser.parseComplexExpression(contents).value();
            } else {
                val = parser.parse(contents).value();
            }
        }
        catch (ParseError e) {
            this.requestFocus();
            this.selectAll();
            if (this.inputType == 0) {
                return I18n.tr("vmm.core.ParameterInput.badExpression", this.param.getTitle(), contents, e.getMessage());
            }
            if (this.inputType == 1) {
                return I18n.tr("vmm.core.ParameterInput.badStartExpression", this.param.getTitle(), contents, e.getMessage());
            }
            return I18n.tr("vmm.core.ParameterInput.badEndExpression", this.param.getTitle(), contents, e.getMessage());
        }
        if (cval == null && (Double.isNaN(val) || Double.isInfinite(val)) || cval != null && (Double.isNaN(cval.re) || Double.isInfinite(cval.re) || Double.isNaN(cval.im) || Double.isInfinite(cval.im))) {
            this.requestFocus();
            this.selectAll();
            if (this.inputType == 0) {
                return I18n.tr("vmm.core.ParameterInput.undefinedExpression", this.param.getTitle(), contents);
            }
            if (this.inputType == 1) {
                return I18n.tr("vmm.core.ParameterInput.undefinedStartExpression", this.param.getTitle(), contents);
            }
            return I18n.tr("vmm.core.ParameterInput.undefinedEndExpression", this.param.getTitle(), contents);
        }
        if (this.param instanceof IntegerParam) {
            IntegerParam intParam = (IntegerParam)this.param;
            int intval = val > 0.0 ? (int)(val + 1.0E-8) : (int)(val - 1.0E-8);
            if (Math.abs(val - (double)intval) > 5.0E-9) {
                this.requestFocus();
                this.selectAll();
                return I18n.tr("vmm.core.ParameterInput.badint", this.param.getTitle());
            }
            if (intval < intParam.getMinimumValueForInput() || intval > intParam.getMaximumValueForInput()) {
                this.requestFocus();
                this.selectAll();
                return I18n.tr("vmm.core.ParameterInput.intOutOfRange", this.param.getTitle(), "" + intParam.getMinimumValueForInput(), "" + intParam.getMaximumValueForInput());
            }
        } else if (this.param instanceof RealParam) {
            RealParam realParam = (RealParam)this.param;
            if (val < realParam.getMinimumValueForInput() || val > realParam.getMaximumValueForInput()) {
                this.requestFocus();
                this.selectAll();
                if (realParam.getMinimumValueForInput() == Double.MIN_VALUE) {
                    if (realParam.getMaximumValueForInput() == Double.POSITIVE_INFINITY) {
                        return I18n.tr("vmm.core.ParameterInput.rangeError1", this.param.getTitle());
                    }
                    return I18n.tr("vmm.core.ParameterInput.rangeError2", this.param.getTitle(), "" + realParam.getMaximumValueForInput());
                }
                if (realParam.getMaximumValueForInput() == Double.POSITIVE_INFINITY) {
                    return I18n.tr("vmm.core.ParameterInput.rangeError3", this.param.getTitle(), "" + realParam.getMinimumValueForInput());
                }
                if (realParam.getMinimumValueForInput() == Double.NEGATIVE_INFINITY) {
                    return I18n.tr("vmm.core.ParameterInput.rangeError4", this.param.getTitle(), "" + realParam.getMaximumValueForInput());
                }
                return I18n.tr("vmm.core.ParameterInput.rangeError5", this.param.getTitle(), "" + realParam.getMinimumValueForInput(), "" + realParam.getMaximumValueForInput());
            }
        } else if (this.param instanceof ComplexParam) {
            ComplexParam realParam = (ComplexParam)this.param;
            if (cval.re < realParam.getMinimumValueForInput().re || cval.re > realParam.getMaximumValueForInput().re || cval.im < realParam.getMinimumValueForInput().im || cval.im > realParam.getMaximumValueForInput().im) {
                this.requestFocus();
                this.selectAll();
                return I18n.tr("vmm.core.ParameterInput.rangeErrorComplex");
            }
        }
        return null;
    }

    public void setValueFromContents() {
        String contents = this.getText();
        if (contents.equals(this.originalString)) {
            return;
        }
        try {
            switch (this.inputType) {
                case 0: {
                    this.param.setValueFromString(contents);
                    break;
                }
                case 1: {
                    ((Animateable)((Object)this.param)).setAnimationStartFromString(contents);
                    break;
                }
                default: {
                    ((Animateable)((Object)this.param)).setAnimationEndFromString(contents);
                }
            }
            this.originalString = contents;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setValueAndDefaultFromContents() {
        String contents = this.getText();
        if (contents.equals(this.originalString)) {
            return;
        }
        try {
            switch (this.inputType) {
                case 0: {
                    this.param.setValueAndDefaultFromString(contents);
                    break;
                }
                case 1: {
                    ((Animateable)((Object)this.param)).setAnimationStartFromString(contents);
                    ((Animateable)((Object)this.param)).setDefaultAnimationStartFromString(contents);
                    break;
                }
                default: {
                    ((Animateable)((Object)this.param)).setAnimationEndFromString(contents);
                    ((Animateable)((Object)this.param)).setDefaultAnimationEndFromString(contents);
                }
            }
            this.originalString = contents;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void revert() {
        this.setText(this.originalString);
    }

    public void defaultVal() {
        switch (this.inputType) {
            case 0: {
                this.setText(this.param.getDefaultValueAsString());
                break;
            }
            case 1: {
                this.setText(((Animateable)((Object)this.param)).getDefaultAnimationStartAsString());
                break;
            }
            default: {
                this.setText(((Animateable)((Object)this.param)).getDefaultAnimationEndAsString());
            }
        }
    }
}

