/*
 * Decompiled with CFR 0.152.
 */
package vmm.core;

import java.awt.Color;
import java.awt.Graphics2D;
import vmm.core.Decoration;
import vmm.core.Transform;
import vmm.core.VMMSave;
import vmm.core.View;

public class Axes2D
extends Decoration {
    @VMMSave
    private Color color = Color.gray;

    public Axes2D() {
        this.setLayer(-100);
    }

    public void setColor(Color c) {
        this.color = c == null ? Color.gray : c;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void doDraw(Graphics2D g, View view, Transform transform) {
        Color saveColor = g.getColor();
        g.setColor(this.color);
        if (this.between(0.0, transform.getYmin(), transform.getYmax())) {
            view.drawLine(transform.getXmin(), 0.0, transform.getXmax(), 0.0);
        }
        if (this.between(0.0, transform.getXmin(), transform.getYmax())) {
            view.drawLine(0.0, transform.getYmax(), 0.0, transform.getYmin());
        }
        g.setColor(saveColor);
    }

    private boolean between(double x, double x1, double x2) {
        if (x <= x1 && x >= x2) {
            return true;
        }
        return x >= x1 && x <= x2;
    }
}

