/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.tool;

import ij.IJ;
import ij.ImagePlus;
import ij.Prefs;
import ij.Undo;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageRoi;
import ij.gui.NonBlockingGenericDialog;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.plugin.Colors;
import ij.plugin.tool.PlugInTool;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.AWTEvent;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class BrushTool
extends PlugInTool
implements Runnable {
    private static final int UNCONSTRAINED = 0;
    private static final int HORIZONTAL = 1;
    private static final int VERTICAL = 2;
    private static final int RESIZING = 3;
    private static final int RESIZED = 4;
    private static final int IDLE = 5;
    private static String BRUSH_WIDTH_KEY = "brush.width";
    private static String PENCIL_WIDTH_KEY = "pencil.width";
    private static String CIRCLE_NAME = "brush-tool-overlay";
    private static final String LOC_KEY = "brush.loc";
    private String widthKey;
    private int width;
    private ImageProcessor ip;
    private int mode;
    private int xStart;
    private int yStart;
    private int oldWidth;
    private boolean isPencil;
    private Overlay overlay;
    private Options options;
    private GenericDialog gd;
    private ImageRoi overlayImage;
    private boolean paintOnOverlay;
    private static BrushTool brushInstance;

    @Override
    public void run(String arg) {
        this.isPencil = "pencil".equals(arg);
        this.widthKey = this.isPencil ? PENCIL_WIDTH_KEY : BRUSH_WIDTH_KEY;
        this.width = (int)Prefs.get(this.widthKey, this.isPencil ? 1.0 : 5.0);
        Toolbar.addPlugInTool(this);
        if (!this.isPencil) {
            brushInstance = this;
        }
    }

    @Override
    public void mousePressed(ImagePlus imp, MouseEvent e) {
        ImageCanvas ic = imp.getCanvas();
        int x = ic.offScreenX(e.getX());
        int y = ic.offScreenY(e.getY());
        this.xStart = x;
        this.yStart = y;
        this.checkForOverlay(imp);
        this.ip = this.overlayImage != null ? this.overlayImage.getProcessor() : imp.getProcessor();
        int ctrlMask = IJ.isMacintosh() ? 4 : 2;
        int resizeMask = 1 | ctrlMask;
        if ((e.getModifiers() & resizeMask) == resizeMask) {
            this.mode = 3;
            this.oldWidth = this.width;
            return;
        }
        if ((e.getModifiers() & ctrlMask) != 0) {
            boolean altKeyDown = (e.getModifiers() & 8) != 0;
            ic.setDrawingColor(x, y, altKeyDown);
            if (!altKeyDown) {
                this.setColor(Toolbar.getForegroundColor());
            }
            this.mode = 5;
            return;
        }
        this.mode = 0;
        this.ip.snapshot();
        Undo.setup(1, imp);
        this.ip.setLineWidth(this.width);
        if (e.isAltDown()) {
            if (this.overlayImage != null) {
                this.ip.setColor(0);
            } else {
                this.ip.setColor(Toolbar.getBackgroundColor());
            }
        } else {
            this.ip.setColor(Toolbar.getForegroundColor());
        }
        this.ip.moveTo(x, y);
        if (!e.isShiftDown()) {
            this.ip.lineTo(x, y);
            if (this.overlayImage != null) {
                this.overlayImage.setProcessor(this.ip);
                imp.draw();
            } else {
                imp.updateAndDraw();
            }
        }
    }

    private void checkForOverlay(ImagePlus imp) {
        if (this.paintOnOverlay && (this.overlayImage == null || this.getOverlayImage(imp) == null)) {
            ColorProcessor overlayIP = new ColorProcessor(imp.getWidth(), imp.getHeight());
            ImageRoi imageRoi = new ImageRoi(0, 0, overlayIP);
            imageRoi.setZeroTransparent(true);
            Overlay overlay = new Overlay(imageRoi);
            imp.setOverlay(overlay);
            this.overlayImage = imageRoi;
            return;
        }
        this.overlayImage = null;
        if (!this.paintOnOverlay) {
            return;
        }
        this.overlayImage = this.getOverlayImage(imp);
    }

    private ImageRoi getOverlayImage(ImagePlus imp) {
        Roi roi;
        Overlay overlay = imp.getOverlay();
        if (overlay == null) {
            return null;
        }
        Roi roi2 = roi = overlay.size() > 0 ? overlay.get(0) : null;
        if (roi == null || !(roi instanceof ImageRoi)) {
            return null;
        }
        Rectangle bounds = roi.getBounds();
        if (bounds.x != 0 || bounds.y != 0 || bounds.width != imp.getWidth() || bounds.height != imp.getHeight()) {
            return null;
        }
        return (ImageRoi)roi;
    }

    @Override
    public void mouseDragged(ImagePlus imp, MouseEvent e) {
        if (this.mode == 5) {
            return;
        }
        ImageCanvas ic = imp.getCanvas();
        int x = ic.offScreenX(e.getX());
        int y = ic.offScreenY(e.getY());
        if (this.mode == 3) {
            this.showToolSize(x - this.xStart, imp);
            return;
        }
        if ((e.getModifiers() & 1) != 0) {
            if (this.mode == 0) {
                if (Math.abs(x - this.xStart) > Math.abs(y - this.yStart)) {
                    this.mode = 1;
                } else if (Math.abs(x - this.xStart) < Math.abs(y - this.yStart)) {
                    this.mode = 2;
                } else {
                    return;
                }
            }
            if (this.mode == 1) {
                y = this.yStart;
            } else if (this.mode == 2) {
                x = this.xStart;
            }
        } else {
            this.xStart = x;
            this.yStart = y;
            this.mode = 0;
        }
        this.ip.setLineWidth(this.width);
        this.ip.lineTo(x, y);
        if (this.overlayImage != null) {
            this.overlayImage.setProcessor(this.ip);
            imp.draw();
        } else {
            imp.updateAndDraw();
        }
    }

    @Override
    public void mouseReleased(ImagePlus imp, MouseEvent e) {
        if (this.mode == 3) {
            if (this.overlay != null && this.overlay.size() > 0 && CIRCLE_NAME.equals(this.overlay.get(this.overlay.size() - 1).getName())) {
                this.overlay.remove(this.overlay.size() - 1);
                imp.setOverlay(this.overlay);
            }
            this.overlay = null;
            if (e.isShiftDown()) {
                this.setWidth(this.width);
                Prefs.set(this.widthKey, this.width);
            }
        }
    }

    private void setWidth(int width) {
        if (this.gd == null) {
            return;
        }
        Vector numericFields = this.gd.getNumericFields();
        TextField widthField = (TextField)numericFields.elementAt(0);
        widthField.setText("" + width);
        Vector sliders = this.gd.getSliders();
        Scrollbar sb = (Scrollbar)sliders.elementAt(0);
        sb.setValue(width);
    }

    private void setColor(Color c) {
        if (this.gd == null) {
            return;
        }
        String name = Colors.colorToString2(c);
        if (name.length() > 0) {
            Vector choices = this.gd.getChoices();
            Choice ch = (Choice)choices.elementAt(0);
            ch.select(name);
        }
    }

    private void showToolSize(int deltaWidth, ImagePlus imp) {
        if (deltaWidth != 0) {
            this.width = this.oldWidth + deltaWidth;
            if (this.width < 1) {
                this.width = 1;
            }
            OvalRoi circle = new OvalRoi(this.xStart - this.width / 2, this.yStart - this.width / 2, this.width, this.width);
            circle.setName(CIRCLE_NAME);
            circle.setStrokeColor(Color.red);
            this.overlay = imp.getOverlay();
            if (this.overlay == null) {
                this.overlay = new Overlay();
            } else if (this.overlay.size() > 0 && CIRCLE_NAME.equals(this.overlay.get(this.overlay.size() - 1).getName())) {
                this.overlay.remove(this.overlay.size() - 1);
            }
            this.overlay.add(circle);
            imp.setOverlay(this.overlay);
        }
        IJ.showStatus((this.isPencil ? "Pencil" : "Brush") + " width: " + this.width);
    }

    @Override
    public void showOptionsDialog() {
        Thread thread = new Thread((Runnable)this, "Brush Options");
        thread.setPriority(5);
        thread.start();
    }

    @Override
    public String getToolName() {
        if (this.isPencil) {
            return "Pencil Tool";
        }
        return "Paintbrush Tool";
    }

    @Override
    public String getToolIcon() {
        if (this.isPencil) {
            return "C037L4990L90b0Lc1c3L82a4Lb58bL7c4fDb4L494fC123L5a5dL6b6cD7b";
        }
        return "C037La077Ld098L6859L4a2fL2f4fL5e9bL9b98L6888L5e8dL888cC123L8a3fL8b6d";
    }

    @Override
    public void run() {
        new Options();
    }

    public static void setBrushWidth(int width) {
        if (brushInstance != null) {
            Color c = Toolbar.getForegroundColor();
            brushInstance.setWidth(width);
            Toolbar.setForegroundColor(c);
        }
    }

    class Options
    implements DialogListener {
        Options() {
            if (BrushTool.this.gd != null) {
                BrushTool.this.gd.toFront();
                return;
            }
            BrushTool.this.options = this;
            this.showDialog();
        }

        public void showDialog() {
            Color color = Toolbar.getForegroundColor();
            String colorName = Colors.colorToString2(color);
            String name = BrushTool.this.isPencil ? "Pencil" : "Brush";
            BrushTool.this.gd = new NonBlockingGenericDialog(name + " Options");
            BrushTool.this.gd.addSlider(name + " width:", 1.0, 50.0, BrushTool.this.width);
            BrushTool.this.gd.addChoice("Color:", Colors.getColors(colorName), colorName);
            BrushTool.this.gd.addCheckbox("Paint on overlay", BrushTool.this.paintOnOverlay);
            BrushTool.this.gd.setInsets(10, 10, 0);
            String ctrlString = IJ.isMacintosh() ? "CMD" : "CTRL";
            BrushTool.this.gd.addMessage("SHIFT for horizontal or vertical lines\nALT to draw in background color (or\nto erase if painting on overlay)\n" + ctrlString + "-SHIFT-drag to change " + (BrushTool.this.isPencil ? "pencil" : "brush") + " width\n" + ctrlString + "-(ALT) click to change foreground\n(background) color, or use Color Picker", null, Color.darkGray);
            BrushTool.this.gd.hideCancelButton();
            BrushTool.this.gd.addHelp("");
            BrushTool.this.gd.setHelpLabel("Undo");
            BrushTool.this.gd.setOKLabel("Close");
            BrushTool.this.gd.addDialogListener(this);
            Point loc = Prefs.getLocation(BrushTool.LOC_KEY);
            if (loc != null) {
                BrushTool.this.gd.centerDialog(false);
                BrushTool.this.gd.setLocation(loc);
            }
            BrushTool.this.gd.showDialog();
            Prefs.saveLocation(BrushTool.LOC_KEY, BrushTool.this.gd.getLocation());
            BrushTool.this.gd = null;
        }

        @Override
        public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
            if (e != null && e.toString().contains("Undo")) {
                ImagePlus imp = WindowManager.getCurrentImage();
                if (imp != null) {
                    IJ.run("Undo");
                }
                return true;
            }
            BrushTool.this.width = (int)gd.getNextNumber();
            if (gd.invalidNumber() || BrushTool.this.width < 0) {
                BrushTool.this.width = (int)Prefs.get(BrushTool.this.widthKey, 1.0);
            }
            String colorName = gd.getNextChoice();
            BrushTool.this.paintOnOverlay = gd.getNextBoolean();
            Color color = Colors.decode(colorName, null);
            Toolbar.setForegroundColor(color);
            Prefs.set(BrushTool.this.widthKey, BrushTool.this.width);
            return true;
        }
    }
}

