/*
 * Decompiled with CFR 0.152.
 */
package mikera.vectorz.ops;

import mikera.vectorz.AVector;
import mikera.vectorz.Op;
import mikera.vectorz.Op2;

public final class AddFunction
extends Op2 {
    private final double a;
    private final double b;
    private final Op f;

    public AddFunction(double a, double b, Op f) {
        this.a = a;
        this.b = b;
        this.f = f;
    }

    public static AddFunction create(Op f) {
        return new AddFunction(1.0, 1.0, f);
    }

    public static AddFunction create(double b, Op f) {
        return new AddFunction(1.0, b, f);
    }

    public static AddFunction create(double a, double b, Op f) {
        return new AddFunction(a, b, f);
    }

    @Override
    public double apply(double x, double y) {
        return this.a * x + this.b * this.f.apply(x);
    }

    @Override
    public void applyTo(double[] data, int start, int length, AVector b) {
        b.checkLength(length);
        for (int i = 0; i < length; ++i) {
            double x = data[start + i];
            data[start + i] = this.apply(x, b.unsafeGet(i));
        }
    }
}

