/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.impl;

import mikera.matrixx.AMatrix;
import mikera.matrixx.Matrixx;
import mikera.matrixx.impl.ADiagonalMatrix;
import mikera.vectorz.AVector;
import mikera.vectorz.Vector;
import mikera.vectorz.impl.ADenseArrayVector;
import mikera.vectorz.util.ErrorMessages;
import mikera.vectorz.util.VectorzException;

public final class WrappedDiagonalMatrix
extends ADiagonalMatrix {
    private static final long serialVersionUID = -6721785163444613243L;
    private final AVector lead;

    public WrappedDiagonalMatrix(int dimensions) {
        super(dimensions);
        this.lead = Vector.createLength(dimensions);
    }

    private WrappedDiagonalMatrix(double ... values) {
        super(values.length);
        this.lead = Vector.wrap(values);
    }

    private WrappedDiagonalMatrix(AVector leadingDiagonal) {
        super(leadingDiagonal.length());
        this.lead = leadingDiagonal;
    }

    public static WrappedDiagonalMatrix createDimensions(int dims) {
        return new WrappedDiagonalMatrix(dims);
    }

    public static WrappedDiagonalMatrix create(double ... values) {
        int dimensions = values.length;
        double[] data = new double[dimensions];
        System.arraycopy(values, 0, data, 0, dimensions);
        return new WrappedDiagonalMatrix(data);
    }

    public static WrappedDiagonalMatrix create(AVector v) {
        return WrappedDiagonalMatrix.wrap(v.clone());
    }

    public static WrappedDiagonalMatrix create(AMatrix m) {
        if (!m.isDiagonal()) {
            throw new IllegalArgumentException("Source is not a diagonal matrix!");
        }
        return WrappedDiagonalMatrix.wrap(m.getLeadingDiagonal().toDoubleArray());
    }

    public static WrappedDiagonalMatrix wrap(double[] data) {
        return new WrappedDiagonalMatrix(data);
    }

    public static WrappedDiagonalMatrix wrap(AVector data) {
        return new WrappedDiagonalMatrix(data);
    }

    @Override
    public void addSparse(double c) {
        this.lead.addSparse(c);
    }

    @Override
    public void setSparse(AMatrix a) {
        this.checkSameShape(a);
        this.lead.set(a.getLeadingDiagonal());
    }

    @Override
    public double trace() {
        return this.lead.elementSum();
    }

    @Override
    public double diagonalProduct() {
        return this.lead.elementProduct();
    }

    @Override
    public double elementSum() {
        return this.lead.elementSum();
    }

    @Override
    public long nonZeroCount() {
        return this.lead.nonZeroCount();
    }

    @Override
    public double get(int row, int column) {
        if (row != column) {
            this.checkIndex(row, column);
            return 0.0;
        }
        return this.lead.get(row);
    }

    @Override
    public double unsafeGet(int row, int column) {
        if (row != column) {
            return 0.0;
        }
        return this.lead.unsafeGet(row);
    }

    @Override
    public void set(int row, int column, double value) {
        this.checkIndex(row, column);
        if (row != column) {
            if (value != 0.0) {
                throw new UnsupportedOperationException(ErrorMessages.notFullyMutable(this, row, column));
            }
        } else {
            this.lead.unsafeSet(row, value);
        }
    }

    @Override
    public void unsafeSet(int row, int column, double value) {
        if (row != column) {
            throw new UnsupportedOperationException(ErrorMessages.notFullyMutable(this, row, column));
        }
        this.lead.unsafeSet(row, value);
    }

    @Override
    public boolean isMutable() {
        return this.lead.isMutable();
    }

    @Override
    public boolean isFullyMutable() {
        return this.dimensions <= 1 && this.lead.isFullyMutable();
    }

    @Override
    public void multiply(double factor) {
        this.lead.multiply(factor);
    }

    @Override
    public WrappedDiagonalMatrix multiplyCopy(double factor) {
        return WrappedDiagonalMatrix.wrap(this.lead.multiplyCopy(factor));
    }

    @Override
    public double rowDotProduct(int i, AVector v) {
        return this.lead.unsafeGet(i) * v.unsafeGet(i);
    }

    @Override
    public void transform(Vector source, Vector dest) {
        dest.setInnerProduct(this, source);
    }

    @Override
    public void transformInPlace(AVector v) {
        v.multiply(this.lead);
    }

    @Override
    public void transformInPlace(ADenseArrayVector v) {
        v.multiply(this.lead);
    }

    @Override
    public boolean isIdentity() {
        return this.lead.elementsEqual(1.0);
    }

    @Override
    public boolean isBoolean() {
        return this.lead.isBoolean();
    }

    @Override
    public boolean isZero() {
        return this.lead.isZero();
    }

    @Override
    public AMatrix clone() {
        return Matrixx.create(this);
    }

    @Override
    public double determinant() {
        return this.lead.elementProduct();
    }

    @Override
    public WrappedDiagonalMatrix inverse() {
        if (this.lead.elementProduct() == 0.0) {
            return null;
        }
        return WrappedDiagonalMatrix.wrap(this.lead.reciprocalCopy());
    }

    @Override
    public double getDiagonalValue(int i) {
        return this.lead.get(i);
    }

    @Override
    public double unsafeGetDiagonalValue(int i) {
        return this.lead.unsafeGet(i);
    }

    @Override
    public AVector getLeadingDiagonal() {
        return this.lead;
    }

    @Override
    public AMatrix innerProduct(AMatrix a) {
        if (a instanceof ADiagonalMatrix) {
            return this.innerProduct((ADiagonalMatrix)a);
        }
        return super.innerProduct(a);
    }

    @Override
    public AMatrix innerProduct(ADiagonalMatrix a) {
        if (this.dimensions != a.dimensions) {
            throw new IllegalArgumentException(ErrorMessages.mismatch(this, a));
        }
        AVector newLead = this.lead.clone();
        newLead.multiply(a.getLeadingDiagonal());
        return WrappedDiagonalMatrix.wrap(newLead);
    }

    @Override
    public WrappedDiagonalMatrix exactClone() {
        return WrappedDiagonalMatrix.wrap(this.lead.exactClone());
    }

    @Override
    public void validate() {
        if (this.dimensions != this.lead.length()) {
            throw new VectorzException("dimension mismatch: " + this.dimensions);
        }
        super.validate();
    }
}

