/*
 * Decompiled with CFR 0.152.
 */
package mikera.matrixx.algo;

import mikera.matrixx.AMatrix;
import mikera.matrixx.decompose.ISVDResult;
import mikera.matrixx.decompose.SVD;
import mikera.vectorz.AVector;

public class Rank {
    private static double DEFAULT_THRESHOLD = 2.220446E-15;

    private Rank() {
    }

    public static int compute(AMatrix A) {
        return Rank.compute(A, DEFAULT_THRESHOLD);
    }

    public static int compute(AMatrix A, double threshold) {
        ISVDResult ans = SVD.decompose(A, true);
        int rank = 0;
        AVector singularValues = ans.getSingularValues();
        int n = singularValues.length();
        for (int i = 0; i < n; ++i) {
            if (!(singularValues.unsafeGet(i) >= threshold)) continue;
            ++rank;
        }
        return rank;
    }

    public static int compute(ISVDResult result) {
        return Rank.compute(result, DEFAULT_THRESHOLD);
    }

    public static int compute(ISVDResult result, double threshold) {
        int rank = 0;
        AVector singularValues = result.getSingularValues();
        for (double s : singularValues) {
            if (!(s > threshold)) continue;
            ++rank;
        }
        return rank;
    }
}

