/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.generic;

import jdistlib.rng.MersenneTwister;
import jdistlib.rng.RandomEngine;

public abstract class GenericDistribution {
    protected RandomEngine random = new MersenneTwister();

    public abstract double density(double var1, boolean var3);

    public abstract double cumulative(double var1, boolean var3, boolean var4);

    public abstract double quantile(double var1, boolean var3, boolean var4);

    public abstract double random();

    public double[] density(double[] x, boolean log) {
        int n = x.length;
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = this.density(x[i], log);
        }
        return v;
    }

    public double[] density(double[] x) {
        return this.density(x, false);
    }

    public double cumulative(double p) {
        return this.cumulative(p, true, false);
    }

    public double[] cumulative(double[] p, boolean lower_tail, boolean log_p) {
        int n = p.length;
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = this.cumulative(p[i], lower_tail, log_p);
        }
        return v;
    }

    public double[] cumulative(double[] p) {
        return this.cumulative(p, true, false);
    }

    public double[] quantile(double[] q, boolean lower_tail, boolean log_p) {
        int n = q.length;
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = this.quantile(q[i], lower_tail, log_p);
        }
        return v;
    }

    public double[] quantile(double[] q) {
        return this.quantile(q, true, false);
    }

    public double quantile(double q) {
        return this.quantile(q, true, false);
    }

    public double[] random(int n) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = this.random();
        }
        return rand;
    }

    public double hazard(double t, boolean give_log) {
        double pdf = this.density(t, true);
        double cdf = this.cumulative(t, false, true);
        return give_log ? pdf - cdf : Math.exp(pdf - cdf);
    }

    public double[] hazard(double[] t, boolean give_log) {
        int n = t.length;
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = this.hazard(t[i], give_log);
        }
        return v;
    }

    public double cumulative_hazard(double p) {
        return -this.cumulative(p, false, true);
    }

    public double[] cumulative_hazard(double[] p) {
        int n = p.length;
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = this.cumulative(p[i], false, true);
        }
        return v;
    }

    public double survival(double p, boolean log_p) {
        return this.cumulative(p, false, log_p);
    }

    public double[] survival(double[] p, boolean log_p) {
        int n = p.length;
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = this.cumulative(p[i], false, log_p);
        }
        return v;
    }

    public double[] survival(double[] p) {
        return this.cumulative(p, false, false);
    }

    public double inverse_survival(double p, boolean log_p) {
        return this.quantile(p, false, log_p);
    }

    public double[] inverse_survival(double[] p, boolean log_p) {
        int n = p.length;
        double[] v = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = this.quantile(p[i], false, log_p);
        }
        return v;
    }

    public void setRandomEngine(RandomEngine r) {
        this.random = r;
    }

    public RandomEngine getRandomEngine() {
        return this.random;
    }

    public double random(RandomEngine r) {
        RandomEngine temp = this.random;
        this.random = r;
        double v = this.random();
        this.random = temp;
        return v;
    }
}

