/*
 * Decompiled with CFR 0.152.
 */
package jdistlib.evd;

import jdistlib.Beta;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.math.UnivariateFunction;
import jdistlib.math.opt.Optimization;
import jdistlib.rng.RandomEngine;

public class Order
extends GenericDistribution {
    protected int mlen;
    protected int j;
    protected boolean largest;
    protected GenericDistribution dist;

    public static final double density(double x, GenericDistribution dist, int mlen, int j, boolean largest, boolean log) {
        double dens;
        if (mlen <= 0 || j <= 0 || j > mlen) {
            return Double.NaN;
        }
        if (!largest) {
            j = mlen + 1 - j;
        }
        if (MathFunctions.isInfinite(dens = dist.density(x, true))) {
            return Double.NEGATIVE_INFINITY;
        }
        double cum = dist.cumulative(x, true, log);
        cum = (double)(mlen - j) * Math.log(cum) + (double)(j - 1) * Math.log(1.0 - cum);
        x = MathFunctions.lgammafn(mlen + 1) - MathFunctions.lgammafn(j) - MathFunctions.lgammafn(mlen - j + 1) + dens + cum;
        return !log ? Math.exp(x) : x;
    }

    public static final double cumulative(double q, GenericDistribution dist, int mlen, int j, boolean largest, boolean lower_tail) {
        return Order.cumulative(q, dist, mlen, j, largest, lower_tail, false);
    }

    public static final double cumulative(double q, GenericDistribution dist, int mlen, int j, boolean largest, boolean lower_tail, boolean log_p) {
        if (mlen <= 0 || j <= 0 || j > mlen) {
            return Double.NaN;
        }
        int from = largest ? mlen + 1 - j : 0;
        double distn = dist.cumulative(q, lower_tail, false);
        double sum = 0.0;
        for (int k = 1; k <= j; ++k) {
            int sveck = from + k - 1;
            sum += Math.exp(MathFunctions.lgammafn(mlen + 1) - MathFunctions.lgammafn(sveck + 1) - MathFunctions.lgammafn(mlen - sveck + 1) + (double)sveck * Math.log(distn) + (double)(mlen - sveck) * Math.log(1.0 - distn));
        }
        double p = largest != lower_tail ? 1.0 - sum : sum;
        return log_p ? Math.log(p) : p;
    }

    public static final double quantile(double q, GenericDistribution dist, int mlen, int j, boolean largest, boolean lower_tail, boolean log_p) {
        double x;
        if (log_p) {
            q = Math.exp(q);
        }
        UnivariateFunction fun = new UnivariateFunction(){
            double q;
            int mlen;
            int j;
            boolean largest;
            boolean lower_tail;
            boolean log_p;
            GenericDistribution dist;

            @Override
            public void setParameters(double ... params) {
                this.q = params[0];
                this.mlen = (int)params[1];
                this.j = (int)params[2];
                this.largest = params[3] != 0.0;
                this.lower_tail = params[4] != 0.0;
                this.log_p = params[5] != 0.0;
            }

            @Override
            public void setObjects(Object ... obj) {
                this.dist = (GenericDistribution)obj[0];
            }

            @Override
            public double eval(double x) {
                double val = Order.cumulative(x, this.dist, this.mlen, this.j, this.largest, this.lower_tail, this.log_p);
                return (val -= this.q) * val;
            }
        };
        fun.setParameters(q, mlen, j, largest ? 1.0 : 0.0, lower_tail ? 1.0 : 0.0, log_p ? 1.0 : 0.0);
        fun.setObjects(dist);
        double min = -20.0;
        double max = 20.0;
        while (true) {
            if ((x = Math.floor(Optimization.zeroin(fun, min, max, 1.0E-20, 10000))) == min) {
                max = min;
                min *= 2.0;
                continue;
            }
            if (x != max) break;
            min = max;
            max *= 2.0;
        }
        double inc = lower_tail ? -1.0 : 1.0;
        double val = Order.cumulative(x, dist, mlen, j, largest, lower_tail, log_p);
        while (!((val = Order.cumulative(x += inc, dist, mlen, j, largest, lower_tail, log_p)) < q)) {
        }
        double last_x = x;
        if (last_x > (x -= inc)) {
            double temp = last_x;
            last_x = x;
            x = temp;
        }
        x = Math.floor(Optimization.optimize(fun, last_x, x, 1.0E-20, 10000));
        return x;
    }

    public static final double random(GenericDistribution dist, int mlen, int j, boolean largest, RandomEngine random) {
        if (!largest) {
            j = mlen + 1 - j;
        }
        double value = Beta.random(mlen + 1 - j, j, random);
        return dist.quantile(value, true, false);
    }

    public static final double[] random(int n, GenericDistribution dist, int mlen, int j, boolean largest, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Order.random(dist, mlen, j, largest, random);
        }
        return rand;
    }

    public Order(GenericDistribution dist, int mlen, int j, boolean largest) {
        this.dist = dist;
        this.mlen = mlen;
        this.j = j;
        this.largest = largest;
    }

    @Override
    public double density(double x, boolean log) {
        return Order.density(x, this.dist, this.mlen, this.j, this.largest, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Order.cumulative(p, this.dist, this.mlen, this.j, this.largest, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Order.quantile(q, this.dist, this.mlen, this.j, this.largest, lower_tail, log_p);
    }

    @Override
    public double random() {
        return Order.random(this.dist, this.mlen, this.j, this.largest, this.random);
    }
}

