/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;

public class Wilcoxon
extends GenericDistribution {
    protected double[][][] w;

    public Wilcoxon(int m, int n) {
        if (m > n) {
            int i = n;
            n = m;
            m = i;
        }
        this.w = new double[m + 1][n + 1][];
    }

    public int getM() {
        return this.w.length - 1;
    }

    public int getN() {
        return this.w[0].length - 1;
    }

    protected double count(int k, int m, int n) {
        int j;
        int i;
        int u = m * n;
        if (k < 0 || k > u) {
            return 0.0;
        }
        int c = u / 2;
        if (k > c) {
            k = u - k;
        }
        if (m < n) {
            i = m;
            j = n;
        } else {
            i = n;
            j = m;
        }
        if (j == 0) {
            return k == 0 ? 1.0 : 0.0;
        }
        if (j > 0 && k < j) {
            return this.count(k, i, k);
        }
        if (this.w[i][j] == null) {
            this.w[i][j] = new double[c + 1];
            for (int l = 0; l <= c; ++l) {
                this.w[i][j][l] = -1.0;
            }
        }
        if (this.w[i][j][k] < 0.0) {
            this.w[i][j][k] = j == 0 ? (k == 0 ? 1.0 : 0.0) : this.count(k - j, i - 1, j) + this.count(k, i, j - 1);
        }
        return this.w[i][j][k];
    }

    public double density(int x, boolean give_log) {
        int m = this.w.length - 1;
        int n = this.w[0].length - 1;
        if (Double.isNaN(x) || Double.isNaN(m) || Double.isNaN(n)) {
            return x + m + n;
        }
        if (m <= 0 || n <= 0) {
            return Double.NaN;
        }
        if (x < 0 || x > m * n) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        double d = give_log ? Math.log(this.count(x, m, n)) - MathFunctions.lchoose(m + n, n) : this.count(x, m, n) / MathFunctions.choose(m + n, n);
        return d;
    }

    public double cumulative(int q, boolean lower_tail, boolean log_p) {
        int m = this.w.length - 1;
        int n = this.w[0].length - 1;
        if (Double.isNaN(q) || Double.isNaN(m) || Double.isNaN(n)) {
            return q + m + n;
        }
        if (MathFunctions.isInfinite(m) || MathFunctions.isInfinite(n)) {
            return Double.NaN;
        }
        if (m <= 0 || n <= 0) {
            return Double.NaN;
        }
        if ((double)q < 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (q >= m * n) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        double c = MathFunctions.choose(m + n, n);
        double p = 0.0;
        if (q <= m * n / 2) {
            for (int i = 0; i <= q; ++i) {
                p += this.count(i, m, n) / c;
            }
        } else {
            q = m * n - q;
            for (int i = 0; i < q; ++i) {
                p += this.count(i, m, n) / c;
            }
            boolean bl = lower_tail = !lower_tail;
        }
        return lower_tail ? (log_p ? Math.log(p) : p) : (log_p ? Math.log1p(-p) : 0.5 - p + 0.5);
    }

    @Override
    public double quantile(double x, boolean lower_tail, boolean log_p) {
        int m = this.w.length - 1;
        int n = this.w[0].length - 1;
        if (Double.isNaN(x) || Double.isNaN(m) || Double.isNaN(n)) {
            return x + (double)m + (double)n;
        }
        if (MathFunctions.isInfinite(x) || MathFunctions.isInfinite(m) || MathFunctions.isInfinite(n)) {
            return Double.NaN;
        }
        if (log_p && x > 0.0 || !log_p && (x < 0.0 || x > 1.0)) {
            return Double.NaN;
        }
        if (m <= 0 || n <= 0) {
            return Double.NaN;
        }
        if (x == (lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0))) {
            return 0.0;
        }
        if (x == (lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0))) {
            return m * n;
        }
        if (log_p || !lower_tail) {
            x = log_p ? (lower_tail ? Math.exp(x) : -Math.expm1(x)) : (lower_tail ? x : 0.5 - x + 0.5);
        }
        double c = MathFunctions.choose(m + n, n);
        double p = 0.0;
        int q = 0;
        if (x <= 0.5) {
            x -= 2.220446049250313E-15;
            while (!((p += this.count(q, m, n) / c) >= x)) {
                ++q;
            }
        } else {
            x = 1.0 - x + 2.220446049250313E-15;
            while (true) {
                if ((p += this.count(q, m, n) / c) > x) {
                    q = m * n - q;
                    break;
                }
                ++q;
            }
        }
        return q;
    }

    @Override
    public double random() {
        int i;
        int m = this.w.length - 1;
        int n = this.w[0].length - 1;
        if (Double.isNaN(m) || Double.isNaN(n)) {
            return m + n;
        }
        if (m < 0 || n < 0) {
            return Double.NaN;
        }
        if (m == 0 || n == 0) {
            return 0.0;
        }
        double r = 0.0;
        int k = m + n;
        int[] x = new int[k];
        for (i = 0; i < k; ++i) {
            x[i] = i;
        }
        for (i = 0; i < n; ++i) {
            int j = (int)Math.floor((double)k * this.random.nextDouble());
            r += (double)x[j];
            x[j] = x[--k];
        }
        x = null;
        return r - (double)(n * (n - 1) / 2);
    }

    @Override
    public double density(double x, boolean log) {
        if (Math.abs(x - Math.rint(x)) > 1.0E-7) {
            return 0.0;
        }
        return this.density((int)x, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return this.cumulative((int)p, lower_tail, log_p);
    }
}

