/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.generic.GenericDistribution;
import jdistlib.rng.RandomEngine;

public class Laplace
extends GenericDistribution {
    protected double location;
    protected double scale;

    public static final double density(double x, double location, double scale, boolean give_log) {
        if (Double.isNaN(location) || Double.isInfinite(scale)) {
            return location + scale;
        }
        double v = -Math.abs(x - location) / scale - 0.6931471805599453 - Math.log(scale);
        return give_log ? v : Math.exp(v);
    }

    public static final double cumulative(double x, double location, double scale, boolean lower_tail, boolean log_p) {
        double p;
        if (Double.isNaN(location) || Double.isInfinite(scale)) {
            return location + scale;
        }
        double d = p = (x = (x - location) / scale) < 0.0 ? 0.5 * Math.exp(x) : 1.0 - 0.5 * Math.exp(-x);
        if (!lower_tail) {
            p = 1.0 - p;
        }
        if (log_p) {
            p = Math.log(p);
        }
        return p;
    }

    public static final double quantile(double p, double location, double scale, boolean lower_tail, boolean log_p) {
        if (log_p) {
            p = Math.exp(p);
        }
        if (!lower_tail) {
            p = 1.0 - p;
        }
        return location - Math.signum(p - 0.5) * scale * (0.6931471805599453 + Math.log(p < 0.5 ? p : 1.0 - p));
    }

    public static final double random(double location, double scale, RandomEngine random) {
        double u1 = random.nextDouble();
        u1 = ((double)((int)(1.34217728E8 * u1)) + random.nextDouble()) / 1.34217728E8;
        return location - Math.signum(u1 - 0.5) * scale * (0.6931471805599453 + Math.log(u1 < 0.5 ? u1 : 1.0 - u1));
    }

    public static final double[] random(int n, double location, double scale, RandomEngine random) {
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Laplace.random(location, scale, random);
        }
        return rand;
    }

    public Laplace(double location, double scale) {
        this.location = location;
        this.scale = scale;
    }

    @Override
    public double density(double x, boolean log) {
        return Laplace.density(x, this.location, this.scale, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Laplace.cumulative(p, this.location, this.scale, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Laplace.quantile(q, this.location, this.scale, lower_tail, log_p);
    }

    @Override
    public double random() {
        return Laplace.random(this.location, this.scale, this.random);
    }
}

