/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.math.VectorMath;

public class DebugFun {
    public static final double rErr(double approx, double truval) {
        return DebugFun.rErr(approx, truval, 1.0E-30);
    }

    public static final double rErr(double approx, double truval, double eps) {
        return Math.abs(truval) >= eps ? 1.0 - approx / truval : approx - truval;
    }

    public static final boolean isEqual(double a, double b) {
        return VectorMath.isEqual(a, b, 1.4210854715202004E-14);
    }

    public static final boolean isEqualScaled(double a, double b) {
        return VectorMath.isEqualScaled(a, b, 1.4210854715202004E-14);
    }

    public static final boolean allEqual(double[] a, double[] b) {
        return VectorMath.allEqual(a, b, 1.4210854715202004E-14);
    }

    public static final boolean allEqualScaled(double[] a, double[] b) {
        return VectorMath.allEqualScaled(a, b, 1.4210854715202004E-14);
    }

    public static final boolean printBool(boolean b) {
        System.out.println(b ? "[1] TRUE" : "[1] FALSE");
        return b;
    }

    public static final boolean printBool(boolean ... b) {
        if (b == null || b.length == 0) {
            return false;
        }
        System.out.print("[1]");
        boolean bb = true;
        for (int i = 0; i < b.length; ++i) {
            System.out.print(b[i] ? " TRUE" : " FALSE");
            bb &= b[i];
        }
        System.out.println();
        return bb;
    }

    public static final boolean printAllEqual(double[] a, double[] b, double tol) {
        int i;
        boolean v = VectorMath.allEqual(a, b, tol);
        DebugFun.printBool(v);
        if (v) {
            return true;
        }
        int n = a.length;
        boolean[] vv = new boolean[n];
        for (i = 0; i < a.length; ++i) {
            vv[i] = VectorMath.isEqual(a[i], b[i], tol);
        }
        System.out.print("True values: ");
        for (i = 0; i < n; ++i) {
            if (vv[i]) continue;
            System.out.print(a[i] + " ");
        }
        System.out.println();
        System.out.print("Results: ");
        for (i = 0; i < n; ++i) {
            if (vv[i]) continue;
            System.out.print(b[i] + " ");
        }
        System.out.println();
        System.out.print("|Diff|: ");
        for (i = 0; i < n; ++i) {
            if (vv[i]) continue;
            System.out.print(Math.abs(a[i] - b[i]) + " ");
        }
        System.out.println();
        return false;
    }

    public static final boolean printAllEqual(double[] a, double[] b) {
        return DebugFun.printAllEqual(a, b, 1.4210854715202004E-14);
    }

    public static final boolean printAllEqualScaled(double[] a, double[] b, double tol) {
        int i;
        boolean v = VectorMath.allEqualScaled(a, b, tol);
        DebugFun.printBool(v);
        if (v) {
            return true;
        }
        int n = a.length;
        boolean[] vv = new boolean[n];
        for (i = 0; i < a.length; ++i) {
            vv[i] = VectorMath.isEqualScaled(a[i], b[i], tol);
        }
        System.out.print("True values: ");
        for (i = 0; i < n; ++i) {
            if (vv[i]) continue;
            System.out.print(a[i] + " ");
        }
        System.out.println();
        System.out.print("Results: ");
        for (i = 0; i < n; ++i) {
            if (vv[i]) continue;
            System.out.print(b[i] + " ");
        }
        System.out.println();
        System.out.print("Relative Diff: ");
        for (i = 0; i < n; ++i) {
            if (vv[i]) continue;
            System.out.print(Math.abs(a[i] - b[i]) / a[i] + " ");
        }
        System.out.println();
        return false;
    }

    public static final boolean printAllEqualScaled(double[] a, double[] b) {
        return DebugFun.printAllEqualScaled(a, b, 1.4210854715202004E-14);
    }
}

