/*
 * Decompiled with CFR 0.152.
 */
package jdistlib;

import jdistlib.Beta;
import jdistlib.Normal;
import jdistlib.generic.GenericDistribution;
import jdistlib.math.MathFunctions;
import jdistlib.rng.RandomEngine;

public class Binomial
extends GenericDistribution {
    protected double n;
    protected double p;
    protected RandomState state;

    public static final RandomState create_random_state() {
        return new RandomState();
    }

    public static final double density_raw(double x, double n, double p, double q, boolean log_p) {
        if (p == 0.0) {
            return x == 0.0 ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (q == 0.0) {
            return x == n ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        if (x == 0.0) {
            if (n == 0.0) {
                return log_p ? 0.0 : 1.0;
            }
            double lc = p < 0.1 ? -MathFunctions.bd0(n, n * q) - n * p : n * Math.log(q);
            return log_p ? lc : Math.exp(lc);
        }
        if (x == n) {
            double lc = q < 0.1 ? -MathFunctions.bd0(n, n * p) - n * q : n * Math.log(p);
            return log_p ? lc : Math.exp(lc);
        }
        if (x < 0.0 || x > n) {
            return log_p ? Double.NEGATIVE_INFINITY : 0.0;
        }
        double lc = MathFunctions.stirlerr(n) - MathFunctions.stirlerr(x) - MathFunctions.stirlerr(n - x) - MathFunctions.bd0(x, n * p) - MathFunctions.bd0(n - x, n * q);
        double lf = 1.8378770664093456 + Math.log(x) + Math.log1p(-x / n);
        return log_p ? lc - 0.5 * lf : Math.exp(lc - 0.5 * lf);
    }

    public static final double density(double x, double n, double p, boolean give_log) {
        if (Double.isNaN(x) || Double.isNaN(n) || Double.isNaN(p)) {
            return x + n + p;
        }
        if (p < 0.0 || p > 1.0 || n < 0.0 || MathFunctions.isNonInt(n)) {
            return Double.NaN;
        }
        if (MathFunctions.isNonInt(x)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        if (x < 0.0 || MathFunctions.isInfinite(x)) {
            return give_log ? Double.NEGATIVE_INFINITY : 0.0;
        }
        n = Math.rint(n);
        x = Math.rint(x);
        return Binomial.density_raw(x, n, p, 1.0 - p, give_log);
    }

    public static final double cumulative(double x, double n, double p, boolean lower_tail, boolean log_p) {
        if (Double.isNaN(x) || Double.isNaN(n) || Double.isNaN(p)) {
            return x + n + p;
        }
        if (MathFunctions.isInfinite(n) || MathFunctions.isInfinite(p)) {
            return Double.NaN;
        }
        if (MathFunctions.isNonInt(n)) {
            return Double.NaN;
        }
        if ((n = Math.rint(n)) < 0.0 || p < 0.0 || p > 1.0) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return lower_tail ? (log_p ? Double.NEGATIVE_INFINITY : 0.0) : (log_p ? 0.0 : 1.0);
        }
        if (n <= (x = Math.floor(x + 1.0E-7))) {
            return lower_tail ? (log_p ? 0.0 : 1.0) : (log_p ? Double.NEGATIVE_INFINITY : 0.0);
        }
        return Beta.cumulative(p, x + 1.0, n - x, !lower_tail, log_p);
    }

    static final double do_search(double y, double[] z, double p, double n, double pr, double incr) {
        if (z[0] >= p) {
            while (true) {
                double newz = Binomial.cumulative(y - incr, n, pr, true, false);
                if (y == 0.0 || newz < p) {
                    return y;
                }
                y = Math.max(0.0, y - incr);
                z[0] = newz;
            }
        }
        while ((y = Math.min(y + incr, n)) != n) {
            double d;
            z[0] = Binomial.cumulative(y, n, pr, true, false);
            if (!(d >= p)) continue;
        }
        return y;
    }

    public static final double quantile(double p, double n, double pr, boolean lower_tail, boolean log_p) {
        double oldincr;
        if (Double.isNaN(p) || Double.isNaN(n) || Double.isNaN(pr)) {
            return p + n + pr;
        }
        if (MathFunctions.isInfinite(n) || MathFunctions.isInfinite(pr)) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(p) && !log_p) {
            return Double.NaN;
        }
        if (n != Math.rint(n)) {
            return Double.NaN;
        }
        if (pr < 0.0 || pr > 1.0 || n < 0.0) {
            return Double.NaN;
        }
        if (log_p) {
            if (p > 0.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? n : 0.0;
            }
            if (p == Double.NEGATIVE_INFINITY) {
                return lower_tail ? 0.0 : n;
            }
        } else {
            if (p < 0.0 || p > 1.0) {
                return Double.NaN;
            }
            if (p == 0.0) {
                return lower_tail ? 0.0 : n;
            }
            if (p == 1.0) {
                return lower_tail ? n : 0.0;
            }
        }
        if (pr == 0.0 || n == 0.0) {
            return 0.0;
        }
        double q = 1.0 - pr;
        if (q == 0.0) {
            return n;
        }
        double mu = n * pr;
        double sigma = Math.sqrt(n * pr * q);
        double gamma = (q - pr) / sigma;
        if (!lower_tail || log_p) {
            double d = log_p ? (lower_tail ? Math.exp(p) : -Math.expm1(p)) : (p = lower_tail ? p : 0.5 - p + 0.5);
            if (p == 0.0) {
                return 0.0;
            }
            if (p == 1.0) {
                return n;
            }
        }
        if (p + 2.242650509742816E-16 >= 1.0) {
            return n;
        }
        double z = Normal.quantile(p, 0.0, 1.0, true, false);
        double y = Math.rint(mu + sigma * (z + gamma * (z * z - 1.0) / 6.0));
        if (y > n) {
            y = n;
        }
        z = Binomial.cumulative(y, n, pr, true, false);
        p *= 0.9999999999999858;
        double[] zp = new double[]{z};
        if (n < 100000.0) {
            return Binomial.do_search(y, zp, p, n, pr, 1.0);
        }
        double incr = Math.floor(n * 0.001);
        do {
            oldincr = incr;
            y = Binomial.do_search(y, zp, p, n, pr, incr);
            incr = Math.max(1.0, Math.floor(incr / 100.0));
        } while (oldincr > 1.0 && incr > n * 1.0E-15);
        return y;
    }

    public static final double random(double nin, double pp, RandomEngine random) {
        return Binomial.random(nin, pp, random, null);
    }

    public static final double random(double nin, double pp, RandomEngine random, RandomState state) {
        int ix;
        if (state == null) {
            state = new RandomState();
        }
        if (MathFunctions.isInfinite(nin)) {
            return Double.NaN;
        }
        double r = Math.rint(nin);
        if (r != nin) {
            return Double.NaN;
        }
        if (MathFunctions.isInfinite(pp) || r < 0.0 || pp < 0.0 || pp > 1.0) {
            return Double.NaN;
        }
        if (r == 0.0 || pp == 0.0) {
            return 0.0;
        }
        if (pp == 1.0) {
            return r;
        }
        if (r >= 2.147483647E9) {
            return Binomial.quantile(random.nextDouble(), r, pp, false, false);
        }
        int n = (int)r;
        double p = Math.min(pp, 1.0 - pp);
        double q = 1.0 - p;
        double np = (double)n * p;
        r = p / q;
        double g = r * (double)(n + 1);
        if (pp != state.psave || n != state.nsave) {
            state.psave = pp;
            state.nsave = n;
            if (np < 30.0) {
                state.qn = Math.pow(q, n);
                block0: while (true) {
                    int ix2 = 0;
                    double f = state.qn;
                    double u = random.nextDouble();
                    while (true) {
                        if (u < f) {
                            if (state.psave > 0.5) {
                                ix2 = n - ix2;
                            }
                            return ix2;
                        }
                        if (ix2 > 110) continue block0;
                        u -= f;
                        f *= g / (double)(++ix2) - r;
                    }
                    break;
                }
            }
            double ffm = np + p;
            state.m = (int)ffm;
            state.fm = state.m;
            state.npq = np * q;
            state.p1 = (double)((int)(2.195 * Math.sqrt(state.npq) - 4.6 * q)) + 0.5;
            state.xm = state.fm + 0.5;
            state.xl = state.xm - state.p1;
            state.xr = state.xm + state.p1;
            state.c = 0.134 + 20.5 / (15.3 + state.fm);
            double al = (ffm - state.xl) / (ffm - state.xl * p);
            state.xll = al * (1.0 + 0.5 * al);
            al = (state.xr - ffm) / (state.xr * q);
            state.xlr = al * (1.0 + 0.5 * al);
            state.p2 = state.p1 * (1.0 + state.c + state.c);
            state.p3 = state.p2 + state.c / state.xll;
            state.p4 = state.p3 + state.c / state.xlr;
        } else if (n == state.nsave && np < 30.0) {
            block2: while (true) {
                int ix3 = 0;
                double f = state.qn;
                double u = random.nextDouble();
                while (true) {
                    if (u < f) {
                        if (state.psave > 0.5) {
                            ix3 = n - ix3;
                        }
                        return ix3;
                    }
                    if (ix3 > 110) continue block2;
                    u -= f;
                    f *= g / (double)(++ix3) - r;
                }
                break;
            }
        }
        while (true) {
            double u = random.nextDouble() * state.p4;
            double v = random.nextDouble();
            if (u <= state.p1) {
                ix = (int)(state.xm - state.p1 * v + u);
                if (state.psave > 0.5) {
                    ix = n - ix;
                }
                return ix;
            }
            if (u <= state.p2) {
                double x = state.xl + (u - state.p1) / state.c;
                if ((v = v * state.c + 1.0 - Math.abs(state.xm - x) / state.p1) > 1.0 || v <= 0.0) continue;
                ix = (int)x;
            } else if (u > state.p3) {
                ix = (int)(state.xr - Math.log(v) / state.xlr);
                if (ix > n) continue;
                v = v * (u - state.p3) * state.xlr;
            } else {
                ix = (int)(state.xl + Math.log(v) / state.xll);
                if (ix < 0) continue;
                v = v * (u - state.p2) * state.xll;
            }
            int k = Math.abs(ix - state.m);
            if (k <= 20 || (double)k >= state.npq / 2.0 - 1.0) {
                int i;
                double f = 1.0;
                if (state.m < ix) {
                    for (i = state.m + 1; i <= ix; ++i) {
                        f *= g / (double)i - r;
                    }
                } else if (state.m != ix) {
                    for (i = ix + 1; i <= state.m; ++i) {
                        f /= g / (double)i - r;
                    }
                }
                if (!(v <= f)) continue;
                if (state.psave > 0.5) {
                    ix = n - ix;
                }
                return ix;
            }
            double amaxp = (double)k / state.npq * (((double)k * ((double)k / 3.0 + 0.625) + 0.1666666666666) / state.npq + 0.5);
            double ynorm = (double)(-k * k) / (2.0 * state.npq);
            double alv = Math.log(v);
            if (alv < ynorm - amaxp) {
                if (state.psave > 0.5) {
                    ix = n - ix;
                }
                return ix;
            }
            if (!(alv <= ynorm + amaxp)) continue;
            double x1 = ix + 1;
            double f1 = state.fm + 1.0;
            double z = (double)(n + 1) - state.fm;
            double w = (double)(n - ix) + 1.0;
            double z2 = z * z;
            double x2 = x1 * x1;
            double f2 = f1 * f1;
            double w2 = w * w;
            if (alv <= state.xm * Math.log(f1 / x1) + ((double)(n - state.m) + 0.5) * Math.log(z / w) + (double)(ix - state.m) * Math.log(w * p / (x1 * q)) + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / f2) / f2) / f2) / f2) / f1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / z2) / z2) / z2) / z2) / z / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / x2) / x2) / x2) / x2) / x1 / 166320.0 + (13860.0 - (462.0 - (132.0 - (99.0 - 140.0 / w2) / w2) / w2) / w2) / w / 166320.0) break;
        }
        if (state.psave > 0.5) {
            ix = n - ix;
        }
        return ix;
    }

    public static final double[] random(int n, double nin, double pp, RandomEngine random) {
        return Binomial.random(n, nin, pp, random, Binomial.create_random_state());
    }

    public static final double[] random(int n, double nin, double pp, RandomEngine random, RandomState state) {
        if (state == null) {
            state = Binomial.create_random_state();
        }
        double[] rand = new double[n];
        for (int i = 0; i < n; ++i) {
            rand[i] = Binomial.random(nin, pp, random, state);
        }
        return rand;
    }

    public Binomial(double n, double p) {
        this.n = n;
        this.p = p;
        this.state = Binomial.create_random_state();
    }

    @Override
    public double density(double x, boolean log) {
        return Binomial.density(x, this.n, this.p, log);
    }

    @Override
    public double cumulative(double p, boolean lower_tail, boolean log_p) {
        return Binomial.cumulative(p, this.n, this.p, lower_tail, log_p);
    }

    @Override
    public double quantile(double q, boolean lower_tail, boolean log_p) {
        return Binomial.quantile(q, this.n, this.p, lower_tail, log_p);
    }

    @Override
    public double random() {
        return Binomial.random(this.n, this.p, this.random, this.state);
    }

    @Override
    public double[] random(int ct) {
        return Binomial.random(ct, this.n, this.p, this.random, this.state);
    }

    public static class RandomState {
        public double c;
        public double fm;
        public double npq;
        public double p1;
        public double p2;
        public double p3;
        public double p4;
        public double qn;
        public double xl;
        public double xll;
        public double xlr;
        public double xm;
        public double xr;
        public double psave = -1.0;
        public int nsave = -1;
        public int m;
    }
}

