/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d.line;

import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.line.StraightLine2D;
import math.geom3d.Box3D;
import math.geom3d.Point3D;
import math.geom3d.Shape3D;
import math.geom3d.Vector3D;
import math.geom3d.curve.ContinuousCurve3D;
import math.geom3d.curve.Curve3D;
import math.geom3d.plane.Plane3D;
import math.geom3d.transform.AffineTransform3D;

public class StraightLine3D
implements ContinuousCurve3D {
    protected double x0 = 0.0;
    protected double y0 = 0.0;
    protected double z0 = 0.0;
    protected double dx = 1.0;
    protected double dy = 0.0;
    protected double dz = 0.0;

    public StraightLine3D() {
    }

    public StraightLine3D(Point3D origin, Vector3D direction) {
        this.x0 = origin.getX();
        this.y0 = origin.getY();
        this.z0 = origin.getZ();
        this.dx = direction.getX();
        this.dy = direction.getY();
        this.dz = direction.getZ();
    }

    public StraightLine3D(Point3D p1, Point3D p2) {
        this(p1, new Vector3D(p1, p2));
    }

    public StraightLine3D(double x0, double y0, double z0, double dx, double dy, double dz) {
        this.x0 = x0;
        this.y0 = y0;
        this.z0 = z0;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
    }

    public Point3D origin() {
        return new Point3D(this.x0, this.y0, this.z0);
    }

    public Vector3D direction() {
        return new Vector3D(this.dx, this.dy, this.dz);
    }

    public StraightLine2D project(Plane3D plane) {
        return null;
    }

    @Override
    public Shape3D clip(Box3D box) {
        return null;
    }

    @Override
    public boolean contains(Point3D point) {
        return this.distance(point) < 1.0E-12;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public Box3D boundingBox() {
        Vector3D v = this.direction();
        if (Math.hypot(v.getY(), v.getZ()) < 1.0E-12) {
            return new Box3D(this.x0, this.x0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (Math.hypot(v.getX(), v.getZ()) < 1.0E-12) {
            return new Box3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.y0, this.y0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        }
        if (Math.hypot(v.getX(), v.getY()) < 1.0E-12) {
            return new Box3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.z0, this.z0);
        }
        return new Box3D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public double distance(Point3D p) {
        Vector3D vl = this.direction();
        Vector3D vp = new Vector3D(this.origin(), p);
        return Vector3D.crossProduct(vl, vp).norm() / vl.norm();
    }

    @Override
    public StraightLine3D transform(AffineTransform3D trans) {
        return new StraightLine3D(this.origin().transform(trans), this.direction().transform(trans));
    }

    @Override
    public Point3D firstPoint() {
        return new Point3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public Point3D lastPoint() {
        return new Point3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public Point3D point(double t) {
        return new Point3D(this.x0 + t * this.dx, this.y0 + t * this.dy, this.z0 + t * this.dz);
    }

    @Override
    public double position(Point3D point) {
        return this.project(point);
    }

    @Override
    public StraightLine3D reverseCurve() {
        return new StraightLine3D(this.origin(), this.direction().opposite());
    }

    @Override
    public Collection<Point3D> singularPoints() {
        return new ArrayList<Point3D>(0);
    }

    @Override
    public Curve3D subCurve(double t0, double t1) {
        return null;
    }

    @Override
    public double getT0() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getT1() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double project(Point3D point) {
        Vector3D vl = this.direction();
        Vector3D vp = new Vector3D(this.origin(), point);
        return Vector3D.dotProduct(vl, vp) / vl.normSq();
    }

    public Collection<StraightLine3D> continuousCurves() {
        ArrayList<StraightLine3D> array = new ArrayList<StraightLine3D>(1);
        array.add(this);
        return array;
    }
}

