/*
 * Decompiled with CFR 0.152.
 */
package math.geom3d;

import math.geom3d.Point3D;
import math.geom3d.transform.AffineTransform3D;

public class Vector3D {
    protected double x = 1.0;
    protected double y = 0.0;
    protected double z = 0.0;

    public static final double dotProduct(Vector3D v1, Vector3D v2) {
        return v1.x * v2.x + v1.y * v2.y + v1.z * v2.z;
    }

    public static final Vector3D crossProduct(Vector3D v1, Vector3D v2) {
        return new Vector3D(v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x);
    }

    public static final boolean isColinear(Vector3D v1, Vector3D v2) {
        return Vector3D.crossProduct(v1 = v1.normalize(), v2 = v2.normalize()).norm() < 1.0E-12;
    }

    public static final boolean isOrthogonal(Vector3D v1, Vector3D v2) {
        double dot = Vector3D.dotProduct(v1 = v1.normalize(), v2 = v2.normalize());
        return Math.abs(dot) < 1.0E-12;
    }

    public Vector3D() {
        this(1.0, 0.0, 0.0);
    }

    public Vector3D(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3D(Point3D point) {
        this(point.getX(), point.getY(), point.getZ());
    }

    public Vector3D(Point3D point1, Point3D point2) {
        this(point2.getX() - point1.getX(), point2.getY() - point1.getY(), point2.getZ() - point1.getZ());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public Vector3D plus(Vector3D v) {
        return new Vector3D(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vector3D minus(Vector3D v) {
        return new Vector3D(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public Vector3D times(double k) {
        return new Vector3D(k * this.x, k * this.y, k * this.z);
    }

    public Vector3D opposite() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    public double norm() {
        return Math.hypot(Math.hypot(this.x, this.y), this.z);
    }

    public double normSq() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3D normalize() {
        double r = this.norm();
        return new Vector3D(this.x / r, this.y / r, this.z / r);
    }

    public Vector3D transform(AffineTransform3D trans) {
        double[] tab = trans.coefficients();
        return new Vector3D(this.x * tab[0] + this.y * tab[1] + this.z * tab[2], this.x * tab[4] + this.y * tab[5] + this.z * tab[6], this.x * tab[8] + this.y * tab[9] + this.z * tab[10]);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Vector3D)) {
            return false;
        }
        Vector3D v = (Vector3D)obj;
        if (Math.abs(this.x - v.x) > 1.0E-12) {
            return false;
        }
        if (Math.abs(this.y - v.y) > 1.0E-12) {
            return false;
        }
        return !(Math.abs(this.z - v.z) > 1.0E-12);
    }
}

