/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.domain;

import java.util.ArrayList;
import java.util.Iterator;
import math.geom2d.Box2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedBox2DException;
import math.geom2d.curve.ContinuousCurve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.domain.Boundary2D;
import math.geom2d.domain.BoundaryPolyCurve2D;
import math.geom2d.domain.ContinuousOrientedCurve2D;
import math.geom2d.domain.Contour2D;
import math.geom2d.domain.ContourArray2D;
import math.geom2d.polygon.Polyline2D;

public abstract class Boundaries2D {
    public static final CurveSet2D<ContinuousOrientedCurve2D> clipContinuousOrientedCurve(ContinuousOrientedCurve2D curve, Box2D box) {
        CurveArray2D<ContinuousOrientedCurve2D> result = new CurveArray2D<ContinuousOrientedCurve2D>();
        for (ContinuousCurve2D cont : Curves2D.clipContinuousCurve(curve, box)) {
            if (!(cont instanceof ContinuousOrientedCurve2D)) continue;
            result.add((ContinuousOrientedCurve2D)cont);
        }
        return result;
    }

    public static final ContourArray2D<Contour2D> clipBoundary(Boundary2D boundary, Box2D box) {
        Point2D vertex;
        ContinuousOrientedCurve2D curve;
        if (!box.isBounded()) {
            throw new UnboundedBox2DException(box);
        }
        ContourArray2D<Contour2D> res = new ContourArray2D<Contour2D>();
        CurveArray2D<ContinuousOrientedCurve2D> curveSet = new CurveArray2D<ContinuousOrientedCurve2D>();
        for (Contour2D contour2D : boundary.continuousCurves()) {
            CurveSet2D<ContinuousOrientedCurve2D> clipped = Boundaries2D.clipContinuousOrientedCurve(contour2D, box);
            for (ContinuousOrientedCurve2D clip : clipped) {
                curveSet.add(clip);
            }
        }
        int nc = curveSet.size();
        double[] dArray = new double[nc];
        double[] endPositions = new double[nc];
        boolean intersect = false;
        ContinuousOrientedCurve2D[] curves = new ContinuousOrientedCurve2D[nc];
        Boundary2D boxBoundary = box.boundary();
        Iterator iter = curveSet.curves().iterator();
        for (int i = 0; i < nc; ++i) {
            curves[i] = curve = (ContinuousOrientedCurve2D)iter.next();
            if (curve.isClosed()) {
                dArray[i] = Double.NaN;
                endPositions[i] = Double.NaN;
                continue;
            }
            dArray[i] = boxBoundary.position(curve.firstPoint());
            endPositions[i] = boxBoundary.position(curve.lastPoint());
            intersect = true;
        }
        int nb = nc;
        int c = 0;
        while (c < nb) {
            int ind = c;
            while (curves[ind] == null) {
                ++ind;
            }
            curve = curves[ind];
            if (curve.isClosed()) {
                if (curve instanceof Contour2D) {
                    res.add((Contour2D)curve);
                } else {
                    BoundaryPolyCurve2D<ContinuousOrientedCurve2D> bnd = new BoundaryPolyCurve2D<ContinuousOrientedCurve2D>();
                    bnd.add(curve);
                    res.add(bnd);
                }
                curves[ind] = null;
                ++c;
                continue;
            }
            BoundaryPolyCurve2D<ContinuousOrientedCurve2D> boundary0 = new BoundaryPolyCurve2D<ContinuousOrientedCurve2D>();
            boundary0.add(curve);
            Point2D p0 = curve.firstPoint();
            Point2D p1 = curve.lastPoint();
            int ind0 = ind;
            ArrayList<Integer> indices = new ArrayList<Integer>();
            indices.add(new Integer(ind));
            ind = Boundaries2D.findNextCurveIndex(dArray, endPositions[ind0]);
            while (ind != ind0) {
                curve = curves[ind];
                Point2D p0i = curve.firstPoint();
                boundary0.add(Boundaries2D.getBoundaryPortion(box, p1, p0i));
                boundary0.add(curve);
                indices.add(new Integer(ind));
                ind = Boundaries2D.findNextCurveIndex(dArray, endPositions[ind]);
                p1 = curve.lastPoint();
                --nb;
            }
            boundary0.add(Boundaries2D.getBoundaryPortion(box, p1, p0));
            res.add(boundary0);
            Iterator iter2 = indices.iterator();
            while (iter2.hasNext()) {
                curves[((Integer)iter2.next()).intValue()] = null;
            }
            ++c;
        }
        if (!intersect && boundary.isInside(vertex = box.vertices().iterator().next())) {
            res.add((Contour2D)((CurveArray2D)((Object)box.asRectangle().boundary())).firstCurve());
        }
        return res;
    }

    public static final int findNextCurveIndex(double[] positions, double pos) {
        int i;
        int ind = -1;
        double posMin = Double.MAX_VALUE;
        for (i = 0; i < positions.length; ++i) {
            if (Double.isNaN(positions[i]) || positions[i] - pos < 1.0E-12 || !(positions[i] < posMin)) continue;
            ind = i;
            posMin = positions[i];
        }
        if (ind != -1) {
            return ind;
        }
        for (i = 0; i < positions.length; ++i) {
            if (Double.isNaN(positions[i]) || !(positions[i] - posMin < 1.0E-12)) continue;
            ind = i;
            posMin = positions[i];
        }
        return ind;
    }

    public static final Polyline2D getBoundaryPortion(Box2D box, Point2D p0, Point2D p1) {
        int ind1;
        Boundary2D boundary = box.boundary();
        double t0 = boundary.position(p0);
        double t1 = boundary.position(p1);
        int ind0 = (int)Math.floor(t0);
        if (ind0 == (ind1 = (int)Math.floor(t1)) && t0 < t1) {
            return new Polyline2D(p0, p1);
        }
        ArrayList<Point2D> vertices = new ArrayList<Point2D>(6);
        vertices.add(p0);
        int ind = (ind0 + 1) % 4;
        while (ind != ind1) {
            vertices.add(boundary.point(ind));
            ind = (ind + 1) % 4;
        }
        vertices.add(boundary.point(ind));
        vertices.add(p1);
        return new Polyline2D(vertices);
    }
}

