/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.conic;

import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Angle2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedShape2DException;
import math.geom2d.Vector2D;
import math.geom2d.conic.Conic2D;
import math.geom2d.conic.ParabolaArc2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.domain.Contour2D;
import math.geom2d.domain.Domain2D;
import math.geom2d.domain.GenericDomain2D;
import math.geom2d.line.LinearShape2D;
import math.geom2d.line.StraightLine2D;
import math.utils.EqualUtils;

public class Parabola2D
extends AbstractSmoothCurve2D
implements Contour2D,
Conic2D,
Cloneable {
    protected double xv = 0.0;
    protected double yv = 0.0;
    protected double theta = 0.0;
    protected double a = 1.0;
    private boolean debug = false;

    public static final Parabola2D create(Point2D vertex, Point2D focus) {
        double p = Point2D.distance(vertex, focus);
        double theta = Angle2D.horizontalAngle(vertex, focus) - 1.5707963267948966;
        return new Parabola2D(vertex, 1.0 / (4.0 * p), theta);
    }

    public Parabola2D() {
    }

    public Parabola2D(Point2D vertex, double a, double theta) {
        this(vertex.x(), vertex.y(), a, theta);
    }

    public Parabola2D(double xv, double yv, double a, double theta) {
        this.xv = xv;
        this.yv = yv;
        this.a = a;
        this.theta = theta;
    }

    public Point2D getFocus() {
        double c = 1.0 / this.a / 4.0;
        return new Point2D(this.xv - c * Math.sin(this.theta), this.yv + c * Math.cos(this.theta));
    }

    public double getParameter() {
        return this.a;
    }

    public double getFocusDistance() {
        return 1.0 / (4.0 * this.a);
    }

    public Point2D getVertex() {
        return new Point2D(this.xv, this.yv);
    }

    public Vector2D getVector1() {
        Vector2D vect = new Vector2D(1.0, 0.0);
        return vect.transform(AffineTransform2D.createRotation(this.theta));
    }

    public Vector2D getVector2() {
        Vector2D vect = new Vector2D(1.0, 0.0);
        return vect.transform(AffineTransform2D.createRotation(this.theta + 1.5707963267948966));
    }

    public double getAngle() {
        return this.theta;
    }

    public boolean isDirect() {
        return this.a > 0.0;
    }

    private Point2D formatPoint(Point2D point) {
        Point2D p2 = point;
        p2 = p2.transform(AffineTransform2D.createTranslation(-this.xv, -this.yv));
        p2 = p2.transform(AffineTransform2D.createRotation(-this.theta));
        p2 = p2.transform(AffineTransform2D.createScaling(1.0, 1.0 / this.a));
        return p2;
    }

    private LinearShape2D formatLine(LinearShape2D line) {
        line = line.transform(AffineTransform2D.createTranslation(-this.xv, -this.yv));
        line = line.transform(AffineTransform2D.createRotation(-this.theta));
        line = line.transform(AffineTransform2D.createScaling(1.0, 1.0 / this.a));
        return line;
    }

    @Override
    public Conic2D.Type conicType() {
        return Conic2D.Type.PARABOLA;
    }

    @Override
    public double[] conicCoefficients() {
        AffineTransform2D transform = AffineTransform2D.createRotation(this.theta).chain(AffineTransform2D.createTranslation(this.xv, this.yv));
        double[][] coefs = transform.invert().affineMatrix();
        double m00 = coefs[0][0];
        double m01 = coefs[0][1];
        double m02 = coefs[0][2];
        double m10 = coefs[1][0];
        double m11 = coefs[1][1];
        double m12 = coefs[1][2];
        double A = this.a * m00 * m00;
        double B = 2.0 * this.a * m00 * m01;
        double C = this.a * m01 * m01;
        double D = 2.0 * this.a * m00 * m02 - m10;
        double E = 2.0 * this.a * m01 * m02 - m11;
        double F = this.a * m02 * m02 - m12;
        return new double[]{A, B, C, D, E, F};
    }

    @Override
    public double eccentricity() {
        return 1.0;
    }

    @Override
    public Domain2D domain() {
        return new GenericDomain2D(this);
    }

    @Override
    public double windingAngle(Point2D point) {
        if (this.isDirect()) {
            if (this.isInside(point)) {
                return Math.PI * 2;
            }
            return 0.0;
        }
        if (this.isInside(point)) {
            return 0.0;
        }
        return Math.PI * -2;
    }

    @Override
    public double signedDistance(Point2D p) {
        return this.signedDistance(p.x(), p.y());
    }

    @Override
    public double signedDistance(double x, double y) {
        if (this.isInside(new Point2D(x, y))) {
            return -this.distance(x, y);
        }
        return -this.distance(x, y);
    }

    @Override
    public boolean isInside(Point2D point) {
        Point2D p2 = this.formatPoint(point);
        double x = p2.x();
        double y = p2.y();
        return y > x * x ^ this.a < 0.0;
    }

    @Override
    public Vector2D tangent(double t) {
        Vector2D vect = new Vector2D(1.0, 2.0 * this.a * t);
        return vect.transform(AffineTransform2D.createRotation(this.theta));
    }

    @Override
    public double curvature(double t) {
        return 2.0 * this.a / Math.pow(Math.hypot(1.0, 2.0 * this.a * t), 3.0);
    }

    public Collection<? extends Parabola2D> continuousCurves() {
        return Parabola2D.wrapCurve(this);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public double t0() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Point2D point(double t) {
        Point2D point = new Point2D(t, this.a * t * t);
        point = AffineTransform2D.createRotation(this.theta).transform(point);
        point = AffineTransform2D.createTranslation(this.xv, this.yv).transform(point);
        return point;
    }

    @Override
    public double position(Point2D point) {
        return this.formatPoint(point).x();
    }

    @Override
    public double project(Point2D point) {
        return this.formatPoint(point).x();
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        double x;
        Point2D point;
        double y0;
        LinearShape2D line2 = this.formatLine(line);
        double dx = line2.direction().x();
        double dy = line2.direction().y();
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        if (Math.abs(dx) < 1.0E-12) {
            double x2;
            Point2D point2;
            if (this.debug) {
                System.out.println("intersect parabola with vertical line ");
            }
            if (line2.contains(point2 = new Point2D(x2 = line2.origin().x(), x2 * x2))) {
                points.add(line.point(line2.position(point2)));
            }
            return points;
        }
        double k = dy / dx;
        Point2D origin = line2.origin();
        double x0 = origin.x();
        double yl = k * x0 - (y0 = origin.y());
        double delta = k * k - 4.0 * yl;
        if (delta < 0.0) {
            return points;
        }
        StraightLine2D support = line2.supportingLine();
        if (line2.contains(support.projectedPoint(point = new Point2D(x = (k - Math.sqrt(delta)) * 0.5, x * x)))) {
            points.add(line.point(line2.position(point)));
        }
        if (line2.contains(support.projectedPoint(point = new Point2D(x = (k + Math.sqrt(delta)) * 0.5, x * x)))) {
            points.add(line.point(line2.position(point)));
        }
        return points;
    }

    @Override
    public Parabola2D reverse() {
        return new Parabola2D(this.xv, this.yv, -this.a, Angle2D.formatAngle(this.theta + Math.PI));
    }

    @Override
    public ParabolaArc2D subCurve(double t0, double t1) {
        if (this.debug) {
            System.out.println("theta = " + Math.toDegrees(this.theta));
        }
        if (t1 < t0) {
            return null;
        }
        return new ParabolaArc2D(this, t0, t1);
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.x(), p.y());
    }

    @Override
    public double distance(double x, double y) {
        return new ParabolaArc2D(this, -100.0, 100.0).distance(x, y);
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        throw new UnboundedShape2DException(this);
    }

    @Override
    public void fill(Graphics2D g2) {
        throw new UnboundedShape2DException(this);
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public CurveSet2D<ParabolaArc2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curves2D.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<ParabolaArc2D> result = new CurveArray2D<ParabolaArc2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof ParabolaArc2D)) continue;
            result.add((ParabolaArc2D)curve2D);
        }
        return result;
    }

    @Override
    public Box2D boundingBox() {
        return new Box2D(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
    }

    @Override
    public Parabola2D transform(AffineTransform2D trans) {
        Point2D vertex = this.getVertex().transform(trans);
        Point2D focus = this.getFocus().transform(trans);
        double a = 1.0 / (4.0 * Point2D.distance(vertex, focus));
        double theta = Angle2D.horizontalAngle(vertex, focus) - 1.5707963267948966;
        if (this.a < 0.0 ^ trans.isDirect()) {
            return new Parabola2D(vertex, a, theta);
        }
        return new Parabola2D(vertex, -a, theta + Math.PI);
    }

    @Override
    public boolean contains(double x, double y) {
        Point2D p2 = this.formatPoint(new Point2D(x, y));
        double xp = p2.x();
        double yp = p2.y();
        return Math.abs(yp - xp * xp) < 1.0E-12;
    }

    @Override
    public boolean contains(Point2D point) {
        return this.contains(point.x(), point.y());
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Parabola2D)) {
            return false;
        }
        Parabola2D parabola = (Parabola2D)obj;
        if (this.xv - parabola.xv > eps) {
            return false;
        }
        if (this.yv - parabola.yv > eps) {
            return false;
        }
        if (this.a - parabola.a > eps) {
            return false;
        }
        return Angle2D.almostEquals(this.theta, parabola.theta, eps);
    }

    public String toString() {
        return String.format("Parabola2D(%f,%f,%f,%f)", this.xv, this.yv, this.a, this.theta);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Parabola2D)) {
            return false;
        }
        Parabola2D that = (Parabola2D)obj;
        if (!EqualUtils.areEqual(this.xv, that.xv)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.yv, that.yv)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.a, that.a)) {
            return false;
        }
        return EqualUtils.areEqual(this.theta, that.theta);
    }

    @Override
    @Deprecated
    public Parabola2D clone() {
        return new Parabola2D(this.xv, this.yv, this.a, this.theta);
    }
}

