/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.conic;

import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.UnboundedShape2DException;
import math.geom2d.Vector2D;
import math.geom2d.conic.Hyperbola2D;
import math.geom2d.conic.HyperbolaBranch2D;
import math.geom2d.curve.AbstractSmoothCurve2D;
import math.geom2d.curve.Curve2D;
import math.geom2d.curve.CurveArray2D;
import math.geom2d.curve.CurveSet2D;
import math.geom2d.curve.Curves2D;
import math.geom2d.curve.SmoothCurve2D;
import math.geom2d.domain.SmoothOrientedCurve2D;
import math.geom2d.line.LinearShape2D;
import math.utils.EqualUtils;

public class HyperbolaBranchArc2D
extends AbstractSmoothCurve2D
implements SmoothOrientedCurve2D,
Cloneable {
    HyperbolaBranch2D branch = null;
    double t0 = 0.0;
    double t1 = 1.0;

    public static HyperbolaBranchArc2D create(HyperbolaBranch2D branch, double t0, double t1) {
        return new HyperbolaBranchArc2D(branch, t0, t1);
    }

    public HyperbolaBranchArc2D(HyperbolaBranch2D branch, double t0, double t1) {
        this.branch = branch;
        this.t0 = t0;
        this.t1 = t1;
    }

    public HyperbolaBranch2D getHyperbolaBranch() {
        return this.branch;
    }

    @Override
    public double curvature(double t) {
        return this.branch.curvature(t);
    }

    @Override
    public Vector2D tangent(double t) {
        return this.branch.tangent(t);
    }

    @Override
    public double signedDistance(Point2D point) {
        return this.signedDistance(point.x(), point.y());
    }

    @Override
    public double signedDistance(double x, double y) {
        return 0.0;
    }

    @Override
    public double windingAngle(Point2D point) {
        return 0.0;
    }

    @Override
    public boolean isInside(Point2D pt) {
        return false;
    }

    @Override
    public GeneralPath appendPath(GeneralPath path) {
        return this.asPolyline(60).appendPath(path);
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public Collection<Point2D> intersections(LinearShape2D line) {
        Collection<Point2D> inters0 = this.branch.intersections(line);
        ArrayList<Point2D> inters = new ArrayList<Point2D>();
        for (Point2D point : inters0) {
            double pos = this.branch.project(point);
            if (!(pos > this.t0) || !(pos < this.t1)) continue;
            inters.add(point);
        }
        return inters;
    }

    @Override
    public Point2D point(double t) {
        if (Double.isInfinite(t)) {
            throw new UnboundedShape2DException(this);
        }
        t = Math.min(Math.max(t, this.t0), this.t1);
        return this.branch.point(t);
    }

    @Override
    public double position(Point2D point) {
        if (!this.branch.contains(point)) {
            return Double.NaN;
        }
        double t = this.branch.position(point);
        if (t - this.t0 < -1.0E-12) {
            return Double.NaN;
        }
        if (this.t1 - t < 1.0E-12) {
            return Double.NaN;
        }
        return t;
    }

    @Override
    public double project(Point2D point) {
        double t = this.branch.project(point);
        return Math.min(Math.max(t, this.t0), this.t1);
    }

    @Override
    public HyperbolaBranchArc2D reverse() {
        Hyperbola2D hyper = this.branch.hyperbola;
        Hyperbola2D hyper2 = new Hyperbola2D(hyper.xc, hyper.yc, hyper.a, hyper.b, hyper.theta, !hyper.direct);
        return new HyperbolaBranchArc2D(new HyperbolaBranch2D(hyper2, this.branch.positive), -this.t1, -this.t0);
    }

    @Override
    public HyperbolaBranchArc2D subCurve(double t0, double t1) {
        if (t1 < t0) {
            return null;
        }
        t0 = Math.max(this.t0, t0);
        t1 = Math.min(this.t1, t1);
        return new HyperbolaBranchArc2D(this.branch, t0, t1);
    }

    @Override
    public double t0() {
        return this.t0;
    }

    @Override
    @Deprecated
    public double getT0() {
        return this.t0();
    }

    @Override
    public double t1() {
        return this.t1;
    }

    @Override
    @Deprecated
    public double getT1() {
        return this.t1();
    }

    @Override
    public Box2D boundingBox() {
        if (!this.isBounded()) {
            throw new UnboundedShape2DException(this);
        }
        return this.asPolyline(100).boundingBox();
    }

    @Override
    public CurveSet2D<? extends HyperbolaBranchArc2D> clip(Box2D box) {
        CurveSet2D<SmoothCurve2D> set = Curves2D.clipSmoothCurve((SmoothCurve2D)this, box);
        CurveArray2D<HyperbolaBranchArc2D> result = new CurveArray2D<HyperbolaBranchArc2D>(set.size());
        for (Curve2D curve2D : set.curves()) {
            if (!(curve2D instanceof HyperbolaBranchArc2D)) continue;
            result.add((HyperbolaBranchArc2D)curve2D);
        }
        return result;
    }

    @Override
    public double distance(Point2D point) {
        Point2D p = this.point(this.project(point));
        return p.distance(point);
    }

    @Override
    public double distance(double x, double y) {
        Point2D p = this.point(this.project(new Point2D(x, y)));
        return p.distance(x, y);
    }

    @Override
    public boolean isBounded() {
        if (this.t0 == Double.NEGATIVE_INFINITY) {
            return false;
        }
        return this.t1 != Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public HyperbolaBranchArc2D transform(AffineTransform2D trans) {
        double endPos;
        HyperbolaBranch2D branch2 = this.branch.transform(trans);
        double startPos = Double.isInfinite(this.t0) ? Double.NEGATIVE_INFINITY : branch2.project(this.firstPoint().transform(trans));
        double d = endPos = Double.isInfinite(this.t1) ? Double.POSITIVE_INFINITY : branch2.project(this.lastPoint().transform(trans));
        if (startPos > endPos) {
            return new HyperbolaBranchArc2D(branch2.reverse(), endPos, startPos);
        }
        return new HyperbolaBranchArc2D(branch2, startPos, endPos);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public boolean contains(double x, double y) {
        if (!this.branch.contains(x, y)) {
            return false;
        }
        double t = this.branch.position(new Point2D(x, y));
        if (t < this.t0) {
            return false;
        }
        return !(t > this.t1);
    }

    public GeneralPath getGeneralPath() {
        if (!this.isBounded()) {
            throw new UnboundedShape2DException(this);
        }
        return this.asPolyline(100).asGeneralPath();
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof HyperbolaBranchArc2D)) {
            return false;
        }
        HyperbolaBranchArc2D arc = (HyperbolaBranchArc2D)obj;
        if (!this.branch.almostEquals(arc.branch, eps)) {
            return false;
        }
        if (Math.abs(this.t0 - arc.t0) > eps) {
            return false;
        }
        return !(Math.abs(this.t1 - arc.t1) > eps);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HyperbolaBranchArc2D)) {
            return false;
        }
        HyperbolaBranchArc2D that = (HyperbolaBranchArc2D)obj;
        if (!this.branch.equals(that.branch)) {
            return false;
        }
        if (!EqualUtils.areEqual(this.t0, that.t0)) {
            return false;
        }
        return EqualUtils.areEqual(this.t1, that.t1);
    }

    @Override
    public HyperbolaBranchArc2D clone() {
        return new HyperbolaBranchArc2D(this.branch, this.t0, this.t1);
    }
}

