/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d.circulinear.buffer;

import math.geom2d.Angle2D;
import math.geom2d.Point2D;
import math.geom2d.Vector2D;
import math.geom2d.circulinear.CirculinearContinuousCurve2D;
import math.geom2d.circulinear.buffer.CapFactory;
import math.geom2d.conic.CircleArc2D;

public class RoundCapFactory
implements CapFactory {
    @Override
    public CirculinearContinuousCurve2D createCap(Point2D center, Vector2D direction, double dist) {
        double angle = direction.angle();
        double angle1 = Angle2D.formatAngle(angle - 1.5707963267948966);
        double angle2 = Angle2D.formatAngle(angle + 1.5707963267948966);
        return new CircleArc2D(center, dist, angle1, angle2, true);
    }

    @Override
    public CirculinearContinuousCurve2D createCap(Point2D p1, Point2D p2) {
        Point2D center = Point2D.midPoint(p1, p2);
        double radius = p1.distance(p2) / 2.0;
        double angle1 = Angle2D.horizontalAngle(center, p1);
        double angle2 = Angle2D.horizontalAngle(center, p2);
        return new CircleArc2D(center, radius, angle1, angle2, true);
    }
}

