/*
 * Decompiled with CFR 0.152.
 */
package math.geom2d;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import math.geom2d.AffineTransform2D;
import math.geom2d.Box2D;
import math.geom2d.GeometricObject2D;
import math.geom2d.Point2D;
import math.geom2d.Shape2D;
import math.geom2d.ShapeSet2D;

public class ShapeArray2D<T extends Shape2D>
implements ShapeSet2D<T>,
Cloneable {
    protected ArrayList<T> shapes;

    public static <T extends Shape2D> ShapeArray2D<T> create(Collection<T> shapes) {
        return new ShapeArray2D<T>(shapes);
    }

    public static <T extends Shape2D> ShapeArray2D<T> create(T ... shapes) {
        return new ShapeArray2D(shapes);
    }

    public ShapeArray2D() {
        this.shapes = new ArrayList();
    }

    public ShapeArray2D(int n) {
        this.shapes = new ArrayList(n);
    }

    public ShapeArray2D(Collection<? extends T> shapes) {
        this.shapes = new ArrayList(shapes.size());
        this.shapes.addAll(shapes);
    }

    public ShapeArray2D(T[] shapes) {
        this.shapes = new ArrayList(shapes.length);
        for (T shape : shapes) {
            this.shapes.add(shape);
        }
    }

    @Override
    public boolean add(T shape) {
        if (this.shapes.contains(shape)) {
            return false;
        }
        return this.shapes.add(shape);
    }

    @Override
    public void add(int index, T shape) {
        this.shapes.add(index, shape);
    }

    @Override
    public T get(int index) {
        return (T)((Shape2D)this.shapes.get(index));
    }

    @Override
    public boolean remove(T shape) {
        return this.shapes.remove(shape);
    }

    @Override
    public T remove(int index) {
        return (T)((Shape2D)this.shapes.remove(index));
    }

    @Override
    public boolean contains(T shape) {
        return this.shapes.contains(shape);
    }

    @Override
    public int indexOf(T shape) {
        return this.shapes.indexOf(shape);
    }

    @Override
    public void clear() {
        this.shapes.clear();
    }

    @Override
    public int size() {
        return this.shapes.size();
    }

    public Collection<T> shapes() {
        return this.shapes;
    }

    @Override
    public Shape2D clip(Box2D box) {
        ArrayList<Shape2D> clippedShapes = new ArrayList<Shape2D>(this.size());
        for (Shape2D shape : this.shapes) {
            clippedShapes.add(shape.clip(box));
        }
        return new ShapeArray2D(clippedShapes);
    }

    @Override
    public boolean contains(double x, double y) {
        for (Shape2D shape : this.shapes) {
            if (!shape.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x(), p.y());
    }

    @Override
    public void draw(Graphics2D g2) {
        for (Shape2D shape : this.shapes) {
            shape.draw(g2);
        }
    }

    @Override
    public Box2D boundingBox() {
        double xmin = Double.MAX_VALUE;
        double ymin = Double.MAX_VALUE;
        double xmax = Double.MIN_VALUE;
        double ymax = Double.MIN_VALUE;
        for (Shape2D shape : this.shapes) {
            Box2D box = shape.boundingBox();
            xmin = Math.min(xmin, box.getMinX());
            ymin = Math.min(ymin, box.getMinY());
            xmax = Math.max(xmax, box.getMaxX());
            ymax = Math.max(ymax, box.getMaxY());
        }
        return new Box2D(xmin, xmax, ymin, ymax);
    }

    @Override
    public double distance(Point2D p) {
        return this.distance(p.x(), p.y());
    }

    @Override
    public double distance(double x, double y) {
        double dist = Double.POSITIVE_INFINITY;
        for (Shape2D shape : this.shapes) {
            dist = Math.min(dist, shape.distance(x, y));
        }
        return dist;
    }

    @Override
    public boolean isBounded() {
        for (Shape2D shape : this.shapes) {
            if (shape.isBounded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.shapes.isEmpty();
    }

    @Override
    public ShapeSet2D<? extends Shape2D> transform(AffineTransform2D trans) {
        ShapeArray2D<Shape2D> result = new ShapeArray2D<Shape2D>(this.shapes.size());
        for (Shape2D shape : this.shapes) {
            result.add(shape.transform(trans));
        }
        return result;
    }

    @Override
    public boolean almostEquals(GeometricObject2D obj, double eps) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShapeSet2D)) {
            return false;
        }
        ShapeArray2D shapeSet = (ShapeArray2D)obj;
        if (this.shapes.size() != shapeSet.shapes.size()) {
            return false;
        }
        Iterator<T> iter2 = shapeSet.shapes.iterator();
        for (Shape2D shape : this.shapes) {
            if (shape.almostEquals((GeometricObject2D)iter2.next(), eps)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.shapes.iterator();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ShapeSet2D)) {
            return false;
        }
        ShapeArray2D shapeSet = (ShapeArray2D)obj;
        if (this.shapes.size() != shapeSet.shapes.size()) {
            return false;
        }
        Iterator<T> iter2 = shapeSet.shapes.iterator();
        for (Shape2D shape : this.shapes) {
            if (shape.equals(iter2.next())) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public ShapeArray2D<? extends Shape2D> clone() {
        ArrayList<Shape2D> array = new ArrayList<Shape2D>(this.shapes.size());
        for (Shape2D shape : this.shapes) {
            array.add(shape);
        }
        return new ShapeArray2D(array);
    }
}

