/*
 * Decompiled with CFR 0.152.
 */
package jhpro.tseries;

import java.util.Vector;
import jhpro.tseries.Multiplet;
import jhpro.tseries.Peak;
import org.apache.commons.math3.util.FastMath;

public class PeakFinder {
    public Multiplet[] multiplets;
    public String name;
    private double[] spectrum;
    private double sensitivity;
    private double width;
    private double MAX_SEP = 1.3;
    private double SIGMA_TO_FWHM = 2.354;

    public PeakFinder(String name, double[] spectrum, double sensitivity, double width) {
        this.name = name;
        this.spectrum = spectrum;
        this.sensitivity = sensitivity;
        this.width = width;
        this.multiplets = this.peakFind();
    }

    public void setMaxSeparation(double sep) {
        this.MAX_SEP = sep;
    }

    private Multiplet[] peakFind() {
        int i;
        double maxSeparation = this.MAX_SEP;
        Multiplet peaks = new Multiplet();
        Multiplet currentMultiplet = new Multiplet();
        Vector<Multiplet> multiplets = new Vector<Multiplet>();
        double[] SC = new double[this.spectrum.length];
        double[] SCC = new double[this.spectrum.length];
        int filter_limit = (int)FastMath.ceil((double)(1.5 * this.width));
        double[] filter = new double[2 * filter_limit + 1];
        double[] filter2 = new double[2 * filter_limit + 1];
        double sigma = this.width / this.SIGMA_TO_FWHM;
        for (i = 0; i < filter.length; ++i) {
            int k = i - filter_limit;
            filter[i] = 2.0 * (sigma * sigma - (double)(k * k)) / (FastMath.sqrt((double)Math.PI) * sigma * sigma * sigma) * FastMath.exp((double)((double)(-(k * k)) / (2.0 * sigma * sigma)));
            filter2[i] = filter[i] * filter[i];
        }
        for (i = filter_limit; i < this.spectrum.length - filter_limit; ++i) {
            for (int j = 0; j < filter.length; ++j) {
                int l = j - filter_limit;
                int n = i;
                SC[n] = SC[n] + filter[j] * this.spectrum[i - l];
                int n2 = i;
                SCC[n2] = SCC[n2] + filter2[j] * this.spectrum[i - l];
            }
        }
        for (i = filter_limit + 1; i < this.spectrum.length - filter_limit - 1; ++i) {
            if (!(SC[i] > this.sensitivity * FastMath.sqrt((double)SCC[i])) || !(SC[i] > SC[i - 1]) || !(SC[i] > SC[i + 1])) continue;
            double posn = (SC[i - 1] * (double)(i - 1) + SC[i] * (double)i + SC[i + 1] * (double)(i + 1)) / (SC[i - 1] + SC[i] + SC[i + 1]);
            peaks.addPeak(new Peak(posn, SC[i], this.width));
        }
        for (i = 0; i < peaks.size(); ++i) {
            if (i == 0) {
                multiplets.addElement(currentMultiplet);
                currentMultiplet.addPeak(peaks.getPeak(i));
                continue;
            }
            if (peaks.getPeak(i).getPosition() - peaks.getPeak(i - 1).getPosition() > maxSeparation * this.width) {
                currentMultiplet = new Multiplet();
                multiplets.addElement(currentMultiplet);
                currentMultiplet.addPeak(peaks.getPeak(i));
                continue;
            }
            currentMultiplet.addPeak(peaks.getPeak(i));
        }
        Multiplet[] rval = new Multiplet[multiplets.size()];
        for (i = 0; i < rval.length; ++i) {
            rval[i] = (Multiplet)multiplets.elementAt(i);
            if (rval[i].size() <= 1) continue;
            Multiplet temp = new Multiplet();
            for (int j = 0; j < rval[i].size(); ++j) {
                double Knext;
                double Dnext;
                Peak nextPeak;
                Peak thisPeak;
                if (j == 0) {
                    thisPeak = rval[i].getPeak(j);
                    nextPeak = rval[i].getPeak(j + 1);
                    Dnext = thisPeak.getPosition() - nextPeak.getPosition();
                    Knext = Dnext * FastMath.exp((double)(-Dnext * Dnext / (4.0 * sigma * sigma))) * (1.0 - Dnext * Dnext / (6.0 * sigma * sigma));
                    double psnCorrection = nextPeak.getArea() * Knext / thisPeak.getArea();
                    temp.addPeak(new Peak(thisPeak.getPosition() + psnCorrection, thisPeak.getArea(), thisPeak.getWidth()));
                    continue;
                }
                if (j == rval[i].size() - 1) {
                    thisPeak = rval[i].getPeak(j);
                    Peak lastPeak = rval[i].getPeak(j - 1);
                    double Dlast = thisPeak.getPosition() - lastPeak.getPosition();
                    double Klast = Dlast * FastMath.exp((double)(-Dlast * Dlast / (4.0 * sigma * sigma))) * (1.0 - Dlast * Dlast / (6.0 * sigma * sigma));
                    double psnCorrection = lastPeak.getArea() * Klast / thisPeak.getArea();
                    temp.addPeak(new Peak(thisPeak.getPosition() + psnCorrection, thisPeak.getArea(), thisPeak.getWidth()));
                    continue;
                }
                thisPeak = rval[i].getPeak(j);
                nextPeak = rval[i].getPeak(j + 1);
                Dnext = thisPeak.getPosition() - nextPeak.getPosition();
                Knext = Dnext * FastMath.exp((double)(-Dnext * Dnext / (4.0 * sigma * sigma))) * (1.0 - Dnext * Dnext / (6.0 * sigma * sigma));
                Peak lastPeak = rval[i].getPeak(j - 1);
                double Dlast = thisPeak.getPosition() - lastPeak.getPosition();
                double Klast = Dlast * FastMath.exp((double)(-Dlast * Dlast / (4.0 * sigma * sigma))) * (1.0 - Dlast * Dlast / (6.0 * sigma * sigma));
                double psnCorrection = (nextPeak.getArea() * Knext + lastPeak.getArea() * Klast) / thisPeak.getArea();
                temp.addPeak(new Peak(thisPeak.getPosition() + psnCorrection, thisPeak.getArea(), thisPeak.getWidth()));
            }
            rval[i] = temp;
        }
        for (int m = 0; m < rval.length; ++m) {
            double trueArea = 0.0;
            double estArea = 0.0;
            for (int p = 0; p < rval[m].size(); ++p) {
                estArea += rval[m].getPeak(p).getArea();
            }
            for (int ch = (int)FastMath.round((double)(rval[m].getPeak(0).getPosition() - this.width * maxSeparation)); ch < (int)FastMath.round((double)(rval[m].getPeak(rval[m].size() - 1).getPosition() + this.width * maxSeparation)); ++ch) {
                trueArea += this.spectrum[ch];
            }
            double factor = trueArea / estArea;
            for (int p = 0; p < rval[m].size(); ++p) {
                double area = rval[m].getPeak(p).getArea();
                rval[m].getPeak(p).setArea(factor * area);
            }
        }
        return rval;
    }

    public double[] getCentroids() {
        int size = 0;
        for (int i = 0; i < this.multiplets.length; ++i) {
            size += this.multiplets[i].getAllCentroids().length;
        }
        double[] rval = new double[size];
        int pos = 0;
        for (int i = 0; i < this.multiplets.length; ++i) {
            double[] source = this.multiplets[i].getAllCentroids();
            System.arraycopy(source, 0, rval, pos, source.length);
            pos += source.length;
        }
        return rval;
    }

    public Multiplet[] getPeaks() {
        return this.multiplets;
    }
}

